/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.tileentity;

import cd4017be.api.grid.ExtGridPorts;
import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IDynamicPart;
import cd4017be.api.grid.IGridHost;
import cd4017be.api.grid.IPortHolder;
import cd4017be.api.grid.IWire;
import cd4017be.lib.Content;
import cd4017be.lib.block.BlockTE;
import cd4017be.lib.render.model.JitBakedModel;
import cd4017be.lib.render.model.TileEntityModel;
import cd4017be.lib.tick.GateUpdater;
import cd4017be.lib.tick.IGate;
import cd4017be.lib.tileentity.SyncTileEntity;
import cd4017be.lib.util.HashOutputStream;
import cd4017be.lib.util.Utils;
import cd4017be.lib.util.VoxelShape4x4x4;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;

public class Grid
extends SyncTileEntity
implements IGridHost,
BlockTE.ITEInteract,
BlockTE.ITEShape,
BlockTE.ITERedstone,
BlockTE.ITEBlockUpdate,
BlockTE.ITENeighborChange,
BlockTE.ITEPickItem,
IGate {
    private final ExtGridPorts extPorts = new ExtGridPorts(this);
    private final ArrayList<GridPart> parts = new ArrayList();
    public long opaque;
    public long inner;
    public IDynamicPart[] dynamicParts;
    private int tLoad;
    private boolean occlude;
    private boolean updateOccl;
    private static final long BOUNDARY = -7009493581825L;
    public static final long WALLS = 0x660699669960660L;

    public Grid(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public VoxelShape getShape(ISelectionContext context) {
        return new VoxelShape4x4x4(this.bounds()).shape();
    }

    @Override
    public ActionResultType onActivated(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return this.onInteract(player, hand, hit);
    }

    @Override
    public void onClicked(PlayerEntity player) {
        Vector3d from = player.func_174824_e(0.0f);
        Vector3d to = from.func_178787_e(player.func_70676_i(0.0f).func_186678_a(5.0));
        BlockRayTraceResult hit = this.getShape(null).func_212433_a(from, to, this.field_174879_c);
        if (hit != null) {
            this.onInteract(player, null, hit);
        }
    }

    @Override
    public void updateBounds() {
        long i = 0L;
        long o = 0L;
        for (GridPart part : this.parts) {
            byte l = part.getLayer();
            if (l >= 0) {
                o |= part.bounds;
            }
            if (l > 0) continue;
            i |= part.bounds;
        }
        this.inner = i;
        this.opaque = o;
        if (this.opaque != this.opaque && !this.updateOccl) {
            this.updateOccl = true;
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                GateUpdater.GATE_UPDATER.add(this);
            }
        }
    }

    @Override
    public GridPart findPart(Predicate<GridPart> filter) {
        for (GridPart part : this.parts) {
            if (!filter.test(part)) continue;
            return part;
        }
        return null;
    }

    @Override
    public void removePart(GridPart part) {
        if (!this.parts.remove(part) || this.unloaded) {
            return;
        }
        this.updateBounds();
        boolean wire = part instanceof IWire;
        for (int i = 0; i < part.ports.length; ++i) {
            short con = part.ports[i];
            if (this.extPorts.remove(con, wire)) continue;
            if (part.isMaster(i)) {
                part.setHandler(i, null);
                continue;
            }
            IPortHolder.Port port = this.findPort(part, con);
            if (port == null) continue;
            port.setHandler(null);
        }
        this.updateRedstone(part);
        part.setHost(null);
        this.clientDirty(true);
    }

    @Override
    public void removeIfEmpty() {
        if (this.parts.isEmpty()) {
            this.field_145850_b.func_217377_a(this.field_174879_c, false);
        }
    }

    @Override
    public boolean addPart(GridPart part) {
        if (part.host == this) {
            return true;
        }
        byte l = part.getLayer();
        if ((((l >= 0 ? this.opaque : 0L) | (l <= 0 ? this.inner : 0L)) & part.bounds) != 0L) {
            return false;
        }
        if (l >= 0) {
            this.opaque |= part.bounds;
        }
        if (l <= 0) {
            this.inner |= part.bounds;
        }
        part = part.setHost(this);
        this.parts.add(part);
        this.connectPart(part);
        this.updateRedstone(part);
        this.clientDirty(true);
        return true;
    }

    private void connectPart(GridPart part) {
        if (this.extPorts.createWire(part, !this.unloaded)) {
            return;
        }
        for (int i = 0; i < part.ports.length; ++i) {
            IPortHolder.Port port;
            short con = part.ports[i];
            boolean master = part.isMaster(i);
            if (this.extPorts.createPort(con, master, !this.unloaded) || (port = this.findPort(part, con)) == null) continue;
            if (master) {
                part.setHandler(i, port.getHandler());
                continue;
            }
            port.setHandler(part.getHandler(i));
        }
    }

    private void updateRedstone(GridPart part) {
        for (int i = 0; i < 6; ++i) {
            Direction d;
            if ((part.bounds & GridPart.FACES[i]) == 0L || part.analogOutput((d = Direction.func_82600_a((int)i)).func_176734_d()) <= 0) continue;
            this.updateNeighbor(d);
        }
    }

    @Override
    public void onPartChange() {
        this.clientDirty(true);
    }

    @Override
    public void storeState(CompoundNBT nbt, int mode) {
        super.storeState(nbt, mode);
        ListNBT list = new ListNBT();
        for (GridPart part : this.parts) {
            CompoundNBT tag = new CompoundNBT();
            part.storeState(tag, mode);
            list.add((Object)tag);
        }
        nbt.func_218657_a("parts", (INBT)list);
        if ((mode & 1) != 0) {
            try (HashOutputStream hos = new HashOutputStream();){
                list.func_74734_a((DataOutput)new DataOutputStream(hos));
                nbt.func_74768_a("hash", hos.hashCode());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            nbt.func_218657_a("extIO", (INBT)this.extPorts.serializeNBT());
        }
    }

    @Override
    public void loadState(CompoundNBT nbt, int mode) {
        boolean empty;
        super.loadState(nbt, mode);
        ListNBT list = nbt.func_150295_c("parts", 10);
        boolean bl = empty = (mode & 1) != 0 || list.size() != this.parts.size();
        if (empty) {
            this.parts.clear();
        }
        boolean mod = empty;
        for (int i = 0; i < list.size(); ++i) {
            GridPart part = empty ? null : this.parts.get(i);
            if ((part = GridPart.load(part, list.func_150305_b(i), mode)) == null) continue;
            if (empty) {
                this.parts.add(part);
                continue;
            }
            mod |= this.parts.set(i, part) != part;
        }
        this.updateBounds();
        if ((mode & 1) != 0) {
            if (nbt.func_150297_b("extIO", 12)) {
                this.extPorts.deserializeNBT((LongArrayNBT)nbt.func_74781_a("extIO"));
            }
            if (!this.unloaded) {
                this.onLoad();
            } else {
                this.tLoad = GateUpdater.TICK;
            }
        }
        if (mod && (mode & 6) != 0) {
            this.updateTerParts();
        }
    }

    @Override
    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.parts.replaceAll(part -> part.setHost(this));
            this.parts.forEach(this::connectPart);
            this.extPorts.onLoad();
            this.clientDirty(true);
        }
        super.onLoad();
        this.requestModelDataUpdate();
    }

    @Override
    protected void onUnload() {
        super.onUnload();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (GridPart part : this.parts) {
            part.setHost(null);
        }
        this.extPorts.onUnload();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.extPorts.onRemove();
    }

    @OnlyIn(value=Dist.CLIENT)
    public IModelData getModelData() {
        boolean open;
        ModelDataMap data = TileEntityModel.MODEL_DATA_BUILDER.build();
        JitBakedModel model = JitBakedModel.make((IModelData)data);
        long o = this.opaque;
        boolean bl = open = (0x660699669960660L & (o ^ 0xFFFFFFFFFFFFFFFFL)) != 0L;
        if (!open) {
            o |= 0x66006600000L;
        }
        for (GridPart part : this.parts) {
            if (!open && (part.bounds & 0xFFFFF99FF99FFFFFL) == 0L) continue;
            part.fillModel(model, o);
        }
        return data;
    }

    @Override
    public int redstoneSignal(Direction side, boolean strong) {
        if (strong || side == null) {
            return 0;
        }
        int i = 0;
        long b = GridPart.FACES[side.ordinal() ^ 1];
        for (GridPart part : this.parts) {
            if ((part.bounds & b) == 0L) continue;
            i = Math.max(i, part.analogOutput(side));
        }
        return i;
    }

    @Override
    public boolean redstoneConnection(Direction side) {
        if (side == null) {
            return false;
        }
        long b = GridPart.FACES[side.ordinal() ^ 1];
        for (GridPart part : this.parts) {
            if ((part.bounds & b) == 0L || !part.connectRedstone(side)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onNeighborBlockChange(BlockPos from, Block block, boolean moving) {
        Direction dir = Utils.getSide(from, this.field_174879_c);
        if (dir == null) {
            return;
        }
        long b = GridPart.FACES[dir.ordinal()];
        for (GridPart part : this.parts) {
            if ((part.bounds & b) == 0L) continue;
            part.onBlockChange(this.field_145850_b, from, dir);
        }
    }

    @Override
    public void onNeighborTEChange(BlockPos from) {
        Direction dir = Utils.getSide(from, this.field_174879_c);
        if (dir == null) {
            return;
        }
        long b = GridPart.FACES[dir.ordinal()];
        for (GridPart part : this.parts) {
            if ((part.bounds & b) == 0L) continue;
            part.onTEChange(this.field_145850_b, from, dir);
        }
    }

    @Override
    public void updateNeighbor(Direction d) {
        if (this.unloaded || GateUpdater.TICK == this.tLoad) {
            return;
        }
        BlockPos pos1 = this.field_174879_c.func_177972_a(d);
        this.getBlockState(pos1, true).func_215697_a(this.field_145850_b, pos1, this.func_195044_w().func_177230_c(), this.field_174879_c, false);
    }

    @Override
    public IPortHolder.Port findPort(GridPart except, short port) {
        long m = 0L;
        boolean noWire = except == null;
        int port1 = port - 273;
        if ((port & 0x888) != 0) {
            noWire = false;
        } else {
            m |= 1L << (port >> 1 & 3 | port >> 3 & 0xC | port >> 5 & 0x30);
        }
        if ((port1 & 0x888) != 0) {
            noWire = false;
        } else {
            m |= 1L << (port1 >> 1 & 3 | port1 >> 3 & 0xC | port1 >> 5 & 0x30);
        }
        for (GridPart part : this.parts) {
            if ((part.bounds & m) == 0L || part == except || noWire && part instanceof IWire) continue;
            int l = part.ports.length;
            for (int i = 0; i < l; ++i) {
                if (part.ports[i] != port) continue;
                return new IPortHolder.Port(part, i);
            }
            if (l <= 0) continue;
            break;
        }
        return null;
    }

    @Override
    public World world() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos pos() {
        return this.field_174879_c;
    }

    @Override
    public ExtGridPorts extPorts() {
        return this.extPorts;
    }

    @Override
    public ItemStack getItem() {
        if (this.parts.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack((IItemProvider)Content.grid);
        CompoundNBT nbt = stack.func_190925_c("BlockEntityTag");
        this.storeState(nbt, 1);
        nbt.func_82580_o("extIO");
        return stack;
    }

    @Override
    public ItemStack getPickItem(BlockRayTraceResult target, PlayerEntity player) {
        int pos = IGridHost.target(target, false);
        GridPart part = this.getPart(pos, (byte)1);
        if (part == null) {
            part = this.getPart(pos, (byte)-1);
        }
        return part != null ? part.asItemStack() : this.getItem();
    }

    @Override
    public long bounds() {
        return this.opaque | this.inner;
    }

    public boolean merge(Grid other) {
        if ((this.inner & other.inner | this.opaque & other.opaque) != 0L) {
            return false;
        }
        for (GridPart part : other.parts) {
            if (!part.merge(this)) continue;
            this.parts.add(part);
        }
        this.updateBounds();
        return true;
    }

    public boolean rotate(int steps) {
        for (GridPart part : this.parts) {
            if (part.canRotate()) continue;
            return false;
        }
        for (GridPart part : this.parts) {
            part.rotate(steps);
        }
        this.updateBounds();
        return true;
    }

    public boolean shift(Direction d, int n, Grid other) {
        if (other == null && (this.bounds() & GridPart.mask(d.ordinal(), n)) != 0L) {
            return false;
        }
        for (GridPart part : this.parts) {
            if (part.canMove(d, n)) continue;
            return false;
        }
        for (int i = this.parts.size() - 1; i >= 0; --i) {
            GridPart part;
            part = this.parts.get(i);
            GridPart part1 = part.move(d, n);
            if (part1 == part) {
                this.parts.remove(i);
            }
            if (part1 == null || !part1.merge(other)) continue;
            other.parts.add(part1);
        }
        return true;
    }

    private void updateTerParts() {
        int n = 0;
        long m = 0L;
        int l = Math.min(this.parts.size(), 64);
        for (int i = 0; i < l; ++i) {
            if (!(this.parts.get(i) instanceof IDynamicPart)) continue;
            m |= 1L << i;
            ++n;
        }
        IDynamicPart[] arr = n == 0 ? null : (this.dynamicParts != null && this.dynamicParts.length == n ? this.dynamicParts : new IDynamicPart[n]);
        int j = 0;
        int i = 0;
        while (i < n) {
            while (m << ~j >= 0L) {
                ++j;
            }
            arr[i] = (IDynamicPart)((Object)this.parts.get(j));
            ++i;
            ++j;
        }
        this.dynamicParts = arr;
        this.update = false;
    }

    @Override
    protected byte writeSync(PacketBuffer pkt, boolean init) {
        byte i = 0;
        for (GridPart part : this.parts) {
            if (!(part instanceof IDynamicPart)) continue;
            ((IDynamicPart)((Object)part)).writeSync(pkt, init);
            i = (byte)(i + 1);
        }
        return i;
    }

    @Override
    protected void readSync(PacketBuffer pkt, byte n) {
        if (this.dynamicParts != null && this.dynamicParts.length == n) {
            for (IDynamicPart m : this.dynamicParts) {
                m.readSync(pkt);
            }
        }
    }

    public TileEntityType<?> func_200662_C() {
        return this.field_145850_b != null && this.field_145850_b.field_72995_K && this.dynamicParts != null ? Content.GRID_TER : super.func_200662_C();
    }

    @Override
    public boolean evaluate() {
        this.updateOccl = false;
        if (this.unloaded) {
            return false;
        }
        long o = this.opaque ^ 0xFFFFFFFFFFFFFFFFL;
        this.occlude = (o & 0xF99F90099009F99FL) == 0L && ((o & 0x66006600000L) == 0L || Grid.isSealed(o));
        return this.occlude != this.occlude;
    }

    private static boolean isSealed(long bounds) {
        for (long f : GridPart.FACES) {
            if ((GridPart.floodFill(bounds, bounds & f) & ((f | 0x66006600000L) ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public void latchOut() {
        this.field_145850_b.func_180501_a(this.field_174879_c, (this.occlude ? Content.GRID1 : Content.GRID).func_176223_P(), 2);
    }
}

