/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.tileentity;

import cd4017be.lib.container.ContainerItemSupply;
import cd4017be.lib.container.IUnnamedContainerProvider;
import cd4017be.lib.network.IPlayerPacketReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.tileentity.BaseTileEntity;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemSupply
extends BaseTileEntity
implements IItemHandler,
IUnnamedContainerProvider,
IPlayerPacketReceiver {
    public static int MAX_SLOTS = 64;
    final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this);
    public final ArrayList<Slot> slots = new ArrayList();
    @Sync(to=-2147483648)
    public int scroll;

    public ItemSupply(TileEntityType<ItemSupply> type) {
        super(type);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    public int getSlots() {
        return Math.min(this.slots.size() + 1, MAX_SLOTS);
    }

    public ItemStack getStackInSlot(int slot) {
        return slot < this.slots.size() ? this.slots.get((int)slot).stack : ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot < this.slots.size()) {
            Slot s = this.slots.get(slot);
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)s.stack)) {
                return stack;
            }
            if (!simulate) {
                s.countIn += stack.func_190916_E();
            }
        } else if (!simulate) {
            Slot s = new Slot(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
            s.countIn = stack.func_190916_E();
            this.slots.add(s);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot >= this.slots.size()) {
            return ItemStack.field_190927_a;
        }
        Slot s = this.slots.get(slot);
        if (!simulate) {
            s.countOut += amount;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)s.stack, (int)amount);
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    @Override
    public void storeState(CompoundNBT nbt, int mode) {
        super.storeState(nbt, mode);
        ListNBT list = new ListNBT();
        for (Slot s : this.slots) {
            CompoundNBT tag = s.stack.func_77955_b(new CompoundNBT());
            tag.func_74768_a("in", s.countIn);
            tag.func_74768_a("out", s.countOut);
            list.add((Object)tag);
        }
        nbt.func_218657_a("slots", (INBT)list);
    }

    @Override
    public void loadState(CompoundNBT nbt, int mode) {
        super.loadState(nbt, mode);
        this.slots.clear();
        for (INBT tb : nbt.func_150295_c("slots", 10)) {
            CompoundNBT tag = (CompoundNBT)tb;
            Slot s = new Slot(ItemStack.func_199557_a((CompoundNBT)tag));
            s.countIn = tag.func_74762_e("in");
            s.countOut = tag.func_74762_e("out");
            this.slots.add(s);
        }
    }

    public ContainerItemSupply createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerItemSupply(id, inv, this);
    }

    @Override
    public void handlePlayerPacket(PacketBuffer pkt, ServerPlayerEntity sender) throws Exception {
        int cmd = pkt.readByte();
        if (cmd < 0) {
            this.scroll = pkt.readUnsignedByte();
            return;
        }
        boolean zero = cmd < 16;
        if ((cmd = (cmd & 0xF) + this.scroll) >= this.slots.size()) {
            return;
        }
        Slot s = this.slots.get(cmd);
        if (zero) {
            s.countIn = 0;
            s.countOut = 0;
        } else if (s.countIn < s.countOut) {
            s.countOut -= s.countIn;
            s.countIn = 0;
        } else {
            s.countIn -= s.countOut;
            s.countOut = 0;
        }
    }

    public ItemStack getSlot(int slot) {
        return slot + this.scroll < this.slots.size() ? this.slots.get((int)(slot + this.scroll)).stack : ItemStack.field_190927_a;
    }

    public void setSlot(ItemStack stack, int slot) {
        if ((slot += this.scroll) < this.slots.size()) {
            if (stack.func_190926_b()) {
                this.slots.remove(slot);
                return;
            }
            Slot s = this.slots.get(slot);
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)s.stack)) {
                s.stack.func_190920_e(stack.func_190916_E());
            } else {
                this.slots.set(slot, new Slot(stack));
            }
        } else if (!stack.func_190926_b()) {
            this.slots.add(new Slot(stack));
        }
    }

    public static class Slot
    implements Supplier<Object[]> {
        public final ItemStack stack;
        public int countOut;
        public int countIn;

        public Slot(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public Object[] get() {
            return new Object[]{this.countIn, this.countOut};
        }
    }
}

