/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.tileentity;

import cd4017be.lib.network.IPlayerPacketReceiver;
import cd4017be.lib.network.IServerPacketReceiver;
import cd4017be.lib.network.SyncNetworkHandler;
import cd4017be.lib.tick.GateUpdater;
import cd4017be.lib.tileentity.BaseTileEntity;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class SyncTileEntity
extends BaseTileEntity
implements IServerPacketReceiver,
IPlayerPacketReceiver {
    public static double CLIENT_RANGE;
    public static double SERVER_RANGE;
    private final ArrayList<ServerPlayerEntity> watching = new ArrayList();
    protected boolean update;

    public SyncTileEntity(TileEntityType<?> type) {
        super(type);
    }

    @Override
    protected void onUnload() {
        super.onUnload();
        this.watching.clear();
    }

    public void updateDisplay() {
        if (!this.update && !this.watching.isEmpty()) {
            this.update = true;
            GateUpdater.GATE_UPDATER.add(this::sendSync);
        }
        this.saveDirty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        ClientPlayerEntity player;
        if (!this.update && this.field_174879_c.func_218140_a((player = Minecraft.func_71410_x().field_71439_g).func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), true) < CLIENT_RANGE) {
            this.update = true;
            SyncNetworkHandler.instance.sendToServer(SyncNetworkHandler.preparePacket(this));
        }
        return super.func_145833_n();
    }

    @Override
    public void handlePlayerPacket(PacketBuffer pkt, ServerPlayerEntity sender) {
        if (!sender.func_70089_S() || this.watching.contains(sender)) {
            return;
        }
        this.watching.add(sender);
        SyncNetworkHandler.instance.sendToPlayer(this.makeSyncPacket(true), sender);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleServerPacket(PacketBuffer pkt) throws Exception {
        byte n = pkt.readByte();
        if (n == 0) {
            this.update = false;
        } else {
            this.readSync(pkt, n);
        }
    }

    private boolean sendSync() {
        this.update = false;
        for (int i = this.watching.size() - 1; i >= 0; --i) {
            ServerPlayerEntity player = this.watching.get(i);
            if (player.func_70089_S() && this.field_174879_c.func_218140_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), true) < SERVER_RANGE) continue;
            this.watching.remove(i);
            PacketBuffer pkt = SyncNetworkHandler.preparePacket(this);
            pkt.writeByte(0);
            SyncNetworkHandler.instance.sendToPlayer(pkt, player);
        }
        if (!this.watching.isEmpty()) {
            SyncNetworkHandler.instance.sendToPlayers(this.makeSyncPacket(false), this.watching);
        }
        return false;
    }

    private PacketBuffer makeSyncPacket(boolean full) {
        PacketBuffer pkt = SyncNetworkHandler.preparePacket(this);
        int p = pkt.writerIndex();
        pkt.writeByte(0);
        pkt.setByte(p, (int)this.writeSync(pkt, full));
        return pkt;
    }

    protected abstract byte writeSync(PacketBuffer var1, boolean var2);

    protected abstract void readSync(PacketBuffer var1, byte var2);
}

