/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import com.google.common.base.MoreObjects;
import java.lang.ref.WeakReference;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class DimPos
extends BlockPos {
    private static final WeakReference<World> NO_WORLD = new WeakReference<Object>(null);
    public final RegistryKey<World> dim;
    private WeakReference<World> world = NO_WORLD;

    public DimPos(Entity source) {
        this((Vector3i)source.func_233580_cy_(), source.field_70170_p);
    }

    public DimPos(TileEntity source) {
        this((Vector3i)source.func_174877_v(), source.func_145831_w());
    }

    public DimPos(Vector3i source, World world) {
        this(source, (RegistryKey<World>)world.func_234923_W_());
        this.world = new WeakReference<World>(world);
    }

    public DimPos(Vector3i source, RegistryKey<World> dim) {
        this(source.func_177958_n(), source.func_177956_o(), source.func_177952_p(), dim);
    }

    public DimPos(int x, int y, int z, RegistryKey<World> d) {
        super(x, y, z);
        this.dim = d;
    }

    public DimPos(int x, int y, int z, ServerWorld world) {
        this(x, y, z, (RegistryKey<World>)world.func_234923_W_());
        this.world = new WeakReference<ServerWorld>(world);
    }

    public DimPos(CompoundNBT nbt) {
        this(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"), (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(nbt.func_74779_i("d"))));
    }

    public DimPos assignWorld(World world) {
        if (world.func_234923_W_() != this.dim) {
            throw new IllegalArgumentException("given world represents a different dimension");
        }
        this.world = new WeakReference<World>(world);
        return this;
    }

    public World getWorld() {
        return (World)this.world.get();
    }

    public ServerWorld getServerWorld(World ref) {
        World world = (World)this.world.get();
        if (world instanceof ServerWorld) {
            return (ServerWorld)world;
        }
        ServerWorld ws = ref.func_73046_m().func_71218_a(this.dim);
        if (ws != null) {
            this.world = new WeakReference<ServerWorld>(ws);
        }
        return ws;
    }

    public DimPos offset(int x, int y, int z) {
        if (x == 0 && y == 0 && z == 0) {
            return this;
        }
        DimPos pos = new DimPos(this.func_177958_n() + x, this.func_177956_o() + y, this.func_177952_p() + z, this.dim);
        pos.world = this.world;
        return pos;
    }

    public DimPos relative(Direction facing, int n) {
        if (n == 0) {
            return this;
        }
        DimPos pos = new DimPos(this.func_177958_n() + facing.func_82601_c() * n, this.func_177956_o() + facing.func_96559_d() * n, this.func_177952_p() + facing.func_82599_e() * n, this.dim);
        pos.world = this.world;
        return pos;
    }

    public boolean equals(Object o) {
        return super.equals(o) && (!(o instanceof DimPos) || ((DimPos)((Object)o)).dim == this.dim);
    }

    public int compareTo(Vector3i o) {
        RegistryKey<World> dim;
        if (o instanceof DimPos && (dim = ((DimPos)o).dim) != this.dim) {
            return this.dim.getRegistryName().compareTo(dim.getRegistryName());
        }
        return super.compareTo(o);
    }

    public double func_177951_i(Vector3i to) {
        return to instanceof DimPos && ((DimPos)to).dim != this.dim ? Double.POSITIVE_INFINITY : super.func_177951_i(to);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("x", this.func_177958_n()).add("y", this.func_177956_o()).add("z", this.func_177952_p()).add("d", this.dim).toString();
    }

    public boolean isLoaded() {
        World world = (World)this.world.get();
        return world != null && world.func_195588_v((BlockPos)this);
    }

    public BlockState getBlock() {
        World world = (World)this.world.get();
        return world == null ? Blocks.field_150350_a.func_176223_P() : world.func_180495_p((BlockPos)this);
    }

    public boolean setBlock(BlockState state) {
        World world = (World)this.world.get();
        return world != null && world.func_175656_a((BlockPos)this, state);
    }

    public TileEntity getTileEntity() {
        World world = (World)this.world.get();
        return world == null || !world.func_195588_v((BlockPos)this) ? null : world.func_175625_s((BlockPos)this);
    }

    public CompoundNBT write(CompoundNBT nbt) {
        nbt.func_74768_a("x", this.func_177958_n());
        nbt.func_74768_a("y", this.func_177956_o());
        nbt.func_74768_a("z", this.func_177952_p());
        nbt.func_74778_a("d", this.dim.func_240901_a_().toString());
        return nbt;
    }
}

