/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import cd4017be.lib.util.IFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemFluidUtil {
    public static final String Tag_ItemList = "Items";
    public static final String Tag_ItemIndex = "ItIdx";
    public static final String Tag_FluidList = "Fluids";
    public static final String Tag_FluidIndex = "FlIdx";

    public static boolean canSlotStack(ItemStack slot, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (slot.func_190926_b()) {
            return true;
        }
        return slot.func_77969_a(stack) && (slot.func_77942_o() ? slot.func_77978_p().equals((Object)stack.func_77978_p()) && slot.areCapsCompatible((CapabilityProvider)stack) : !stack.func_77942_o());
    }

    public static void loadInventory(ListNBT list, ItemStack[] inv) {
        Arrays.fill(inv, ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            int s = tag.func_74771_c("slot") & 0xFF;
            if (s >= inv.length) continue;
            inv[s] = ItemStack.func_199557_a((CompoundNBT)tag);
        }
    }

    public static ListNBT saveInventory(ItemStack[] inv) {
        ListNBT list = new ListNBT();
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i].func_190926_b()) continue;
            CompoundNBT tag = new CompoundNBT();
            inv[i].func_77955_b(tag);
            tag.func_74774_a("slot", (byte)i);
            list.add((Object)tag);
        }
        return list;
    }

    public static ItemStack[] loadItems(ListNBT list) {
        ItemStack[] items = new ItemStack[list.size()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = ItemStack.func_199557_a((CompoundNBT)list.func_150305_b(i));
        }
        return items;
    }

    public static void loadItems(ListNBT list, ItemStack[] items) {
        int m = Math.min(items.length, list.size());
        for (int i = 0; i < m; ++i) {
            items[i] = ItemStack.func_199557_a((CompoundNBT)list.func_150305_b(i));
        }
        Arrays.fill(items, m, items.length, ItemStack.field_190927_a);
    }

    public static ListNBT saveItems(ItemStack[] items) {
        ListNBT list = new ListNBT();
        for (ItemStack item : items) {
            if (item.func_190926_b()) continue;
            CompoundNBT tag = new CompoundNBT();
            item.func_77955_b(tag);
            list.add((Object)tag);
        }
        return list;
    }

    public static CompoundNBT saveItemHighRes(ItemStack item) {
        CompoundNBT nbt = new CompoundNBT();
        item.func_77955_b(nbt);
        nbt.func_82580_o("Count");
        nbt.func_74768_a("Num", item.func_190916_E());
        return nbt;
    }

    public static ItemStack loadItemHighRes(CompoundNBT nbt) {
        ItemStack item = ItemStack.func_199557_a((CompoundNBT)nbt);
        item.func_190920_e(nbt.func_74762_e("Num"));
        return item;
    }

    public static void writeItemHighRes(PacketBuffer buf, ItemStack stack) {
        if (stack.func_190926_b()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            Item item = stack.func_77973_b();
            buf.func_150787_b(Item.func_150891_b((Item)item));
            buf.func_150787_b(stack.func_190916_E());
            buf.func_150786_a((CompoundNBT)(item.isDamageable(stack) || item.func_77651_p() ? stack.getShareTag() : null));
        }
    }

    public static ItemStack readItemHighRes(PacketBuffer buf) throws IOException {
        if (!buf.readBoolean()) {
            return ItemStack.field_190927_a;
        }
        int i = buf.func_150792_a();
        int j = buf.func_150792_a();
        ItemStack itemstack = new ItemStack((IItemProvider)Item.func_150899_d((int)i), j);
        itemstack.readShareTag(buf.func_150793_b());
        return itemstack;
    }

    public static ListNBT saveFluids(FluidStack[] fluids) {
        ListNBT list = new ListNBT();
        for (FluidStack fluid : fluids) {
            if (fluid == null) continue;
            CompoundNBT tag = new CompoundNBT();
            fluid.writeToNBT(tag);
            list.add((Object)tag);
        }
        return list;
    }

    public static FluidStack[] loadFluids(ListNBT list) {
        FluidStack[] fluids = new FluidStack[list.size()];
        for (int i = 0; i < fluids.length; ++i) {
            fluids[i] = FluidStack.loadFluidStackFromNBT((CompoundNBT)list.func_150305_b(i));
        }
        return fluids;
    }

    public static void readBytes(byte[] dst, byte[] src, byte fallback) {
        int sl = src.length;
        int dl = dst.length;
        System.arraycopy(src, 0, dst, 0, Math.min(sl, dl));
        if (sl < dl) {
            Arrays.fill(dst, sl, dl, fallback);
        }
    }

    public static int transferItems(IItemHandler src, IItemHandler dst, IFilter<ItemStack, IItemHandler> extr, IFilter<ItemStack, IItemHandler> ins) {
        int m = 0;
        for (int i = 0; i < src.getSlots(); ++i) {
            ItemStack stack = src.extractItem(i, 65536, true);
            int n = stack.func_190916_E();
            if (n == 0 || extr != null && (n = (stack = extr.getExtract(stack, src)).func_190916_E()) == 0) continue;
            if (ins != null) {
                n = ins.insertAmount(stack, dst);
                if (n == 0) continue;
                stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)n);
            }
            if ((n -= ItemHandlerHelper.insertItemStacked((IItemHandler)dst, (ItemStack)stack, (boolean)false).func_190916_E()) <= 0) continue;
            src.extractItem(i, n, false);
            m += n;
        }
        return m;
    }

    public static int findStack(ItemStack item, IItemHandler inv, int p) {
        if (item.func_190926_b()) {
            return -1;
        }
        for (int i = p; i < inv.getSlots(); ++i) {
            if (!ItemStack.func_77989_b((ItemStack)item, (ItemStack)inv.getStackInSlot(i))) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack putInSlots(IItemHandler inv, ItemStack stack, int ... slots) {
        for (int s : slots) {
            if (inv.getStackInSlot(s).func_190916_E() <= 0 || (stack = inv.insertItem(s, stack, false)).func_190916_E() != 0) continue;
            return stack;
        }
        for (int s : slots) {
            if (inv.getStackInSlot(s).func_190916_E() == 0 && (stack = inv.insertItem(s, stack, false)).func_190916_E() == 0) break;
        }
        return stack;
    }

    public static int drain(IItemHandler inv, ItemStack type, int am) {
        int m = 0;
        for (int i = 0; i < inv.getSlots() && m < am; ++i) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)type, (ItemStack)inv.getStackInSlot(i))) continue;
            ItemStack stack = inv.extractItem(i, am - m, false);
            m += stack.func_190916_E();
        }
        return m;
    }

    public static void addToList(ArrayList<ItemStack> list, ItemStack item) {
        for (ItemStack stack : list) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)item, (ItemStack)stack)) continue;
            stack.func_190917_f(item.func_190916_E());
            return;
        }
        list.add(item);
    }

    public static void addToList(ArrayList<FluidStack> list, FluidStack fluid) {
        for (FluidStack stack : list) {
            if (!fluid.isFluidEqual(stack)) continue;
            stack.grow(fluid.getAmount());
            return;
        }
        list.add(fluid);
    }

    public static ItemStack drain(IItemHandler inv, int am) {
        boolean mss;
        boolean bl = mss = am < 0;
        if (mss) {
            am = 65536;
        }
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.extractItem(i, am, true);
            if (stack.func_190916_E() == 0) continue;
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)ItemFluidUtil.drain(inv, stack, mss ? stack.func_77976_d() : am));
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack drain(IItemHandler inv, ToIntFunction<ItemStack> filter) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            int m;
            ItemStack stack = inv.extractItem(i, 1, true);
            if (stack.func_190916_E() <= 0 || (m = filter.applyAsInt(stack)) <= 0) continue;
            int n = inv.extractItem(i, m, false).func_190916_E();
            while (n < m && ++i < inv.getSlots()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)inv.getStackInSlot(i), (ItemStack)stack)) continue;
                n += inv.extractItem(i, m, false).func_190916_E();
            }
            stack.func_190920_e(n);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static void dropStack(ItemStack stack, Entity entity) {
        if (stack.func_190926_b()) {
            return;
        }
        ItemEntity ei = new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stack);
        entity.field_70170_p.func_217376_c((Entity)ei);
    }

    public static void dropStack(ItemStack stack, World world, BlockPos pos) {
        if (stack.func_190926_b()) {
            return;
        }
        ItemEntity ei = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
        ei.func_174869_p();
        world.func_217376_c((Entity)ei);
    }

    public static void writeFluidStack(PacketBuffer buf, FluidStack stack) {
        buf.writeFluidStack(stack);
    }

    public static FluidStack readFluidStack(PacketBuffer buf) throws IOException {
        return buf.readFluidStack();
    }

    public static CompoundNBT createTag(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    public static CompoundNBT createTag(CompoundNBT nbt, String key) {
        if (nbt.func_150297_b(key, 10)) {
            return nbt.func_74775_l(key);
        }
        CompoundNBT tag = new CompoundNBT();
        nbt.func_218657_a(key, (INBT)tag);
        return tag;
    }

    public static Item item(String id) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
    }

    public static FluidStack drainFluid(World world, BlockPos pos, Predicate<FluidStack> filter) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!(block instanceof IBucketPickupHandler)) {
            return FluidStack.EMPTY;
        }
        FluidState fstate = state.func_204520_s();
        if (!fstate.func_206889_d() || !filter.test(new FluidStack(fstate.func_206886_c(), 1000))) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(((IBucketPickupHandler)block).func_204508_a((IWorld)world, pos, state), 1000);
    }

    public static boolean placeFluid(World world, BlockPos pos, FluidStack stack) {
        Fluid fluid = stack.getFluid();
        FluidAttributes attr = fluid.getAttributes();
        if (fluid == Fluids.field_204541_a || !attr.canBePlacedInWorld((IBlockDisplayReader)world, pos, stack)) {
            return false;
        }
        BlockState blockstate = world.func_180495_p(pos);
        Block block = blockstate.func_177230_c();
        if (block instanceof ILiquidContainer) {
            return ((ILiquidContainer)block).func_204509_a((IWorld)world, pos, blockstate, attr.getStateForPlacement((IBlockDisplayReader)world, pos, stack));
        }
        if (!world.func_175623_d(pos)) {
            Material material = blockstate.func_185904_a();
            if (material.func_76220_a() && !blockstate.func_227032_a_(fluid)) {
                return false;
            }
            if (!material.func_76224_d()) {
                world.func_175655_b(pos, true);
            }
        }
        return world.func_180501_a(pos, attr.getBlock((IBlockDisplayReader)world, pos, fluid.func_207188_f()), 11);
    }
}

