/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3i;

public enum Orientation implements IStringSerializable
{
    S12(Direction.UP, Direction.SOUTH),
    S9(Direction.EAST, Direction.SOUTH),
    S6(Direction.DOWN, Direction.SOUTH),
    S3(Direction.WEST, Direction.SOUTH),
    W12(Direction.UP, Direction.WEST),
    W9(Direction.SOUTH, Direction.WEST),
    W6(Direction.DOWN, Direction.WEST),
    W3(Direction.NORTH, Direction.WEST),
    N12(Direction.UP, Direction.NORTH),
    N9(Direction.WEST, Direction.NORTH),
    N6(Direction.DOWN, Direction.NORTH),
    N3(Direction.EAST, Direction.NORTH),
    E12(Direction.UP, Direction.EAST),
    E9(Direction.NORTH, Direction.EAST),
    E6(Direction.DOWN, Direction.EAST),
    E3(Direction.SOUTH, Direction.EAST),
    UN(Direction.NORTH, Direction.UP),
    UE(Direction.EAST, Direction.UP),
    US(Direction.SOUTH, Direction.UP),
    UW(Direction.WEST, Direction.UP),
    DS(Direction.SOUTH, Direction.DOWN),
    DE(Direction.EAST, Direction.DOWN),
    DN(Direction.NORTH, Direction.DOWN),
    DW(Direction.WEST, Direction.DOWN);

    private static final Orientation[] VALUES;
    private static final Orientation[] INVERSE;
    public final Direction r;
    public final Direction u;
    public final Direction b;
    public final int o;
    public final Matrix4f mat4;
    public final Matrix3f mat3;

    private Orientation(Direction u, Direction b) {
        this.u = u;
        this.b = b;
        Vector3i vec = u.func_176730_m().func_177955_d(b.func_176730_m());
        this.r = Direction.func_218383_a((int)vec.func_177958_n(), (int)vec.func_177956_o(), (int)vec.func_177952_p());
        this.o = (this.r.func_176740_k().ordinal() << 1 | this.r.ordinal() & 1 | u.func_176740_k().ordinal() << 5 | u.ordinal() << 4 & 0x10 | b.func_176740_k().ordinal() << 9 | b.ordinal() << 8 & 0x100) ^ 0x111;
        float[] m = new float[]{this.r.func_82601_c(), u.func_82601_c(), b.func_82601_c(), -1.0f, this.r.func_96559_d(), u.func_96559_d(), b.func_96559_d(), -1.0f, this.r.func_82599_e(), u.func_82599_e(), b.func_82599_e(), -1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        for (int i = 0; i < 12; i += 4) {
            m[i + 3] = (m[i] + m[i + 1] + m[i + 2] + m[i + 3]) * -0.5f;
        }
        this.mat4 = new Matrix4f(m);
        this.mat3 = new Matrix3f(this.mat4);
    }

    public static Orientation byBack(Direction b) {
        for (int i = 0; i < 24; i += 4) {
            Orientation o = VALUES[i];
            if (o.b != b) continue;
            return o;
        }
        return null;
    }

    public static Orientation byBackUp(Direction b, Direction u) {
        for (int i = 0; i < 24; i += 4) {
            Orientation o = VALUES[i];
            if (o.b != b) continue;
            if (o.u == u) {
                return o;
            }
            o = VALUES[i + 1];
            if (o.u == u) {
                return o;
            }
            o = VALUES[i + 2];
            if (o.u == u) {
                return o;
            }
            o = VALUES[i + 3];
            if (o.u == u) {
                return o;
            }
            return null;
        }
        return null;
    }

    public static Orientation byBackRight(Direction b, Direction r) {
        for (int i = 0; i < 24; i += 4) {
            Orientation o = VALUES[i];
            if (o.b != b) continue;
            if (o.r == r) {
                return o;
            }
            o = VALUES[i + 1];
            if (o.r == r) {
                return o;
            }
            o = VALUES[i + 2];
            if (o.r == r) {
                return o;
            }
            o = VALUES[i + 3];
            if (o.r == r) {
                return o;
            }
            return null;
        }
        return null;
    }

    public static Orientation byIndex(int i) {
        return VALUES[(i &= 0x1F) < 24 ? i : i - 8];
    }

    public Orientation inv() {
        return INVERSE[this.ordinal()];
    }

    public Orientation apply(Orientation orient) {
        return Orientation.byBackUp(this.apply(orient.b), this.apply(orient.u));
    }

    public Direction apply(Direction dir) {
        switch (dir) {
            case DOWN: {
                return this.u.func_176734_d();
            }
            case UP: {
                return this.u;
            }
            case NORTH: {
                return this.b.func_176734_d();
            }
            case SOUTH: {
                return this.b;
            }
            case WEST: {
                return this.r.func_176734_d();
            }
        }
        return this.r;
    }

    public VoxelShape apply(VoxelShape main) {
        throw new UnsupportedOperationException();
    }

    public String func_176610_l() {
        return this.name().toLowerCase();
    }

    static {
        VALUES = Orientation.values();
        INVERSE = new Orientation[]{S12, S3, S6, S9, E12, UW, W6, DE, N12, N9, N6, N3, W12, DW, E6, UE, DS, E3, US, W9, UN, W3, DN, E9};
    }
}

