/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.function.IntFunction;
import java.util.function.ObjIntConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;

public class Utils {
    public static final BlockPos NOWHERE = new BlockPos(0, -1, 0);
    public static final byte IN = -1;
    public static final byte OUT = 1;
    public static final byte ACC = 0;
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static void forRing(BlockPos center, Direction.Axis axis, int radius, ObjIntConsumer<BlockPos> operation) {
        int x = center.func_177958_n();
        int y = center.func_177956_o();
        int z = center.func_177952_p();
        switch (axis) {
            case X: {
                for (int i = -radius; i < radius; ++i) {
                    int d = radius * radius + i * i;
                    operation.accept(new BlockPos(x, y - radius, z + i), d);
                    operation.accept(new BlockPos(x, y + radius, z - i), d);
                    operation.accept(new BlockPos(x, y - i, z - radius), d);
                    operation.accept(new BlockPos(x, y + i, z + radius), d);
                }
                break;
            }
            case Y: {
                for (int i = -radius; i < radius; ++i) {
                    int d = radius * radius + i * i;
                    operation.accept(new BlockPos(x - radius, y, z + i), d);
                    operation.accept(new BlockPos(x + radius, y, z - i), d);
                    operation.accept(new BlockPos(x - i, y, z - radius), d);
                    operation.accept(new BlockPos(x + i, y, z + radius), d);
                }
                break;
            }
            case Z: {
                for (int i = -radius; i < radius; ++i) {
                    int d = radius * radius + i * i;
                    operation.accept(new BlockPos(x - radius, y + i, z), d);
                    operation.accept(new BlockPos(x + radius, y - i, z), d);
                    operation.accept(new BlockPos(x - i, y - radius, z), d);
                    operation.accept(new BlockPos(x + i, y + radius, z), d);
                }
                break;
            }
        }
    }

    @Nullable
    public static TileEntity neighborTile(TileEntity tile, Direction side) {
        BlockPos pos;
        World world = tile.func_145831_w();
        return world.func_195588_v(pos = tile.func_174877_v().func_177972_a(side)) ? world.func_175625_s(pos) : null;
    }

    @Nullable
    public static TileEntity getTileAt(World world, BlockPos pos) {
        return world.func_195588_v(pos) ? world.func_175625_s(pos) : null;
    }

    @Deprecated
    @Nullable
    public static <T> T neighborCapability(TileEntity tile, Direction side, Capability<T> cap) {
        BlockPos pos;
        World world = tile.func_145831_w();
        if (!world.func_195588_v(pos = tile.func_174877_v().func_177972_a(side))) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        return (T)(te != null ? te.getCapability(cap, side.func_176734_d()).orElse(null) : null);
    }

    @Deprecated
    @Nullable
    public static <T> T getCapabilityAt(World world, BlockPos pos, @Nullable Direction side, Capability<T> cap) {
        if (!world.func_195588_v(pos)) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        return (T)(te != null ? te.getCapability(cap, side).orElse(null) : null);
    }

    public static boolean neighboursLoaded(World world, BlockPos pos) {
        int x = pos.func_177958_n() & 0xF;
        int z = pos.func_177952_p() & 0xF;
        return (x == 0 ? world.func_195588_v(pos.func_177982_a(-1, 0, 0)) : x != 15 || world.func_195588_v(pos.func_177982_a(1, 0, 0))) && (z == 0 ? world.func_195588_v(pos.func_177982_a(0, 0, -1)) : z != 15 || world.func_195588_v(pos.func_177982_a(0, 0, 1)));
    }

    public static Direction hitSide(float X, float Y, float Z) {
        float dz;
        float dx = Math.abs(X -= 0.5f);
        float dy = Math.abs(Y -= 0.5f);
        return dy > (dz = Math.abs(Z -= 0.5f)) && dy > dx ? (Y < 0.0f ? Direction.DOWN : Direction.UP) : (dz > dx ? (Z < 0.0f ? Direction.NORTH : Direction.SOUTH) : (X < 0.0f ? Direction.WEST : Direction.EAST));
    }

    @Deprecated
    public static RayTraceResult getHit(PlayerEntity player, BlockState block, BlockPos pos) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static FluidStack getFluid(World world, BlockPos pos, boolean sourceOnly) {
        throw new UnsupportedOperationException();
    }

    public static Direction getLookDirStrict(Entity entity) {
        if (entity.field_70125_A < -45.0f) {
            return Direction.DOWN;
        }
        if (entity.field_70125_A > 45.0f) {
            return Direction.UP;
        }
        return entity.func_174811_aO();
    }

    public static Direction getLookDirPlacement(Entity entity) {
        if (entity.field_70125_A < -35.0f) {
            return Direction.DOWN;
        }
        if (entity.field_70125_A > 40.0f) {
            return Direction.UP;
        }
        return entity.func_174811_aO();
    }

    public static Direction getSide(BlockPos pos, BlockPos ref) {
        int dx = pos.func_177958_n() - ref.func_177958_n();
        int dy = pos.func_177956_o() - ref.func_177956_o();
        int dz = pos.func_177952_p() - ref.func_177952_p();
        if (dx != 0) {
            if (dy != 0 || dz != 0) {
                return null;
            }
            return dx == -1 ? Direction.WEST : (dx == 1 ? Direction.EAST : null);
        }
        if (dy != 0) {
            if (dz != 0) {
                return null;
            }
            return dy == -1 ? Direction.DOWN : (dy == 1 ? Direction.UP : null);
        }
        return dz == -1 ? Direction.NORTH : (dz == 1 ? Direction.SOUTH : null);
    }

    public static int coord(BlockPos pos, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return pos.func_177958_n();
            }
            case Y: {
                return pos.func_177956_o();
            }
            case Z: {
                return pos.func_177952_p();
            }
        }
        return 0;
    }

    public static double coord(double x, double y, double z, Direction d) {
        switch (d) {
            case DOWN: {
                return -y;
            }
            case UP: {
                return y;
            }
            case NORTH: {
                return -z;
            }
            case SOUTH: {
                return z;
            }
            case WEST: {
                return -x;
            }
            case EAST: {
                return x;
            }
        }
        return 0.0;
    }

    @Deprecated
    public static void updateRedstoneOnSide(TileEntity te, int value, Direction side) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static <T extends TileEntity> void updateRedstoneOnSide(T te, Direction side) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static void notifyNeighborTile(TileEntity te, Direction side) {
        throw new UnsupportedOperationException();
    }

    public static int cycleState(int cfg, int i, int m, int r, boolean incr) {
        return cfg & ~(m << i) | ((cfg >> i & m) + (incr ? 1 : r - 1)) % r << i;
    }

    public static int setState(int cfg, int i, int m, int x) {
        return cfg & ~(m << i) | (x & m) << i;
    }

    public static long cycleState(long cfg, int i, long m, int r, boolean incr) {
        return cfg & (m << i ^ 0xFFFFFFFFFFFFFFFFL) | (long)(((int)(cfg >> i & m) + (incr ? 1 : r - 1)) % r) << i;
    }

    public static long setState(long cfg, int i, long m, int x) {
        return cfg & (m << i ^ 0xFFFFFFFFFFFFFFFFL) | ((long)x & m) << i;
    }

    public static <T> T[] init(T[] arr, T val) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = val;
        }
        return arr;
    }

    public static <T> T[] init(T[] arr, IntFunction<T> val) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = val.apply(i);
        }
        return arr;
    }

    public static ListNBT writeStringArray(String[] arr) {
        ListNBT list = new ListNBT();
        for (String s : arr) {
            list.add((Object)StringNBT.func_229705_a_((String)s));
        }
        return list;
    }

    public static String[] readStringArray(ListNBT list, String[] arr) {
        int l = list.size();
        if (arr == null || arr.length < l) {
            arr = new String[l];
        }
        for (int i = 0; i < l; ++i) {
            arr[i] = list.func_150307_f(i);
        }
        return arr;
    }

    public static byte[] putShortArray(short[] arr) {
        byte[] buf = new byte[arr.length << 1];
        for (int i = 0; i < arr.length; ++i) {
            short v = arr[i];
            buf[i << 1] = (byte)v;
            buf[i << 1 | 1] = (byte)(v >> 8);
        }
        return buf;
    }

    public static short[] getShortArray(byte[] nbt) {
        short[] arr = new short[nbt.length >> 1];
        Utils.getShortArray(nbt, arr);
        return arr;
    }

    public static void getShortArray(byte[] nbt, short[] arr) {
        int l = Math.min(arr.length, nbt.length >> 1);
        for (int i = 0; i < l; ++i) {
            arr[i] = (short)(nbt[i << 1] & 0xFF | nbt[i << 1 | 1] << 8);
        }
    }

    public static INBT readTag(ByteBuf data, byte tagId) {
        switch (tagId) {
            case 1: {
                return ByteNBT.func_229671_a_((byte)data.readByte());
            }
            case 2: {
                return ShortNBT.func_229701_a_((short)data.readShort());
            }
            case 3: {
                return IntNBT.func_229692_a_((int)data.readInt());
            }
            case 4: {
                return LongNBT.func_229698_a_((long)data.readLong());
            }
            case 5: {
                return FloatNBT.func_229689_a_((float)data.readFloat());
            }
            case 6: {
                return DoubleNBT.func_229684_a_((double)data.readDouble());
            }
            case 7: {
                int l = data.readInt();
                if (l > data.readableBytes()) {
                    throw new IndexOutOfBoundsException(l + " > " + data.readableBytes());
                }
                byte[] arr = new byte[l];
                data.readBytes(arr);
                return new ByteArrayNBT(arr);
            }
            case 11: {
                int l = data.readInt();
                if (l * 4 > data.readableBytes()) {
                    throw new IndexOutOfBoundsException(l * 4 + " > " + data.readableBytes());
                }
                int[] arr = new int[l];
                for (int i = 0; i < l; ++i) {
                    arr[i] = data.readInt();
                }
                return new IntArrayNBT(arr);
            }
            case 12: {
                int l = data.readInt();
                if (l * 8 > data.readableBytes()) {
                    throw new IndexOutOfBoundsException(l * 8 + " > " + data.readableBytes());
                }
                long[] arr = new long[l];
                for (int i = 0; i < l; ++i) {
                    arr[i] = data.readLong();
                }
                return new LongArrayNBT(arr);
            }
            case 8: {
                int l = data.readUnsignedShort();
                if (l * 2 > data.readableBytes()) {
                    throw new IndexOutOfBoundsException(l * 2 + " > " + data.readableBytes());
                }
                byte[] arr = new byte[l];
                data.readBytes(arr);
                return StringNBT.func_229705_a_((String)new String(arr, UTF8));
            }
            case 9: {
                ListNBT list = new ListNBT();
                tagId = data.readByte();
                for (int l = data.readInt(); l > 0; --l) {
                    list.add((Object)Utils.readTag(data, tagId));
                }
                return list;
            }
        }
        return null;
    }

    public static void writeTag(ByteBuf data, INBT tag) {
        switch (tag.func_74732_a()) {
            case 1: {
                data.writeByte((int)((ByteNBT)tag).func_150290_f());
                return;
            }
            case 2: {
                data.writeShort((int)((ShortNBT)tag).func_150289_e());
                return;
            }
            case 3: {
                data.writeInt(((IntNBT)tag).func_150287_d());
                return;
            }
            case 4: {
                data.writeLong(((LongNBT)tag).func_150291_c());
                return;
            }
            case 5: {
                data.writeFloat(((FloatNBT)tag).func_150288_h());
                return;
            }
            case 6: {
                data.writeDouble(((DoubleNBT)tag).func_150286_g());
                return;
            }
            case 7: {
                byte[] arr = ((ByteArrayNBT)tag).func_150292_c();
                data.writeInt(arr.length);
                data.writeBytes(arr);
                return;
            }
            case 11: {
                int[] arr = ((IntArrayNBT)tag).func_150302_c();
                data.writeInt(arr.length);
                for (int v : arr) {
                    data.writeInt(v);
                }
                return;
            }
            case 12: {
                long[] arr = ((LongArrayNBT)tag).func_197652_h();
                data.writeInt(arr.length);
                for (long v : arr) {
                    data.writeLong(v);
                }
                return;
            }
            case 8: {
                byte[] arr = ((StringNBT)tag).func_150285_a_().getBytes(UTF8);
                data.writeShort(arr.length);
                data.writeBytes(arr);
                return;
            }
            case 9: {
                ListNBT list = (ListNBT)tag;
                data.writeByte((int)list.func_230528_d__());
                data.writeInt(list.size());
                for (INBT stag : list) {
                    Utils.writeTag(data, stag);
                }
                return;
            }
        }
    }
}

