/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.math;

public class Linalg {
    public static float[] vec(float ... x) {
        return x;
    }

    public static float[] add(int n, float[] a, float ... b) {
        return Linalg.sum(n, a, a, b);
    }

    public static float[] sum(int n, float[] out, float[] a, float[] b) {
        for (int i = 0; i < n; ++i) {
            out[i] = a[i] + b[i];
        }
        return out;
    }

    public static float[] sub(int n, float[] a, float ... b) {
        return Linalg.dif(n, a, a, b);
    }

    public static float[] rsub(int n, float[] a, float[] b) {
        return Linalg.dif(n, a, b, a);
    }

    public static float[] dif(int n, float[] out, float[] a, float[] b) {
        for (int i = 0; i < n; ++i) {
            out[i] = a[i] - b[i];
        }
        return out;
    }

    public static float[] dadd(int n, float[] a, float x) {
        return Linalg.dadd(n, a, a, x);
    }

    public static float[] dadd(int n, float[] out, float[] a, float x) {
        int i = 0;
        while (i < n) {
            int n2 = i++;
            a[n2] = a[n2] + x;
        }
        return a;
    }

    public static float[] sca(int n, float[] a, float x) {
        return Linalg.sca(n, a, a, x);
    }

    public static float[] sca(int n, float[] out, float[] a, float x) {
        for (int i = 0; i < n; ++i) {
            out[i] = a[i] * x;
        }
        return out;
    }

    public static float dot(int n, float[] a, float[] b) {
        float x = a[0] * b[0];
        for (int i = 1; i < n; ++i) {
            x += a[i] * b[i];
        }
        return x;
    }

    public static float lenSq(int n, float[] a) {
        return Linalg.dot(n, a, a);
    }

    public static float len(int n, float[] a) {
        return (float)Math.sqrt(Linalg.dot(n, a, a));
    }

    public static float[] norm(int n, float[] a) {
        return Linalg.sca(n, a, a, 1.0f / Linalg.len(n, a));
    }

    public static float[] norm(int n, float[] out, float[] a) {
        return Linalg.sca(n, out, a, 1.0f / Linalg.len(n, a));
    }

    public static float[] rec(int n, float[] a, float s) {
        return Linalg.sca(n, a, a, s / Linalg.dot(n, a, a));
    }

    public static float[] rec(int n, float[] out, float[] a, float s) {
        return Linalg.sca(n, out, a, s / Linalg.dot(n, a, a));
    }

    public static float[] neg(int n, float[] a) {
        return Linalg.neg(n, a, a);
    }

    public static float[] neg(int n, float[] out, float[] a) {
        for (int i = 0; i < n; ++i) {
            out[i] = -a[i];
        }
        return out;
    }

    public static float[] abs(int n, float[] a) {
        return Linalg.abs(n, a, a);
    }

    public static float[] abs(int n, float[] out, float[] a) {
        for (int i = 0; i < n; ++i) {
            out[i] = Float.intBitsToFloat(Float.floatToRawIntBits(a[i]) & Integer.MAX_VALUE);
        }
        return out;
    }

    public static float[] cross(float[] a, float[] b) {
        return Linalg.cross(a, a, b);
    }

    public static float[] rcross(float[] a, float[] b) {
        return Linalg.cross(a, b, a);
    }

    public static float[] cross(float[] out, float[] a, float[] b) {
        float r0 = a[1] * b[2] - a[2] * b[1];
        float r1 = a[2] * b[0] - a[0] * b[2];
        out[2] = a[0] * b[1] - a[1] * b[0];
        out[1] = r1;
        out[0] = r0;
        return out;
    }

    public static float[] mul(int n, float[] a, float[] b) {
        return Linalg.prod(n, a, a, b);
    }

    public static float[] prod(int n, float[] out, float[] a, float[] b) {
        for (int i = 0; i < n; ++i) {
            out[i] = a[i] * b[i];
        }
        return out;
    }

    public static float[] quot(int n, float[] out, float[] a, float[] b) {
        for (int i = 0; i < n; ++i) {
            out[i] = a[i] / b[i];
        }
        return out;
    }

    public static boolean allInRange(int n, float[] a, float min, float max) {
        for (int i = 0; i < n; ++i) {
            if (!(a[i] < min) && !(a[i] >= max)) continue;
            return false;
        }
        return true;
    }

    public static float[] col(int n, float[] out, float[][] mat, int j) {
        for (int i = 0; i < n; ++i) {
            out[i] = mat[i][j];
        }
        return out;
    }

    public static float[] subsca(int n, float[] a, float[] b, float x) {
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            a[n2] = a[n2] - b[i] * x;
        }
        return a;
    }

    public static void solveGauss(float[][] mat, int m, int n) {
        for (int i = 0; i < m; ++i) {
            int j;
            float x = mat[i][i];
            int k = i;
            for (int j2 = i + 1; j2 < m; ++j2) {
                float y = mat[j2][i];
                if (!(Math.abs(y) > Math.abs(x))) continue;
                x = y;
                k = j2;
            }
            float[] row = mat[k];
            if (k != i) {
                mat[k] = mat[i];
                mat[i] = row;
            }
            if (x == 0.0f) {
                row[i] = 1.0f;
                for (j = i + 1; j < n; ++j) {
                    row[j] = 0.0f;
                }
                continue;
            }
            if (x != 1.0f) {
                Linalg.sca(n, row, 1.0f / x);
            }
            for (j = 0; j < m; ++j) {
                float[] row1;
                if (j == i || (x = (row1 = mat[j])[i]) == 0.0f) continue;
                Linalg.subsca(n, row1, row, x);
            }
        }
    }
}

