/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.math;

public interface Operand<T extends Operand<T>> {
    public T set(T var1);

    public T sum(T var1, T var2);

    default public T add(T o) {
        return (T)this.sum(this, o);
    }

    public T dif(T var1, T var2);

    default public T sub(T o) {
        return (T)this.dif(this, o);
    }

    default public T rsub(T o) {
        return (T)this.dif(o, this);
    }

    public T prod(T var1, T var2);

    default public T mul(T o) {
        return (T)this.prod(this, o);
    }

    default public T rmul(T o) {
        return (T)this.prod(o, this);
    }

    public T quot(T var1, T var2);

    default public T div(T o) {
        return (T)this.quot(this, o);
    }

    default public T rdiv(T o) {
        return (T)this.quot(o, this);
    }

    public T rem(T var1, T var2);

    default public T mod(T o) {
        return (T)this.rem(this, o);
    }

    default public T rmod(T o) {
        return (T)this.rem(o, this);
    }

    public T neg(T var1);

    default public T neg() {
        return (T)this.neg(this);
    }

    public T rec(T var1);

    default public T rec() {
        return (T)this.rec(this);
    }

    public boolean equals(T var1);

    public T clone();

    public static interface D<T extends D<T>>
    extends Operand<T> {
        public T sca(T var1, double var2);

        default public T sca(double s) {
            return (T)this.sca(this, s);
        }

        default public T srec(double s) {
            return this.sca(s / this.asqD());
        }

        default public T srec(T o, double s) {
            return this.sca(o, s / o.asqD());
        }

        @Override
        default public T rec(T o) {
            return this.srec(o, 1.0);
        }

        @Override
        default public T neg(T o) {
            return this.sca(o, -1.0);
        }

        public double asqD();

        default public double abs() {
            return Math.sqrt(this.asqD());
        }
    }

    public static interface F<T extends F<T>>
    extends Operand<T> {
        public T sca(T var1, float var2);

        default public T sca(float s) {
            return (T)this.sca(this, s);
        }

        default public T srec(T o, float s) {
            return this.sca(o, s / o.asqF());
        }

        default public T srec(float s) {
            return (T)this.srec(this, s);
        }

        @Override
        default public T rec(T o) {
            return this.srec(o, 1.0f);
        }

        @Override
        default public T neg(T o) {
            return this.sca(o, -1.0f);
        }

        public float asqF();
    }

    public static interface I<T extends I<T>>
    extends Operand<T> {
        public T sca(T var1, int var2);

        default public T sca(int s) {
            return (T)this.sca(this, s);
        }

        public T sinv(T var1, int var2);

        default public T sinv(int s) {
            return (T)this.sinv(this, s);
        }

        public T srec(T var1, int var2);

        default public T srec(int s) {
            return (T)this.srec(this, s);
        }

        public int asqI();
    }
}

