/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.math.cplx;

import cd4017be.math.Operand;
import cd4017be.math.cplx.CplxF;

public final class CplxD
implements Operand.D<CplxD> {
    public double r;
    public double i;

    public CplxD set(double r, double i) {
        this.r = r;
        this.i = i;
        return this;
    }

    public CplxD setPol(double l, double a) {
        this.r = Math.cos(a) * l;
        this.i = Math.sin(a) * l;
        return this;
    }

    @Override
    public CplxD set(CplxF o) {
        this.r = o.r;
        this.i = o.i;
        return this;
    }

    @Override
    public CplxD set(CplxD o) {
        this.r = o.r;
        this.i = o.i;
        return this;
    }

    @Override
    public CplxD sum(CplxD a, CplxD b) {
        this.r = a.r + b.r;
        this.i = a.i + b.i;
        return this;
    }

    @Override
    public CplxD dif(CplxD a, CplxD b) {
        this.r = a.r - b.r;
        this.i = a.i - b.i;
        return this;
    }

    @Override
    public CplxD prod(CplxD a, CplxD b) {
        return this.set(a.r * b.r - a.i * b.i, a.r * b.i + a.i * b.r);
    }

    @Override
    public CplxD quot(CplxD a, CplxD b) {
        double asq = 1.0 / b.asqD();
        return this.sca(this.prod(a, b), asq);
    }

    @Override
    public CplxD rem(CplxD a, CplxD b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CplxD sca(CplxD o, double s) {
        this.r = o.r * s;
        this.i = o.i * s;
        return this;
    }

    @Override
    public CplxD neg(CplxD o) {
        this.r = -o.r;
        this.i = -o.i;
        return this;
    }

    @Override
    public double asqD() {
        return this.r * this.r + this.i * this.i;
    }

    public CplxD conj() {
        this.i = -this.i;
        return this;
    }

    public CplxD exp() {
        double s = Math.exp(this.r);
        this.r = Math.cos(this.i) * s;
        this.i = Math.sin(this.i) * s;
        return this;
    }

    public CplxD ln() {
        return this.set(Math.log(this.asqD()) * 0.5, this.ang());
    }

    public double ang() {
        return Math.atan2(this.i, this.r);
    }

    public int hashCode() {
        return (31 + Float.hashCode((float)this.i)) * 31 + Float.hashCode((float)this.r);
    }

    @Override
    public boolean equals(CplxD c) {
        return Double.doubleToLongBits(c.r) == Double.doubleToLongBits(this.r) && Double.doubleToLongBits(c.i) == Double.doubleToLongBits(this.i);
    }

    @Override
    public boolean equals(CplxF c) {
        return Double.doubleToLongBits(c.r) == Double.doubleToLongBits(this.r) && Double.doubleToLongBits(c.i) == Double.doubleToLongBits(this.i);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CplxD) {
            return this.equals((CplxD)obj);
        }
        if (obj instanceof CplxF) {
            return this.equals((CplxF)obj);
        }
        return false;
    }

    public String toString() {
        return "(" + this.r + " + " + this.i + " i)";
    }

    @Override
    public CplxD clone() {
        return new CplxD().set(this);
    }

    public static CplxD C0D() {
        return new CplxD();
    }

    public static CplxD C1D() {
        return CplxD.C_(1.0f);
    }

    public static CplxD CiD() {
        return CplxD.C_i(1.0);
    }

    public static CplxD C_i(double i) {
        CplxD c = new CplxD();
        c.i = i;
        return c;
    }

    public static CplxD C_(float r) {
        CplxD c = new CplxD();
        c.r = r;
        return c;
    }

    public static CplxD C_(float r, float i) {
        CplxD c = new CplxD();
        c.r = r;
        c.i = i;
        return c;
    }

    public static CplxD C_pol(double l, double a) {
        return new CplxD().setPol(l, a);
    }
}

