/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.math.cplx;

import cd4017be.math.Operand;
import cd4017be.math.cplx.CplxD;

public final class CplxF
implements Operand.F<CplxF> {
    public float r;
    public float i;

    public CplxF set(float r, float i) {
        this.r = r;
        this.i = i;
        return this;
    }

    public CplxF setPol(double l, double a) {
        this.r = (float)(Math.cos(a) * l);
        this.i = (float)(Math.sin(a) * l);
        return this;
    }

    @Override
    public CplxF set(CplxD o) {
        this.r = (float)o.r;
        this.i = (float)o.i;
        return this;
    }

    @Override
    public CplxF set(CplxF o) {
        this.r = o.r;
        this.i = o.i;
        return this;
    }

    @Override
    public CplxF sum(CplxF a, CplxF b) {
        this.r = a.r + b.r;
        this.i = a.i + b.i;
        return this;
    }

    @Override
    public CplxF dif(CplxF a, CplxF b) {
        this.r = a.r - b.r;
        this.i = a.i - b.i;
        return this;
    }

    @Override
    public CplxF prod(CplxF a, CplxF b) {
        return this.set(a.r * b.r - a.i * b.i, a.r * b.i + a.i * b.r);
    }

    @Override
    public CplxF quot(CplxF a, CplxF b) {
        float asq = 1.0f / b.asqF();
        return this.sca(this.prod(a, b), asq);
    }

    @Override
    public CplxF rem(CplxF a, CplxF b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CplxF sca(CplxF o, float s) {
        this.r = o.r * s;
        this.i = o.i * s;
        return this;
    }

    @Override
    public CplxF neg(CplxF o) {
        this.r = -o.r;
        this.i = -o.i;
        return this;
    }

    public CplxF conj() {
        this.i = -this.i;
        return this;
    }

    @Override
    public float asqF() {
        return this.r * this.r + this.i * this.i;
    }

    @Override
    public boolean equals(CplxF c) {
        return Float.floatToIntBits(this.r) == Float.floatToIntBits(c.r) && Float.floatToIntBits(this.i) == Float.floatToIntBits(c.i);
    }

    public int hashCode() {
        return (31 + Float.hashCode(this.i)) * 31 + Float.hashCode(this.r);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CplxF) {
            return this.equals((CplxF)obj);
        }
        if (obj instanceof CplxF) {
            return ((CplxF)obj).equals(this);
        }
        return false;
    }

    public String toString() {
        return "(" + this.r + " + " + this.i + " i)";
    }

    @Override
    public CplxF clone() {
        return new CplxF().set(this);
    }

    public static CplxF C0F() {
        return new CplxF();
    }

    public static CplxF C1F() {
        return CplxF.C_(1.0f);
    }

    public static CplxF CiF() {
        return CplxF.C_i(1.0f);
    }

    public static CplxF C_i(float i) {
        CplxF c = new CplxF();
        c.i = i;
        return c;
    }

    public static CplxF C_(float r) {
        CplxF c = new CplxF();
        c.r = r;
        return c;
    }

    public static CplxF C_(float r, float i) {
        CplxF c = new CplxF();
        c.r = r;
        c.i = i;
        return c;
    }

    public static CplxF C_pol(double l, double a) {
        return new CplxF().setPol(l, a);
    }
}

