/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.energy;

import cd4017be.api.energy.EnergyAutomation;
import cd4017be.api.energy.EnergyIndustrialCraft;
import cd4017be.api.energy.EnergyThermalExpansion;
import cd4017be.api.energy.IEnergyAccess;
import java.util.ArrayList;
import net.minecraft.tileentity.TileEntity;

public class EnergyAPI {
    private static ArrayList<Class<? extends IEnergyAccess>> list = new ArrayList();

    public static IEnergyAccess getAccess(TileEntity te) {
        for (Class<? extends IEnergyAccess> c : list) {
            try {
                IEnergyAccess e = c.newInstance();
                if (!e.create(te)) continue;
                return e;
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return new NullAccess();
    }

    public static void registerAccess(Class<? extends IEnergyAccess> c) {
        list.add(c);
    }

    static {
        EnergyAPI.registerAccess(EnergyAutomation.class);
        EnergyAPI.registerAccess(EnergyThermalExpansion.class);
        EnergyAPI.registerAccess(EnergyIndustrialCraft.class);
    }

    private static class NullAccess
    implements IEnergyAccess {
        private NullAccess() {
        }

        @Override
        public float getStorage(int s) {
            return 0.0f;
        }

        @Override
        public float getCapacity(int s) {
            return 0.0f;
        }

        @Override
        public float addEnergy(float amount, int s) {
            return 0.0f;
        }

        @Override
        public boolean create(TileEntity te) {
            return true;
        }
    }
}

