/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.energy;

import cd4017be.api.automation.IEnergy;
import cd4017be.api.automation.IEnergyStorage;
import cd4017be.api.automation.PipeEnergy;
import cd4017be.api.energy.IEnergyAccess;
import net.minecraft.tileentity.TileEntity;

public class EnergyAutomation
implements IEnergyAccess {
    private IEnergyStorage storage = null;
    private IEnergy energy = null;

    @Override
    public float getStorage(int s) {
        if (this.storage != null) {
            return (float)this.storage.getEnergy();
        }
        if (this.energy != null) {
            PipeEnergy pipe = this.energy.getEnergy((byte)s);
            if (pipe != null) {
                return (float)(pipe.Ucap * pipe.Ucap);
            }
            return 0.0f;
        }
        return 0.0f;
    }

    @Override
    public float getCapacity(int s) {
        if (this.storage != null) {
            return (float)this.storage.getCapacity();
        }
        if (this.energy != null) {
            PipeEnergy pipe = this.energy.getEnergy((byte)s);
            if (pipe != null) {
                return (long)pipe.Umax * (long)pipe.Umax;
            }
            return 0.0f;
        }
        return 0.0f;
    }

    @Override
    public float addEnergy(float e, int s) {
        if (this.storage != null) {
            return (float)this.storage.addEnergy(e);
        }
        if (this.energy != null) {
            PipeEnergy pipe = this.energy.getEnergy((byte)s);
            if (pipe != null && pipe != PipeEnergy.empty) {
                double d = pipe.Ucap * pipe.Ucap;
                if (d + (double)e < 0.0) {
                    e = -((float)d);
                    pipe.Ucap = 0.0;
                } else if (d + (double)e > (double)((long)pipe.Umax * (long)pipe.Umax)) {
                    e = (float)((long)pipe.Umax * (long)pipe.Umax) - (float)d;
                    pipe.Ucap = pipe.Umax;
                } else {
                    pipe.addEnergy(e);
                }
                return e;
            }
            return 0.0f;
        }
        return 0.0f;
    }

    @Override
    public boolean create(TileEntity te) {
        if (te instanceof IEnergyStorage) {
            this.storage = (IEnergyStorage)te;
            return true;
        }
        if (te instanceof IEnergy) {
            this.energy = (IEnergy)te;
            return true;
        }
        return false;
    }
}

