/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.energy;

import cd4017be.api.energy.IEnergyAccess;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyIndustrialCraft
implements IEnergyAccess {
    public static float E_Factor = 400.0f;
    IEnergySink storage = null;
    IEnergySource source = null;

    @Override
    public float getStorage(int s) {
        if (this.source != null) {
            return (float)this.source.getOfferedEnergy() * E_Factor;
        }
        return 0.0f;
    }

    @Override
    public float getCapacity(int s) {
        if (this.storage != null) {
            return (float)this.storage.getDemandedEnergy() * E_Factor;
        }
        return 0.0f;
    }

    @Override
    public float addEnergy(float e, int s) {
        if (e > 0.0f && this.storage != null) {
            return e - (float)this.storage.injectEnergy(ForgeDirection.getOrientation((int)s), e / E_Factor, 32.0) * E_Factor;
        }
        if (e < 0.0f && this.source != null) {
            float r = Math.min(e / -E_Factor, (float)this.source.getOfferedEnergy());
            this.source.drawEnergy(r);
            return r * E_Factor;
        }
        return 0.0f;
    }

    @Override
    public boolean create(TileEntity te) {
        if (te instanceof IEnergySink) {
            this.storage = (IEnergySink)te;
        }
        if (te instanceof IEnergySource) {
            this.source = (IEnergySource)te;
        }
        return this.storage != null || this.source != null;
    }
}

