/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.energy;

import cd4017be.api.energy.IEnergyAccess;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.util.Utils;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyStorage;
import cpw.mods.fml.common.FMLLog;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

public class EnergyThermalExpansion
implements IEnergyAccess {
    public static float E_Factor = 100.0f;
    private IEnergyHandler handler = null;
    private IEnergyStorage storage = null;

    @Override
    public float getStorage(int s) {
        try {
            if (this.handler != null && this.handler.canConnectEnergy(ForgeDirection.getOrientation((int)s))) {
                return (float)this.handler.getEnergyStored(ForgeDirection.getOrientation((int)s)) * E_Factor;
            }
            if (this.storage != null) {
                return (float)this.storage.getEnergyStored() * E_Factor;
            }
            return 0.0f;
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Energy API Error by %s", (Object[])new Object[]{this.handler != null ? this.handler.getClass().getName() : this.storage.getClass().getName()});
            return 0.0f;
        }
    }

    @Override
    public float getCapacity(int s) {
        try {
            if (this.handler != null && this.handler.canConnectEnergy(ForgeDirection.getOrientation((int)s))) {
                return (float)this.handler.getMaxEnergyStored(ForgeDirection.getOrientation((int)s)) * E_Factor;
            }
            if (this.storage != null) {
                return (float)this.storage.getMaxEnergyStored() * E_Factor;
            }
            return 0.0f;
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Energy API Error by %s", (Object[])new Object[]{this.handler != null ? this.handler.getClass().getName() : this.storage.getClass().getName()});
            return 0.0f;
        }
    }

    @Override
    public float addEnergy(float e, int s) {
        if (this.handler != null && this.handler.canConnectEnergy(ForgeDirection.getOrientation((int)s))) {
            if (e > 0.0f) {
                return (float)this.handler.receiveEnergy(ForgeDirection.getOrientation((int)s), (int)Math.floor(e / E_Factor), false) * E_Factor;
            }
            return (float)this.handler.extractEnergy(ForgeDirection.getOrientation((int)s), (int)Math.floor(e / -E_Factor), false) * -E_Factor;
        }
        if (this.storage != null) {
            if (e > 0.0f) {
                return (float)this.storage.receiveEnergy((int)Math.floor(e / E_Factor), false) * E_Factor;
            }
            return (float)this.storage.extractEnergy((int)Math.floor(e / -E_Factor), false) * -E_Factor;
        }
        return 0.0f;
    }

    @Override
    public boolean create(TileEntity te) {
        if (te instanceof IEnergyHandler) {
            this.handler = (IEnergyHandler)te;
        }
        if (te instanceof IEnergyStorage) {
            this.storage = (IEnergyStorage)te;
        }
        return this.handler != null || this.storage != null;
    }

    public static float outputEnergy(ModTileEntity tile, float e, int sides) {
        for (byte s = 0; s < 6 && e >= E_Factor; s = (byte)(s + 1)) {
            TileEntity te;
            if ((sides >> s & 1) == 0 || (te = Utils.getTileOnSide(tile, s)) == null || !(te instanceof IEnergyHandler)) continue;
            e -= (float)((IEnergyHandler)te).receiveEnergy(ForgeDirection.getOrientation((int)(s ^ 1)), (int)Math.floor(e / E_Factor), false) * E_Factor;
        }
        return e;
    }

    public static float addEnergy(ItemStack item, float e) {
        if (e == 0.0f || item == null || !(item.func_77973_b() instanceof IEnergyContainerItem)) {
            return 0.0f;
        }
        IEnergyContainerItem cont = (IEnergyContainerItem)item.func_77973_b();
        if (e > 0.0f) {
            return (float)cont.receiveEnergy(item, (int)Math.floor(e / E_Factor), false) * E_Factor;
        }
        return (float)cont.extractEnergy(item, (int)Math.floor(e / -E_Factor), false) * -E_Factor;
    }
}

