/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.lib.IGuiItem;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.TileBlockRegistry;
import cd4017be.lib.TileContainer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class BlockGuiHandler
implements IGuiHandler {
    private static final String guiChannel = "CD4017BE_gui";
    public static BlockGuiHandler instance = new BlockGuiHandler();
    private static Object modRef;
    public static FMLEventChannel eventChannel;

    public static void registerMod(Object mod) {
        if (modRef == null) {
            modRef = mod;
            NetworkRegistry.INSTANCE.registerGuiHandler(modRef, (IGuiHandler)instance);
        }
    }

    public static void openGui(EntityPlayer player, World world, int x, int y, int z) {
        if (modRef != null) {
            player.openGui(modRef, 0, world, x, y, z);
        } else {
            FMLLog.severe((String)"CD4017BE-lib: BlockGuiHandler failed to open Gui! No Mod registered!", (Object[])new Object[0]);
        }
    }

    public static void openItemGui(EntityPlayer player, World world, int x, int y, int z) {
        if (modRef != null) {
            player.openGui(modRef, 1, world, x, y, z);
        } else {
            FMLLog.severe((String)"CD4017BE-lib: BlockGuiHandler failed to open Gui! No Mod registered!", (Object[])new Object[0]);
        }
    }

    public static void sendPacketToServer(ByteArrayOutputStream data) {
        eventChannel.sendToServer(new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])data.toByteArray()), guiChannel));
    }

    public static void sendPacketToPlayer(EntityPlayerMP player, ByteArrayOutputStream data) {
        eventChannel.sendTo(new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])data.toByteArray()), guiChannel), player);
    }

    public static ByteArrayOutputStream getPacketTargetData(int x, int y, int z) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(x);
        dos.writeInt(y);
        dos.writeInt(z);
        return bos;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onServerPacketReceived(FMLNetworkEvent.ClientCustomPacketEvent event) {
        FMLProxyPacket packet = event.packet;
        if (!packet.channel().equals(guiChannel)) {
            return;
        }
        Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        if (container != null && container instanceof TileContainer) {
            try {
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(packet.payload().array()));
                ModTileEntity te = ((TileContainer)container).tileEntity;
                if (te.field_145851_c == dis.readInt() && te.field_145848_d == dis.readInt() && te.field_145849_e == dis.readInt()) {
                    ((TileContainer)container).onDataUpdate(dis);
                }
                dis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerPacketReceived(FMLNetworkEvent.ServerCustomPacketEvent event) {
        FMLProxyPacket packet = event.packet;
        if (!packet.channel().equals(guiChannel)) {
            return;
        }
        if (!(event.handler instanceof NetHandlerPlayServer)) {
            FMLLog.log((Level)Level.WARN, (String)"NetHandler not instanceof NetHandlerPlayServer!", (Object[])new Object[0]);
        }
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(packet.payload().array()));
            int x = dis.readInt();
            int y = dis.readInt();
            int z = dis.readInt();
            if (y < 0) {
                ItemStack item = player.func_71045_bC();
                if (item != null && item.func_77973_b() instanceof IGuiItem) {
                    ((IGuiItem)item.func_77973_b()).onPlayerCommand(player.field_70170_p, (EntityPlayer)player, dis);
                }
            } else {
                TileEntity te = player.field_70170_p.func_147438_o(x, y, z);
                if (te != null && te instanceof ModTileEntity) {
                    ((ModTileEntity)te).onPlayerCommand(dis, player);
                }
            }
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == 0) {
            TileBlockRegistry.TileBlockEntry entry = TileBlockRegistry.getBlockEntry(world.func_147439_a(x, y, z));
            TileEntity te = world.func_147438_o(x, y, z);
            if (entry != null && entry.container != null && te != null && entry.tileEntity.isInstance(te)) {
                try {
                    return entry.container.getConstructor(ModTileEntity.class, EntityPlayer.class).newInstance(new Object[]{(ModTileEntity)te, player});
                }
                catch (NoSuchMethodException ex) {
                    FMLLog.severe((String)"CD4017BE-lib: TileContainer %1$s is missing the Constructor ( %2$s , %3$s )", (Object[])new Object[]{entry.container.getName(), ModTileEntity.class.getName(), EntityPlayer.class.getName()});
                    return null;
                }
                catch (InstantiationException ex) {
                    ex.printStackTrace();
                    return null;
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                    return null;
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            return null;
        }
        if (ID == 1) {
            ItemStack item = player.func_71045_bC();
            if (item != null && item.func_77973_b() instanceof IGuiItem) {
                return ((IGuiItem)item.func_77973_b()).getContainer(world, player, x, y, z);
            }
            return null;
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == 0) {
            TileBlockRegistry.TileBlockEntry entry = TileBlockRegistry.getBlockEntry(world.func_147439_a(x, y, z));
            TileEntity te = world.func_147438_o(x, y, z);
            if (entry != null && entry.gui != null && te != null && entry.tileEntity.isInstance(te)) {
                try {
                    return entry.gui.getConstructor(entry.tileEntity, EntityPlayer.class).newInstance(new Object[]{entry.tileEntity.cast(te), player});
                }
                catch (NoSuchMethodException ex) {
                    FMLLog.severe((String)"CD4017BE-lib: GuiContainer %1$s is missing the Constructor ( %2$s , %3$s )", (Object[])new Object[]{entry.gui.getName(), entry.tileEntity.getName(), EntityPlayer.class.getName()});
                    return null;
                }
                catch (InstantiationException ex) {
                    ex.printStackTrace();
                    return null;
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                    return null;
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            return null;
        }
        if (ID == 1) {
            ItemStack item = player.func_71045_bC();
            if (item != null && item.func_77973_b() instanceof IGuiItem) {
                return ((IGuiItem)item.func_77973_b()).getGui(world, player, x, y, z);
            }
            return null;
        }
        return null;
    }

    static {
        eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(guiChannel);
        eventChannel.register((Object)instance);
    }
}

