/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.api.automation.IOperatingArea;
import cpw.mods.fml.common.FMLCommonHandler;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class MovedBlock {
    public final NBTTagCompound nbt;
    public final Block blockId;
    public final byte metadata;

    public MovedBlock(Block id, int m, NBTTagCompound tile) {
        this.blockId = id;
        this.metadata = (byte)m;
        this.nbt = tile;
    }

    public boolean set(World world, int x, int y, int z) {
        TileEntity tile = null;
        boolean multipart = false;
        if (this.nbt != null) {
            this.nbt.func_74768_a("x", x);
            this.nbt.func_74768_a("y", y);
            this.nbt.func_74768_a("z", z);
            multipart = this.nbt.func_74779_i("id").equals("savedMultipart");
            if (multipart) {
                try {
                    Class<?> multipartHelper = Class.forName("codechicken.multipart.MultipartHelper");
                    Method m = multipartHelper.getMethod("createTileFromNBT", World.class, NBTTagCompound.class);
                    tile = (TileEntity)m.invoke(null, world, this.nbt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                tile = TileEntity.func_145827_c((NBTTagCompound)this.nbt);
                if (tile instanceof IOperatingArea) {
                    int[] area = ((IOperatingArea)tile).getOperatingArea();
                    area[0] = area[0] + x;
                    area[3] = area[3] + x;
                    area[1] = area[1] + y;
                    area[4] = area[4] + y;
                    area[2] = area[2] + z;
                    area[5] = area[5] + z;
                }
            }
        }
        boolean set = MovedBlock.setBlock(world, x, y, z, this.blockId, this.metadata, tile);
        if (multipart && set) {
            try {
                Class<?> multipartHelper = Class.forName("codechicken.multipart.MultipartHelper");
                multipartHelper.getMethod("sendDescPacket", World.class, TileEntity.class).invoke(null, world, tile);
                Class<?> tileMultipart = Class.forName("codechicken.multipart.TileMultipart");
                tileMultipart.getMethod("onMoved", new Class[0]).invoke((Object)tile, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return set;
    }

    public static MovedBlock get(World world, int x, int y, int z) {
        Block id = world.func_147439_a(x, y, z);
        int m = world.func_72805_g(x, y, z);
        NBTTagCompound nbt = null;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null) {
            if (te instanceof IOperatingArea) {
                int[] area = ((IOperatingArea)te).getOperatingArea();
                area[0] = area[0] - x;
                area[3] = area[3] - x;
                area[1] = area[1] - y;
                area[4] = area[4] - y;
                area[2] = area[2] - z;
                area[5] = area[5] - z;
            }
            nbt = new NBTTagCompound();
            te.func_145841_b(nbt);
        }
        return new MovedBlock(id, m, nbt);
    }

    public static boolean setBlock(World world, int x, int y, int z, Block id, int m, TileEntity tile) {
        if (x < -30000000 || z < -30000000 || x >= 30000000 || z >= 30000000 || y < 0 || y >= 256) {
            return false;
        }
        Chunk chunk = world.func_72938_d(x, z);
        world.func_147475_p(x, y, z);
        int cx = x & 0xF;
        int cy = y & 0xF;
        int cz = z & 0xF;
        int j1 = cz << 4 | cx;
        if (y >= chunk.field_76638_b[j1] - 1) {
            chunk.field_76638_b[j1] = -999;
        }
        int k1 = chunk.field_76634_f[j1];
        ExtendedBlockStorage[] storageArrays = chunk.func_76587_i();
        ExtendedBlockStorage extendedblockstorage = storageArrays[y >> 4];
        boolean flag = false;
        if (extendedblockstorage == null) {
            if (id == null) {
                return true;
            }
            ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(y >> 4 << 4, !world.field_73011_w.field_76576_e);
            storageArrays[y >> 4] = extendedBlockStorage;
            extendedblockstorage = extendedBlockStorage;
            flag = y >= k1;
        }
        extendedblockstorage.func_150818_a(cx, cy, cz, id);
        extendedblockstorage.func_76654_b(cx, cy, cz, m);
        chunk.field_76643_l = true;
        world.func_147455_a(x, y, z, tile);
        world.func_147471_g(x, y, z);
        return true;
    }

    public static void moveEntity(Entity entity, int dim, double x, double y, double z) {
        int dimO = entity.field_70170_p.field_73011_w.field_76574_g;
        if (entity instanceof EntityPlayerMP) {
            if (dim != dimO) {
                MovedBlock.tpPlayerToDim((EntityPlayerMP)entity, dim, x, y, z);
            } else {
                ((EntityPlayerMP)entity).func_70634_a(x, y, z);
            }
        } else if (dim != dimO) {
            entity.field_70170_p.field_72984_F.func_76320_a("changeDimension");
            MinecraftServer server = MinecraftServer.func_71276_C();
            WorldServer worldO = server.func_71218_a(dimO);
            WorldServer worldN = server.func_71218_a(dim);
            entity.field_71093_bK = dim;
            entity.field_70170_p.func_72900_e(entity);
            entity.field_70128_L = false;
            entity.field_70170_p.field_72984_F.func_76320_a("reposition");
            MovedBlock.tpEntity(entity, worldO, worldN, x, y, z);
            entity.field_70170_p.field_72984_F.func_76318_c("reloading");
            Entity var6 = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)entity), (World)worldN);
            if (var6 != null) {
                var6.func_82141_a(entity, true);
                worldN.func_72838_d(var6);
            }
            entity.field_70128_L = true;
            entity.field_70170_p.field_72984_F.func_76319_b();
            worldO.func_82742_i();
            worldN.func_82742_i();
            entity.field_70170_p.field_72984_F.func_76319_b();
        } else {
            entity.func_70107_b(x, y, z);
        }
    }

    private static void tpPlayerToDim(EntityPlayerMP player, int dim, double x, double y, double z) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        ServerConfigurationManager manager = server.func_71203_ab();
        int j = player.field_71093_bK;
        WorldServer worldO = server.func_71218_a(player.field_71093_bK);
        player.field_71093_bK = dim;
        WorldServer worldN = server.func_71218_a(player.field_71093_bK);
        player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, worldN.field_73013_u, worldN.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        worldO.func_72973_f((Entity)player);
        player.field_70128_L = false;
        MovedBlock.tpEntity((Entity)player, worldO, worldN, x, y, z);
        worldO.func_73040_p().func_72695_c(player);
        worldN.func_73040_p().func_72683_a(player);
        worldN.field_73059_b.func_73158_c((int)player.field_70165_t >> 4, (int)player.field_70161_v >> 4);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldN);
        manager.func_72354_b(player, worldN);
        manager.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, j, dim);
    }

    private static void tpEntity(Entity entity, WorldServer os, WorldServer ns, double x, double y, double z) {
        os.field_72984_F.func_76320_a("placing");
        if (entity.func_70089_S()) {
            ns.func_72838_d(entity);
            entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
            ns.func_72866_a(entity, false);
        }
        os.field_72984_F.func_76319_b();
        entity.func_70029_a((World)ns);
    }
}

