/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.lib.ConfigurationFile;
import cd4017be.lib.util.Utils;
import cpw.mods.fml.common.FMLLog;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class TooltipInfo {
    private static HashMap<String, String> toolTips = new HashMap();

    public static String getInfo(String name) {
        return toolTips.get(name);
    }

    public static void addInfo(String name, String info) {
        toolTips.put(name, info);
    }

    public static void loadInfoFile(ResourceLocation resource) {
        try {
            IResource r = Minecraft.func_71410_x().func_110442_L().func_110536_a(resource);
            for (String s : IOUtils.readLines((InputStream)r.func_110527_b())) {
                int p;
                if (s.isEmpty() || s.charAt(0) == '#' || (p = s.indexOf(61)) <= 0 || p >= s.length() - 1) continue;
                String k = s.substring(0, p).trim();
                String v = s.substring(p + 1).trim().replace("\\n", "\n");
                toolTips.put(k, v);
            }
        }
        catch (IOException e) {
            FMLLog.getLogger().warn("Failed to load Tool-tip-file of Mod " + resource.func_110624_b(), (Throwable)e);
        }
    }

    public static void replaceReferences(ConfigurationFile cfg) {
        for (Map.Entry<String, String> e : toolTips.entrySet()) {
            int q;
            String s = e.getValue();
            int p = 0;
            while ((q = s.indexOf("\\<", p)) >= p && (p = s.indexOf(">", q)) > q) {
                String id = s.substring(q + 2, p);
                String repl = TooltipInfo.formatReference(id, cfg);
                s = s.replace("\\<" + id + ">", repl);
                p = q + repl.length();
            }
            e.setValue(s);
        }
    }

    private static String formatReference(String id, ConfigurationFile cfg) {
        if (id.startsWith("A")) {
            try {
                int p = id.indexOf(":");
                String k = id.substring(3, p);
                int idx = Integer.parseInt(id.substring(p + 1));
                if (id.startsWith("AB.")) {
                    return Boolean.toString(cfg.getBooleanArray(k)[idx]);
                }
                if (id.startsWith("AW.")) {
                    return Byte.toString(cfg.getByteArray(k)[idx]);
                }
                if (id.startsWith("AS.")) {
                    return Short.toString(cfg.getShortArray(k)[idx]);
                }
                if (id.startsWith("AI.")) {
                    return Integer.toString(cfg.getIntArray(k)[idx]);
                }
                if (id.startsWith("AL.")) {
                    return Long.toString(cfg.getLongArray(k)[idx]);
                }
                if (id.startsWith("AF.")) {
                    return Utils.formatNumber(cfg.getFloatArray(k)[idx], 3, 0);
                }
                if (id.startsWith("AD.")) {
                    return Utils.formatNumber(cfg.getDoubleArray(k)[idx], 3, 0);
                }
                if (id.startsWith("AT.")) {
                    return cfg.getStringArray(k)[idx];
                }
            }
            catch (Exception p) {}
        } else {
            String k = id.substring(2);
            if (id.startsWith("B.")) {
                return Boolean.toString(cfg.getBoolean(k, false));
            }
            if (id.startsWith("W.")) {
                return Byte.toString(cfg.getByte(k, (byte)0));
            }
            if (id.startsWith("S.")) {
                return Short.toString(cfg.getShort(k, (short)0));
            }
            if (id.startsWith("I.")) {
                return Integer.toString(cfg.getInt(k, 0));
            }
            if (id.startsWith("L.")) {
                return Long.toString(cfg.getLong(k, 0L));
            }
            if (id.startsWith("F.")) {
                return Utils.formatNumber(cfg.getFloat(k, 0.0f), 3, 0);
            }
            if (id.startsWith("D.")) {
                return Utils.formatNumber(cfg.getDouble(k, 0.0), 3, 0);
            }
            if (id.startsWith("T.")) {
                return cfg.getString(k, "");
            }
        }
        return "";
    }
}

