/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.templates;

import cd4017be.lib.TileBlock;
import cd4017be.lib.templates.IPipe;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPipe
extends TileBlock {
    public float size = 0.25f;
    protected boolean keepBB = false;

    public BlockPipe(String id, Material m, Class<? extends ItemBlock> item, int type, String ... tex) {
        super(id, m, item, type, tex);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        if (this.keepBB) {
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        float f1 = (1.0f - this.size) / 2.0f;
        float f2 = (1.0f + this.size) / 2.0f;
        float[] bb = new float[]{f1, f2, f1, f2, f1, f2};
        if (te != null && te instanceof IPipe) {
            IPipe pipe = (IPipe)te;
            IPipe.Cover cover = pipe.getCover();
            if (cover != null) {
                bb = new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f};
            } else {
                for (byte s = 0; s < 6; s = (byte)(s + 1)) {
                    if (pipe.textureForSide(s) < 0) continue;
                    bb[s] = (s & 1) == 0 ? 0.0f : 1.0f;
                }
            }
        }
        this.func_149676_a(bb[4], bb[0], bb[2], bb[5], bb[1], bb[3]);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return this.func_149668_a(world, x, y, z);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB area, List list, Entity entity) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof IPipe && ((IPipe)te).getCover() != null) {
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)((double)x + 1.0), (double)((double)y + 1.0), (double)((double)z + 1.0));
            if (area.func_72326_a(box)) {
                list.add(box);
            }
            return;
        }
        this.func_149719_a((IBlockAccess)world, x, y, z);
        double d0 = (1.0f - this.size) / 2.0f;
        double d1 = (1.0f + this.size) / 2.0f;
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + d0), (double)((double)z + d0), (double)((double)x + this.field_149755_E), (double)((double)y + d1), (double)((double)z + d1));
        if (box.func_72326_a(area)) {
            list.add(box);
        }
        if ((this.field_149760_C < d0 || this.field_149756_F > d1) && (box = AxisAlignedBB.func_72330_a((double)((double)x + d0), (double)((double)y + this.field_149760_C), (double)((double)z + d0), (double)((double)x + d1), (double)((double)y + this.field_149756_F), (double)((double)z + d1))).func_72326_a(area)) {
            list.add(box);
        }
        if ((this.field_149754_D < d0 || this.field_149757_G > d1) && (box = AxisAlignedBB.func_72330_a((double)((double)x + d0), (double)((double)y + d0), (double)((double)z + this.field_149754_D), (double)((double)x + d1), (double)((double)y + d1), (double)((double)z + this.field_149757_G))).func_72326_a(area)) {
            list.add(box);
        }
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 v0, Vec3 v1) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof IPipe && ((IPipe)te).getCover() != null) {
            return super.func_149731_a(world, x, y, z, v0, v1);
        }
        this.func_149719_a((IBlockAccess)world, x, y, z);
        this.keepBB = true;
        double d0 = (1.0f - this.size) / 2.0f;
        double d1 = (1.0f + this.size) / 2.0f;
        double y0 = this.field_149760_C;
        double y1 = this.field_149756_F;
        double z0 = this.field_149754_D;
        double z1 = this.field_149757_G;
        this.field_149760_C = d0;
        this.field_149756_F = d1;
        this.field_149754_D = d0;
        this.field_149757_G = d1;
        MovingObjectPosition pos0 = super.func_149731_a(world, x, y, z, v0, v1);
        this.field_149759_B = d0;
        this.field_149755_E = d1;
        this.field_149760_C = y0;
        this.field_149756_F = y1;
        MovingObjectPosition pos1 = super.func_149731_a(world, x, y, z, v0, v1);
        if (pos1 != null && (pos0 == null || pos0.field_72307_f.func_72436_e(v0) > pos1.field_72307_f.func_72436_e(v0))) {
            pos0 = pos1;
        }
        this.field_149760_C = d0;
        this.field_149756_F = d1;
        this.field_149754_D = z0;
        this.field_149757_G = z1;
        pos1 = super.func_149731_a(world, x, y, z, v0, v1);
        this.keepBB = false;
        return pos1 != null && (pos0 == null || pos0.field_72307_f.func_72436_e(v0) > pos1.field_72307_f.func_72436_e(v0)) ? pos1 : pos0;
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te != null && te instanceof IPipe && ((IPipe)te).getCover() != null;
    }

    public boolean func_149655_b(IBlockAccess world, int x, int y, int z) {
        return this.isNormalCube(world, x, y, z);
    }

    @Override
    public boolean func_149721_r() {
        return false;
    }

    @Override
    public IIcon func_149691_a(int s, int m) {
        return super.getIconN(m);
    }

    @Override
    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.isNormalCube(world, x, y, z);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        Block block;
        IPipe.Cover cover;
        float h = this.field_149782_v;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof IPipe && (cover = ((IPipe)te).getCover()) != null && (block = cover.blockId) != null) {
            float h1 = block.func_149712_f(world, 0, -1, 0);
            h = h1 < 0.0f ? -1.0f : (h += h1);
        }
        return h;
    }

    public float getExplosionResistance(Entity ex, World world, int x, int y, int z, double X, double Y, double Z) {
        Block block;
        IPipe.Cover cover;
        float h = this.func_149638_a(ex);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof IPipe && (cover = ((IPipe)te).getCover()) != null && (block = cover.blockId) != null) {
            h += block.func_149638_a(ex);
        }
        return h;
    }

    public float func_149685_I() {
        return 1.0f;
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        return this.isNormalCube(world, x, y, z) ? 255 : 0;
    }
}

