/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.templates;

import cd4017be.lib.BlockItemRegistry;
import cd4017be.lib.ModFluid;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialTransparent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class BlockSuperfluid
extends BlockFluidClassic {
    public static final Material materialGas = new MaterialGas();
    private Random random = new Random();
    public static HashMap<Fluid, Fluid> reactConversions = new HashMap();
    public static HashMap<Fluid, PotionEffect[]> effects = new HashMap();

    public BlockSuperfluid(String id, ModFluid fluid) {
        super((Fluid)fluid, fluid.isGaseous() ? (fluid.getTemperature() > 350 ? Material.field_151581_o : materialGas) : Material.field_151586_h);
        this.func_149663_c(id);
        BlockItemRegistry.registerBlock((Block)this, id, ItemBlock.class, new Object[0]);
        BlockItemRegistry.registerName((Object)this, fluid.getLocalizedName());
        this.func_149658_d(BlockItemRegistry.currentMod.concat(":liquids/").concat(fluid.getTexName()));
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int[] p;
        int m = world.func_72805_g(x, y, z);
        if (m == 0) {
            if (this.tryReplace(world, x, y + this.densityDir, z)) {
                this.moveSourceTo(world, x, y, z, x, y + this.densityDir, z);
                return;
            }
            if (!this.isFlowingVertically((IBlockAccess)world, x, y, z)) {
                boolean[] b = this.getOptimalFlowDirections(world, x, y, z);
                int x1 = x;
                int z1 = z;
                if (b[0]) {
                    --x1;
                }
                if (b[1]) {
                    ++x1;
                }
                if (b[2]) {
                    --z1;
                }
                if (b[3]) {
                    ++z1;
                }
                if (x1 != x || z1 != z && this.tryReplace(world, x1, y, z1)) {
                    this.moveSourceTo(world, x, y, z, x1, y, z1);
                }
            }
        } else if (m <= 4 && this.canDisplace((IBlockAccess)world, x, y + this.densityDir, z) && (p = this.findSource(world, x, y, z)) != null) {
            world.func_147464_a(p[0], p[1], p[2], (Block)this, this.tickRate);
        }
        super.func_149674_a(world, x, y, z, rand);
    }

    public void func_149695_a(World world, int x, int y, int z, Block blockId) {
        if (!this.checkFluidReaction(world, x, y, z)) {
            super.func_149695_a(world, x, y, z, blockId);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (!this.checkFluidReaction(world, x, y, z)) {
            super.func_149726_b(world, x, y, z);
        }
    }

    private boolean checkFluidReaction(World world, int x, int y, int z) {
        if (this.densityDir > 0) {
            return false;
        }
        Fluid fluid = reactConversions.get(this.getFluid());
        if (fluid == null) {
            return false;
        }
        boolean react = false;
        for (int s = 0; s < 6; ++s) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)s);
            int x1 = x + dir.offsetX;
            int y1 = y + dir.offsetY;
            int z1 = z + dir.offsetZ;
            Block id = world.func_147439_a(x1, y1, z1);
            if ((id == Block.func_149684_b((String)"waterMoving") || id == Block.func_149684_b((String)"waterStill")) && fluid.getTemperature() < FluidRegistry.WATER.getTemperature()) {
                world.func_147465_d(x1, y1, z1, world.func_72805_g(x1, y1, z1) == 0 ? Block.func_149684_b((String)"ice") : Block.func_149684_b((String)"snow"), 0, 2);
                react = true;
                continue;
            }
            if ((id == Block.func_149684_b((String)"lavaMoving") || id == Block.func_149684_b((String)"lavaStill")) && fluid.getTemperature() < FluidRegistry.LAVA.getTemperature()) {
                world.func_147465_d(x1, y1, z1, world.func_72805_g(x1, y1, z1) == 0 ? Block.func_149684_b((String)"obsidian") : Block.func_149684_b((String)"cobblestone"), 0, 2);
                react = true;
                continue;
            }
            int t = BlockFluidBase.getTemperature((IBlockAccess)world, (int)x1, (int)y1, (int)z1);
            if (t == Integer.MAX_VALUE || t <= fluid.getTemperature()) continue;
            react = true;
        }
        if (react) {
            int[] p;
            if (this.random.nextFloat() < 0.05f && (p = this.findSource(world, x, y, z)) != null && (p[0] != x || p[1] != y || p[2] != z)) {
                world.func_72921_c(p[0], p[1], p[2], 1, 3);
            }
            world.func_147465_d(x, y, z, fluid.getBlock(), 0, 3);
            world.func_147459_d(x, y, z, fluid.getBlock());
            return true;
        }
        return false;
    }

    public boolean tryReplace(World world, int x, int y, int z) {
        if (world.func_147437_c(x, y, z)) {
            return true;
        }
        Block bId = world.func_147439_a(x, y, z);
        if (bId == this) {
            return world.func_72805_g(x, y, z) != 0;
        }
        Material material = bId.func_149688_o();
        if (material.func_76230_c() || material == Material.field_151567_E) {
            return false;
        }
        int density = BlockSuperfluid.getDensity((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (density == Integer.MAX_VALUE) {
            bId.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            return true;
        }
        return this.density > density;
    }

    public void moveSourceTo(World world, int x, int y, int z, int nx, int ny, int nz) {
        world.func_72921_c(x, y, z, 1, 3);
        world.func_147465_d(nx, ny, nz, (Block)this, 0, 3);
        world.func_147464_a(x, y, z, (Block)this, this.tickRate);
        world.func_147459_d(x, y, z, (Block)this);
    }

    public int[] findSource(World world, int x, int y, int z) {
        int m = world.func_72805_g(x, y, z);
        while (m > 0) {
            int m1;
            if (world.func_147439_a(x - 1, y, z) == this && (m1 = world.func_72805_g(x - 1, y, z)) < m) {
                --x;
            } else if (world.func_147439_a(x + 1, y, z) == this && (m1 = world.func_72805_g(x + 1, y, z)) < m) {
                ++x;
            } else if (world.func_147439_a(x, y, z - 1) == this && (m1 = world.func_72805_g(x, y, z - 1)) < m) {
                --z;
            } else if (world.func_147439_a(x, y, z + 1) == this && (m1 = world.func_72805_g(x, y, z + 1)) < m) {
                ++z;
            } else {
                return null;
            }
            m = m1;
        }
        return new int[]{x, y, z};
    }

    public void func_149640_a(World world, int x, int y, int z, Entity entity, Vec3 vec) {
        super.func_149640_a(world, x, y, z, entity, vec);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        int t;
        PotionEffect[] eff = effects.get(this.getFluid());
        if (eff != null && entity instanceof EntityLivingBase) {
            for (PotionEffect e : eff) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(e.func_76456_a(), e.func_76459_b(), e.func_76458_c()));
            }
        }
        if ((t = BlockFluidBase.getTemperature((IBlockAccess)world, (int)x, (int)y, (int)z)) > 350) {
            entity.func_70015_d((t - 300) / 50);
        }
    }

    public static class MaterialGas
    extends MaterialTransparent {
        public MaterialGas() {
            super(MapColor.field_151660_b);
            this.func_76219_n();
        }
    }
}

