/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import cd4017be.lib.util.Vec2;

public class Vec3
extends Vec2 {
    public double y;

    protected Vec3() {
    }

    public Vec3(Vec2 vec, double y) {
        this.x = vec.x;
        this.y = y;
        this.z = vec.z;
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z);
    }

    @Override
    public double sq() {
        return this.scale(this);
    }

    @Override
    public double l() {
        return Math.sqrt(this.scale(this));
    }

    public static Vec3 Def(double x, double y, double z) {
        Vec3 vec = new Vec3();
        vec.x = x;
        vec.y = y;
        vec.z = z;
        return vec;
    }

    @Override
    public Vec3 copy() {
        Vec3 vec = new Vec3();
        vec.x = this.x;
        vec.y = this.y;
        vec.z = this.z;
        return vec;
    }

    @Override
    public Vec3 neg() {
        Vec3 vec = new Vec3();
        vec.x = -this.x;
        vec.y = -this.y;
        vec.z = -this.z;
        return vec;
    }

    @Override
    public Vec3 norm() {
        double d = this.l();
        Vec3 vec = new Vec3();
        vec.x = this.x / d;
        vec.y = this.y / d;
        vec.z = this.z / d;
        return vec;
    }

    public Vec3 add(double x, double y, double z) {
        Vec3 vec = new Vec3();
        vec.x = this.x + x;
        vec.y = this.y + y;
        vec.z = this.z + z;
        return vec;
    }

    public Vec3 scale(double x, double y, double z) {
        Vec3 vec = new Vec3();
        vec.x = this.x * x;
        vec.y = this.y * y;
        vec.z = this.z * z;
        return vec;
    }

    public Vec3 add(Vec3 a) {
        Vec3 vec = new Vec3();
        vec.x = this.x + a.x;
        vec.y = this.y + a.y;
        vec.z = this.z + a.z;
        return vec;
    }

    public Vec3 diff(Vec3 a) {
        Vec3 vec = new Vec3();
        vec.x = this.x - a.x;
        vec.y = this.y - a.y;
        vec.z = this.z - a.z;
        return vec;
    }

    @Override
    public Vec3 scale(double s) {
        Vec3 vec = new Vec3();
        vec.x = this.x * s;
        vec.y = this.y * s;
        vec.z = this.z * s;
        return vec;
    }

    public double scale(Vec3 a) {
        return this.x * a.x + this.y * a.y + this.z * a.z;
    }

    public Vec3 mult(Vec3 a) {
        Vec3 vec = new Vec3();
        vec.x = this.y * a.z - this.z * a.y;
        vec.y = this.z * a.x - this.x * a.z;
        vec.z = this.x * a.y - this.y * a.x;
        return vec;
    }

    public Vec3 rotateX(double cos, double sin) {
        Vec3 vec = new Vec3();
        vec.x = this.x;
        vec.y = this.y * cos - this.z * sin;
        vec.z = this.z * cos + this.y * sin;
        return vec;
    }

    public Vec3 rotateY(double cos, double sin) {
        Vec3 vec = new Vec3();
        vec.x = this.x * cos + this.z * sin;
        vec.y = this.y;
        vec.z = this.z * cos - this.x * sin;
        return vec;
    }

    public Vec3 rotateZ(double cos, double sin) {
        Vec3 vec = new Vec3();
        vec.x = this.x * cos - this.y * sin;
        vec.y = this.y * cos + this.x * sin;
        vec.z = this.z;
        return vec;
    }

    public Vec3 rotate(Vec3 ax, double an) {
        return this.rotate(ax, Math.cos(an), Math.sin(an));
    }

    public Vec3 rotate(Vec3 ax, double cos, double sin) {
        Vec3 b = ax.scale(this.scale(ax));
        Vec3 a = this.diff(b);
        Vec3 c = a.mult(ax);
        c = c.scale(Math.sqrt(a.sq() / c.sq()));
        return a.scale(Math.cos(cos)).add(c.scale(Math.sin(sin))).add(b);
    }

    public net.minecraft.util.Vec3 toMinecraftVec() {
        return net.minecraft.util.Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
    }
}

