/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.automation;

import cd4017be.api.automation.ITeslaTransmitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TeslaNetwork {
    public static TeslaNetwork instance = new TeslaNetwork();
    private Map<Short, List<ITeslaTransmitter>> network = new HashMap<Short, List<ITeslaTransmitter>>();

    public void register(ITeslaTransmitter transmitter) {
        short id = transmitter.getFrequency();
        List<ITeslaTransmitter> list = this.network.get(id);
        if (list == null) {
            list = new ArrayList<ITeslaTransmitter>();
            this.network.put(id, list);
        }
        if (!list.contains(transmitter)) {
            list.add(transmitter);
        }
    }

    public void remove(ITeslaTransmitter transmitter) {
        short id = transmitter.getFrequency();
        List<ITeslaTransmitter> list = this.network.get(id);
        if (list == null) {
            return;
        }
        list.remove(transmitter);
        if (list.isEmpty()) {
            this.network.remove(id);
        }
    }

    public void unloadAll() {
        this.network.clear();
    }

    public void repairMap() {
        Map.Entry[] objects = (Map.Entry[])this.network.entrySet().toArray();
        this.network.clear();
        for (Map.Entry entry : objects) {
            for (ITeslaTransmitter te : (List)entry.getValue()) {
                if (!te.checkAlive()) continue;
                this.register(te);
            }
        }
    }

    public void transmittEnergy(ITeslaTransmitter transmitter) {
        short id = transmitter.getFrequency();
        if (id <= 0) {
            return;
        }
        List<ITeslaTransmitter> list = this.network.get(id);
        if (list == null || !list.contains(transmitter)) {
            this.register(transmitter);
            return;
        }
        Iterator<ITeslaTransmitter> iterator = list.iterator();
        ArrayList<ITeslaTransmitter> remove = new ArrayList<ITeslaTransmitter>();
        while (iterator.hasNext()) {
            ITeslaTransmitter te = iterator.next();
            if (!te.checkAlive() || te.getFrequency() != id) {
                remove.add(te);
                continue;
            }
            double d = transmitter.getSqDistance(te) + te.getSqDistance(transmitter);
            if (d < 1.0) continue;
            transmitter.addEnergy(-te.addEnergy(transmitter.getPower(d, te.getVoltage())));
        }
        if (!remove.isEmpty()) {
            list.removeAll(remove);
        }
    }
}

