/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.circuits;

import cd4017be.api.circuits.IRedstone1bit;
import cd4017be.api.circuits.IRedstone8bit;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class RedstoneHandler {
    public static byte get1bitState(TileEntity te, boolean useRst) {
        if (te == null || !(te instanceof IRedstone1bit)) {
            return 0;
        }
        IRedstone1bit rs = (IRedstone1bit)te;
        byte state = 0;
        for (int i = 0; i < 6; ++i) {
            byte state1;
            if (rs.getBitDirection(i) >= 0) continue;
            BlockPos p = te.func_174877_v().func_177972_a(EnumFacing.field_82609_l[i]);
            TileEntity tile = te.func_145831_w().func_175625_s(p);
            if (tile != null && tile instanceof IRedstone1bit && ((IRedstone1bit)tile).getBitDirection(i ^ 1) > 0 && (state1 = ((IRedstone1bit)tile).getBitValue(i ^ 1)) > state) {
                state = state1;
                continue;
            }
            if (!useRst || (state1 = (byte)te.func_145831_w().func_175651_c(p, EnumFacing.field_82609_l[i])) <= state) continue;
            state = state1;
        }
        return state;
    }

    public static byte get8bitState(TileEntity te) {
        if (te == null || !(te instanceof IRedstone8bit)) {
            return 0;
        }
        IRedstone8bit rs = (IRedstone8bit)te;
        byte state = 0;
        for (int i = 0; i < 6 && state != -1; ++i) {
            if (rs.getDirection(i) >= 0) continue;
            BlockPos p = te.func_174877_v().func_177972_a(EnumFacing.field_82609_l[i]);
            TileEntity tile = te.func_145831_w().func_175625_s(p);
            if (tile == null || !(tile instanceof IRedstone8bit) || ((IRedstone8bit)tile).getDirection(i ^ 1) <= 0) continue;
            state = (byte)(state | ((IRedstone8bit)tile).getValue(i ^ 1));
        }
        return state;
    }

    public static void notify1bitNeighbors(TileEntity te, byte s, int rec, boolean useRst) {
        if (te == null || !(te instanceof IRedstone1bit)) {
            return;
        }
        IRedstone1bit rs = (IRedstone1bit)te;
        for (int i = 0; i < 6; ++i) {
            if (rs.getBitDirection(i) <= 0) continue;
            BlockPos p = te.func_174877_v().func_177972_a(EnumFacing.field_82609_l[i]);
            TileEntity tile = te.func_145831_w().func_175625_s(p);
            if (tile != null && tile instanceof IRedstone1bit && ((IRedstone1bit)tile).getBitDirection(i ^ 1) < 0) {
                ((IRedstone1bit)tile).setBitValue(i ^ 1, s, rec);
                continue;
            }
            if (!useRst) continue;
            te.func_145831_w().func_175695_a(p, te.func_145838_q(), EnumFacing.field_82609_l[i ^ 1]);
            te.func_145831_w().func_175695_a(p, te.func_145838_q(), EnumFacing.field_82609_l[i ^ 1]);
        }
    }

    public static void notify8bitNeighbors(TileEntity te, byte s, int rec) {
        if (te == null || !(te instanceof IRedstone8bit)) {
            return;
        }
        IRedstone8bit rs = (IRedstone8bit)te;
        for (int i = 0; i < 6; ++i) {
            if (rs.getDirection(i) <= 0) continue;
            BlockPos p = te.func_174877_v().func_177972_a(EnumFacing.field_82609_l[i]);
            TileEntity tile = te.func_145831_w().func_175625_s(p);
            if (tile == null || !(tile instanceof IRedstone8bit) || ((IRedstone8bit)tile).getDirection(i ^ 1) >= 0) continue;
            ((IRedstone8bit)tile).setValue(i ^ 1, s, rec);
        }
    }
}

