/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.energy;

import cd4017be.api.energy.EnergyAPI;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class EnergyRedstoneFlux
implements EnergyAPI.IEnergyHandler {
    @Override
    public EnergyAPI.IEnergyAccess create(TileEntity te) {
        return te instanceof IEnergyHandler ? new EnergyTile((IEnergyHandler)te) : null;
    }

    @Override
    public EnergyAPI.IEnergyAccess create(ItemStack item) {
        return item.func_77973_b() instanceof IEnergyContainerItem ? new EnergyItem(item, (IEnergyContainerItem)item.func_77973_b()) : null;
    }

    static class EnergyItem
    implements EnergyAPI.IEnergyAccess {
        final ItemStack item;
        final IEnergyContainerItem energy;

        EnergyItem(ItemStack item, IEnergyContainerItem energy) {
            this.item = item;
            this.energy = energy;
        }

        @Override
        public double getStorage(int s) {
            return (double)this.energy.getEnergyStored(this.item) * EnergyAPI.RF_value;
        }

        @Override
        public double getCapacity(int s) {
            return (double)this.energy.getMaxEnergyStored(this.item) * EnergyAPI.RF_value;
        }

        @Override
        public double addEnergy(double e, int s) {
            if (e >= EnergyAPI.RF_value) {
                return (double)this.energy.receiveEnergy(this.item, (int)Math.floor(e / EnergyAPI.RF_value), false) * EnergyAPI.RF_value;
            }
            if (e <= -EnergyAPI.RF_value && this.energy instanceof IEnergyProvider) {
                return (double)this.energy.extractEnergy(this.item, (int)Math.floor(e / -EnergyAPI.RF_value), false) * -EnergyAPI.RF_value;
            }
            return 0.0;
        }
    }

    static class EnergyTile
    implements EnergyAPI.IEnergyAccess {
        final IEnergyHandler energy;

        EnergyTile(IEnergyHandler tile) {
            this.energy = tile;
        }

        @Override
        public double getStorage(int s) {
            return (double)this.energy.getEnergyStored(s < 0 || s >= 6 ? null : EnumFacing.field_82609_l[s]) * EnergyAPI.RF_value;
        }

        @Override
        public double getCapacity(int s) {
            return (double)this.energy.getMaxEnergyStored(s < 0 || s >= 6 ? null : EnumFacing.field_82609_l[s]) * EnergyAPI.RF_value;
        }

        @Override
        public double addEnergy(double e, int s) {
            if (e >= EnergyAPI.RF_value && this.energy instanceof IEnergyReceiver) {
                return (double)((IEnergyReceiver)this.energy).receiveEnergy(s < 0 || s >= 6 ? null : EnumFacing.field_82609_l[s], (int)Math.floor(e / EnergyAPI.RF_value), false) * EnergyAPI.RF_value;
            }
            if (e <= -EnergyAPI.RF_value && this.energy instanceof IEnergyProvider) {
                return (double)((IEnergyProvider)this.energy).extractEnergy(s < 0 || s >= 6 ? null : EnumFacing.field_82609_l[s], (int)Math.floor(e / -EnergyAPI.RF_value), false) * -EnergyAPI.RF_value;
            }
            return 0.0;
        }
    }
}

