/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes;

import cd4017be.api.recipes.RecipeAPI;
import cd4017be.lib.util.VecN;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class OreGenHandler
implements RecipeAPI.IRecipeHandler,
IWorldGenerator {
    ArrayList<OreGen> generators = new ArrayList();

    public OreGenHandler() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)0);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        for (OreGen gen : this.generators) {
            gen.func_180709_b(world, random, new BlockPos(chunkX << 4, 0, chunkZ << 4));
        }
    }

    @Override
    public boolean addRecipe(Object ... param) {
        if (!(param.length >= 5 && param[1] instanceof String && param[2] instanceof ItemStack && param[3] instanceof Double && param[4] instanceof VecN)) {
            return false;
        }
        ItemStack is = (ItemStack)param[2];
        Item i = is.func_77973_b();
        VecN vec = (VecN)param[4];
        if (!(i instanceof ItemBlock) || vec.x.length < 3) {
            return false;
        }
        IBlockState out = ((ItemBlock)i).field_150939_a.func_176203_a(i.func_77647_b(is.func_77960_j()));
        Block in = Block.func_149684_b((String)((String)param[1]));
        if (in == null) {
            in = Blocks.field_150348_b;
        }
        this.generators.add(new OreGen(out, is.field_77994_a, ((Double)param[3]).intValue(), (int)vec.x[0], (int)vec.x[1], (int)vec.x[2], (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)in)));
        return true;
    }

    class OreGen
    extends WorldGenMinable {
        final int numV;
        final int hgt;
        final float min;
        final float max;

        public OreGen(IBlockState state, int numB, int numV, int minH, int mainH, int maxH, Predicate<IBlockState> target) {
            super(state, numB, target);
            this.numV = numV;
            this.min = mainH - minH;
            this.max = maxH - mainH;
            this.hgt = mainH;
        }

        public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
            boolean side = this.max < this.min;
            for (int i = 0; i < this.numV; ++i) {
                int r = rand.nextInt();
                float f = (float)((r & 0xFFF) + (r >> 12 & 0xFFF) - 4095) / 4095.0f;
                if (side) {
                    if ((f *= this.min) > this.max) {
                        f = this.max - (f - this.max) / (this.min - this.max) * (this.min + this.max);
                    }
                } else {
                    if ((f *= this.max) > this.min) {
                        f = this.min - (f - this.min) / (this.max - this.min) * (this.max + this.min);
                    }
                    f = -f;
                }
                super.func_180709_b(worldIn, rand, position.func_177982_a(r >> 24 & 0xF, (int)Math.floor(f) + this.hgt, r >> 28 & 0xF));
            }
            return true;
        }
    }
}

