/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes;

import cd4017be.api.recipes.AutomationRecipes;
import cd4017be.api.recipes.OreGenHandler;
import cd4017be.api.recipes.RecipeScriptParser;
import cd4017be.lib.ConfigurationFile;
import cd4017be.lib.NBTRecipe;
import cd4017be.lib.util.ScriptCompiler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Level;

public class RecipeAPI {
    private static final String[] phases = new String[]{"@PRE_INIT", "@INIT", "@POST_INIT"};
    public static final int PRE_INIT = 0;
    public static final int INIT = 1;
    public static final int POST_INIT = 2;
    public static HashMap<String, IRecipeHandler> Handlers;
    public static HashMap<String, CachedScript> cache;

    public static void loadRecipes(String fileName, int ph) {
        try {
            CachedScript scr = cache.get(fileName);
            if (scr == null && ph == 0) {
                scr = new CachedScript(fileName);
                cache.put(fileName, scr);
            }
            if (scr != null && scr.methods[ph] != null) {
                scr.state.run(scr.methods[ph], 16);
            }
        }
        catch (Exception e) {
            FMLLog.log((String)"RECIPE_SCRIPT", (Level)Level.ERROR, (Throwable)e, (String)"loading failed for %s", (Object[])new Object[]{fileName});
        }
        if (ph >= phases.length - 1) {
            cache.remove(fileName);
            RecipeScriptParser.codeCache.clear();
        }
    }

    static {
        cache = new HashMap();
        Handlers = new HashMap();
        Handlers.put("shapeless", new ShapelessCraftingHandler());
        Handlers.put("shaped", new ShapedCraftingHandler());
        Handlers.put("shapedNBT", new NBTCraftingHandler());
        Handlers.put("ore", new OreDictionaryHandler());
        Handlers.put("smelt", new SmeltingHandler());
        Handlers.put("fuel", new FuelHandler());
        Handlers.put("worldgen", new OreGenHandler());
        if (Loader.isModLoaded((String)"Automation")) {
            Handlers.put("compAs", new MechanicAssemblerHandler());
            Handlers.put("advFurn", new ThermalAssemblerHandler());
            Handlers.put("electr", new ElectrolyserHandler());
            Handlers.put("cool", new DecompCoolHandler());
            Handlers.put("trash", new GravitationalCondHandler());
            Handlers.put("heatRad", new HeatRadiatorHandler());
        }
    }

    static class HeatRadiatorHandler
    implements IRecipeHandler {
        HeatRadiatorHandler() {
        }

        @Override
        public boolean addRecipe(Object ... param) {
            if (param.length < 3 || !(param[1] instanceof FluidStack) || !(param[2] instanceof FluidStack)) {
                return false;
            }
            AutomationRecipes.addRadiatorRecipe((FluidStack)param[1], (FluidStack)param[2]);
            return true;
        }
    }

    static class GravitationalCondHandler
    implements IRecipeHandler {
        GravitationalCondHandler() {
        }

        @Override
        public boolean addRecipe(Object ... param) {
            if (!(param.length >= 4 && param[1] instanceof ItemStack && param[2] instanceof ItemStack && param[3] instanceof Double)) {
                return false;
            }
            AutomationRecipes.addRecipe(new AutomationRecipes.GCRecipe((ItemStack)param[1], (ItemStack)param[2], ((Double)param[3]).intValue()));
            return true;
        }
    }

    static class DecompCoolHandler
    implements IRecipeHandler {
        DecompCoolHandler() {
        }

        @Override
        public boolean addRecipe(Object ... param) {
            if (param.length < 6 || !(param[5] instanceof Double)) {
                return false;
            }
            AutomationRecipes.addRecipe(new AutomationRecipes.CoolRecipe(param[1], param[2], param[3], param[4], ((Double)param[5]).floatValue()));
            return true;
        }
    }

    static class ElectrolyserHandler
    implements IRecipeHandler {
        ElectrolyserHandler() {
        }

        @Override
        public boolean addRecipe(Object ... param) {
            if (param.length < 5 || !(param[4] instanceof Double)) {
                return false;
            }
            AutomationRecipes.addRecipe(new AutomationRecipes.ElRecipe(param[1], param[2], param[3], ((Double)param[4]).floatValue()));
            return true;
        }
    }

    static class ThermalAssemblerHandler
    implements IRecipeHandler {
        ThermalAssemblerHandler() {
        }

        @Override
        public boolean addRecipe(Object ... param) {
            if (!(param.length >= 4 && param[1] instanceof Object[] && param[2] instanceof Object[] && param[3] instanceof Double)) {
                return false;
            }
            FluidStack Fin = null;
            FluidStack Fout = null;
            ArrayList<Object> Iin = new ArrayList<Object>();
            ArrayList<ItemStack> Iout = new ArrayList<ItemStack>();
            for (Object o : (Object[])param[1]) {
                if (o instanceof FluidStack) {
                    Fin = (FluidStack)o;
                    continue;
                }
                Iin.add(o);
            }
            for (Object o : (Object[])param[2]) {
                if (o instanceof FluidStack) {
                    Fout = (FluidStack)o;
                    continue;
                }
                if (o instanceof ItemStack) {
                    Iout.add((ItemStack)o);
                    continue;
                }
                return false;
            }
            AutomationRecipes.addRecipe(new AutomationRecipes.LFRecipe(Fin, Iin.isEmpty() ? null : Iin.toArray(new Object[Iin.size()]), Fout, Iout.isEmpty() ? null : Iout.toArray(new ItemStack[Iout.size()]), ((Double)param[3]).floatValue()));
            return true;
        }
    }

    static class MechanicAssemblerHandler
    implements IRecipeHandler {
        MechanicAssemblerHandler() {
        }

        @Override
        public boolean addRecipe(Object ... param) {
            if (param.length < 3 || param.length > 6 || !(param[1] instanceof ItemStack)) {
                return false;
            }
            AutomationRecipes.addCmpRecipe((ItemStack)param[1], Arrays.copyOfRange(param, 2, param.length));
            return true;
        }
    }

    static class FuelHandler
    implements IRecipeHandler,
    IFuelHandler {
        HashMap<Integer, Integer> fuelList = new HashMap();

        public FuelHandler() {
            GameRegistry.registerFuelHandler((IFuelHandler)this);
        }

        int key(ItemStack item) {
            return Item.func_150891_b((Item)item.func_77973_b()) & 0xFFFF | (item.func_77952_i() & 0xFFFF) << 16;
        }

        @Override
        public boolean addRecipe(Object ... param) {
            if (param.length != 3 || !(param[1] instanceof ItemStack) || !(param[2] instanceof Double)) {
                return false;
            }
            this.fuelList.put(this.key((ItemStack)param[1]), ((Double)param[2]).intValue());
            return true;
        }

        public int getBurnTime(ItemStack fuel) {
            Integer val = this.fuelList.get(this.key(fuel));
            return val == null ? 0 : val;
        }
    }

    static class SmeltingHandler
    implements IRecipeHandler {
        SmeltingHandler() {
        }

        @Override
        public boolean addRecipe(Object ... param) {
            float xp;
            if (param.length < 3 || !(param[1] instanceof ItemStack) || !(param[2] instanceof ItemStack)) {
                return false;
            }
            if (param.length < 4) {
                xp = 0.0f;
            } else if (param[3] instanceof Double) {
                xp = ((Double)param[3]).floatValue();
            } else {
                return false;
            }
            GameRegistry.addSmelting((ItemStack)((ItemStack)param[1]), (ItemStack)((ItemStack)param[2]), (float)xp);
            return true;
        }
    }

    static class OreDictionaryHandler
    implements IRecipeHandler {
        OreDictionaryHandler() {
        }

        @Override
        public boolean addRecipe(Object ... param) {
            if (param.length < 3 || !(param[1] instanceof String)) {
                return false;
            }
            for (int i = 2; i < param.length; ++i) {
                if (!(param[i] instanceof ItemStack)) {
                    return false;
                }
                OreDictionary.registerOre((String)((String)param[1]), (ItemStack)((ItemStack)param[i]));
            }
            return true;
        }
    }

    static class NBTCraftingHandler
    implements IRecipeHandler {
        NBTCraftingHandler() {
        }

        @Override
        public boolean addRecipe(Object ... param) {
            int i;
            if (!(param.length >= 5 && param[1] instanceof String && param[2] instanceof ItemStack && param[3] instanceof String)) {
                return false;
            }
            String[] pattern = ((String)param[3]).split("/");
            int n = param.length - 4;
            Object[] arr = new Object[n * 2 + pattern.length];
            for (i = 0; i < pattern.length; ++i) {
                arr[i] = pattern[i];
            }
            for (i = 0; i < n; ++i) {
                arr[pattern.length + i * 2] = Character.valueOf(Character.forDigit(i, 9));
                arr[pattern.length + i * 2 + 1] = param[i + 4];
            }
            GameRegistry.addRecipe((IRecipe)new NBTRecipe((ItemStack)param[2], (String)param[1], arr));
            return true;
        }
    }

    static class ShapedCraftingHandler
    implements IRecipeHandler {
        ShapedCraftingHandler() {
        }

        @Override
        public boolean addRecipe(Object ... param) {
            int i;
            if (param.length < 4 || !(param[1] instanceof ItemStack) || !(param[2] instanceof String)) {
                return false;
            }
            String[] pattern = ((String)param[2]).split("/");
            int n = param.length - 3;
            Object[] arr = new Object[n * 2 + pattern.length];
            for (i = 0; i < pattern.length; ++i) {
                arr[i] = pattern[i];
            }
            for (i = 0; i < n; ++i) {
                arr[pattern.length + i * 2] = Character.valueOf(Character.forDigit(i, 9));
                arr[pattern.length + i * 2 + 1] = param[i + 3];
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((ItemStack)param[1], arr));
            return true;
        }
    }

    static class ShapelessCraftingHandler
    implements IRecipeHandler {
        ShapelessCraftingHandler() {
        }

        @Override
        public boolean addRecipe(Object ... param) {
            if (param.length < 3 || !(param[1] instanceof ItemStack)) {
                return false;
            }
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe((ItemStack)param[1], Arrays.copyOfRange(param, 2, param.length)));
            return true;
        }
    }

    public static interface IRecipeHandler {
        public boolean addRecipe(Object ... var1);
    }

    static class CachedScript {
        RecipeScriptParser state;
        ScriptCompiler.SubMethod[] methods;

        public CachedScript(String file) throws IOException {
            String code = ConfigurationFile.readTextFile(ConfigurationFile.getStream(file));
            int[] idx = new int[phases.length + 1];
            idx[phases.length] = code.length();
            this.methods = new ScriptCompiler.SubMethod[phases.length];
            for (int i = idx.length - 2; i >= 0; --i) {
                idx[i] = code.lastIndexOf(phases[i], idx[i + 1]);
                if (idx[i] < 0) {
                    idx[i] = idx[i + 1];
                    continue;
                }
                this.methods[i] = new ScriptCompiler.SubMethod(code.substring(idx[i] + phases[i].length(), idx[i + 1]), new ResourceLocation(file.replace(".rcp", i + ".rcp")));
            }
            this.state = new RecipeScriptParser(new HashMap<String, Object>());
        }
    }
}

