/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes;

import cd4017be.api.recipes.RecipeAPI;
import cd4017be.lib.BlockItemRegistry;
import cd4017be.lib.ConfigurationFile;
import cd4017be.lib.util.OreDictStack;
import cd4017be.lib.util.ScriptCompiler;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class RecipeScriptParser
extends ScriptCompiler {
    public static HashMap<ResourceLocation, String> codeCache = new HashMap();
    private static final String[] functions = new String[]{"it", "fl", "ore", "hasit", "hasfl", "nore"};
    private static final String[] methods = new String[]{"add"};

    public RecipeScriptParser(HashMap<String, Object> vars) {
        super(vars);
    }

    @Override
    protected String[] methods() {
        return methods;
    }

    @Override
    protected String[] functions() {
        return functions;
    }

    @Override
    protected void runMethod(int i, Object[] param, int line) {
        RecipeAPI.IRecipeHandler h = RecipeAPI.Handlers.get(param[0]);
        if (h == null) {
            FMLLog.log((String)"cd4017be_lib", (Level)Level.WARN, (String)"recipe Handler \"%s\" does'nt exist!", (Object[])new Object[]{param[0]});
        }
        if (!h.addRecipe(param)) {
            FMLLog.log((String)"cd4017be_lib", (Level)Level.WARN, (String)"adding recipe failed: \n%s", (Object[])param);
        }
    }

    @Override
    protected Object runFunction(int i, Object[] param, int line) throws ScriptCompiler.CompileException {
        switch (i) {
            case 0: {
                ItemStack item = null;
                if (param[0] instanceof String) {
                    String name = (String)param[0];
                    if (name.indexOf(58) < 0) {
                        item = BlockItemRegistry.stack(name, 1);
                    } else {
                        if (name.startsWith("ore:")) {
                            List list = OreDictionary.getOres((String)(name = name.substring(4)));
                            if (list.isEmpty()) {
                                throw new ScriptCompiler.CompileException("empty OreDictionary type:", name, line);
                            }
                            return list.get(0);
                        }
                        item = new ItemStack(Item.func_111206_d((String)name));
                    }
                    if (item == null || item.func_77973_b() == null) {
                        throw new ScriptCompiler.CompileException("invalid item name:", name, line);
                    }
                } else if (param[0] instanceof ItemStack) {
                    item = ((ItemStack)param[0]).func_77946_l();
                } else if (param[0] instanceof OreDictStack) {
                    ItemStack[] arr = ((OreDictStack)param[0]).getItems();
                    return Arrays.copyOf(arr, arr.length, Object[].class);
                }
                int n = 1;
                if (param.length > n && param[n] instanceof Double) {
                    item.field_77994_a = ((Double)param[n++]).intValue();
                }
                if (param.length > n && param[n] instanceof Double) {
                    item.func_77964_b(((Double)param[n++]).intValue());
                }
                if (param.length > n && param[n] instanceof NBTTagCompound) {
                    item.func_77982_d((NBTTagCompound)param[n++]);
                }
                return item;
            }
            case 1: {
                int n;
                FluidStack fluid = null;
                if (param[0] instanceof String) {
                    String name = (String)param[0];
                    fluid = FluidRegistry.getFluidStack((String)name, (int)0);
                    if (fluid == null) {
                        throw new ScriptCompiler.CompileException("invalid fluid name:", name, line);
                    }
                } else if (param[0] instanceof FluidStack) {
                    fluid = ((FluidStack)param[0]).copy();
                }
                if (param.length > (n = 1) && param[n] instanceof Double) {
                    fluid.amount = ((Double)param[n++]).intValue();
                }
                if (param.length > n && param[n] instanceof NBTTagCompound) {
                    fluid.tag = (NBTTagCompound)param[n++];
                }
                return fluid;
            }
            case 2: {
                OreDictStack ore = null;
                if (param[0] instanceof String) {
                    String name = (String)param[0];
                    ore = new OreDictStack(name, 1);
                } else if (param[0] instanceof OreDictStack) {
                    ore = ((OreDictStack)param[0]).copy();
                }
                if (param.length > 1 && param[1] instanceof Double) {
                    ore.stacksize = ((Double)param[1]).intValue();
                }
                return ore;
            }
            case 3: {
                for (Object o : param) {
                    String name = (String)o;
                    if (!(name.indexOf(58) < 0 ? BlockItemRegistry.stack(name, 1) == null : (name.startsWith("ore:") ? OreDictionary.getOres((String)name.substring(4)).isEmpty() : Item.func_111206_d((String)name) == null))) continue;
                    return 0.0;
                }
                return 1.0;
            }
            case 4: {
                for (Object o : param) {
                    if (FluidRegistry.isFluidRegistered((String)((String)o))) continue;
                    return 0.0;
                }
                return 1.0;
            }
            case 5: {
                if (param[0] instanceof String) {
                    return (double)OreDictionary.getOres((String)((String)param[0])).size();
                }
                return 0.0;
            }
        }
        return null;
    }

    @Override
    protected Object indexArray(Object array, String index, int recLimit, int line) throws ScriptCompiler.CompileException {
        return null;
    }

    @Override
    public ScriptCompiler extScript(HashMap<String, Object> var, String filename, int recLimit) throws ScriptCompiler.CompileException {
        ResourceLocation res = new ResourceLocation(filename);
        String code = codeCache.get(res);
        if (code == null) {
            try {
                code = ConfigurationFile.readTextFile(ConfigurationFile.getStream(filename));
            }
            catch (IOException e) {
                throw ScriptCompiler.CompileException.of(e, filename, 0);
            }
        }
        ScriptCompiler.SubMethod method = new ScriptCompiler.SubMethod(code, res);
        RecipeScriptParser script = new RecipeScriptParser(var);
        script.run(method, recLimit);
        return script;
    }
}

