/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.lib.render.SingleTextureDefinition;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockItemRegistry {
    public static HashMap<String, Short> blockItemIdMap = new HashMap();
    private static HashMap<String, Item> items = new HashMap();
    private static HashMap<String, Block> blocks = new HashMap();
    private static HashMap<String, ItemStack> stacks = new HashMap();
    public static String currentMod = "";

    public static void setMod(String name) {
        currentMod = name;
    }

    public static String texPath() {
        return currentMod.concat(":");
    }

    public static void registerBlock(Block block, String id, Class<? extends ItemBlock> item, Object ... par) {
        blocks.put(id, block);
        GameRegistry.registerBlock((Block)block, item, (String)id, (Object[])par);
        if (item != null && item.equals(ItemBlock.class)) {
            BlockItemRegistry.registerItemStack(new ItemStack(block), block.func_149739_a());
        }
    }

    public static void registerItem(Item item, String id) {
        items.put(id, item);
        GameRegistry.registerItem((Item)item, (String)id);
        if (!item.func_77614_k()) {
            BlockItemRegistry.registerItemStack(new ItemStack(item), item.func_77658_a());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemRender(String id) {
        int m;
        int p = id.indexOf(58);
        if (p <= 0) {
            BlockItemRegistry.registerItemRender(BlockItemRegistry.getItem(id), new SingleTextureDefinition(BlockItemRegistry.texPath() + id));
            return;
        }
        try {
            m = Integer.parseInt(id.substring(p + 1));
        }
        catch (NumberFormatException e) {
            m = 0;
        }
        id = id.substring(0, p);
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(BlockItemRegistry.getItem(id), m, new ModelResourceLocation(BlockItemRegistry.texPath() + id, "inventory" + (m != 0 ? "_" + m : "")));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemRender(Item item, ItemMeshDefinition def) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178080_a(item, def);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockRender(String id) {
        int m;
        int p = id.indexOf(58);
        if (p <= 0) {
            BlockItemRegistry.registerBlockRender(id, new SingleTextureDefinition(BlockItemRegistry.texPath() + id));
            return;
        }
        try {
            m = Integer.parseInt(id.substring(p + 1));
        }
        catch (NumberFormatException e) {
            m = 0;
        }
        id = id.substring(0, p);
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)BlockItemRegistry.getBlock(id)), m, new ModelResourceLocation(BlockItemRegistry.texPath() + id + (m != 0 ? "_" + m : ""), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockRender(String id, ItemMeshDefinition def) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178080_a(Item.func_150898_a((Block)BlockItemRegistry.getBlock(id)), def);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels(String id, String ... models) {
        Item item = BlockItemRegistry.itemId(id);
        if (item == null) {
            item = Item.func_150898_a((Block)BlockItemRegistry.blockId(id));
        }
        BlockItemRegistry.registerModels(item, models);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels(Block block, String ... models) {
        BlockItemRegistry.registerModels(Item.func_150898_a((Block)block), models);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels(Item item, String ... models) {
        ResourceLocation[] locs = new ResourceLocation[models.length];
        for (int i = 0; i < locs.length; ++i) {
            locs[i] = new ResourceLocation(currentMod, models[i]);
        }
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])locs);
    }

    public static void registerItemStack(ItemStack item, String name) {
        stacks.put(name, item);
    }

    public static void registerMetadataItemStacks(ItemStack startItem, String ... names) {
        int s = startItem.func_77952_i();
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null) continue;
            ItemStack item = startItem.func_77946_l();
            item.func_77964_b(s + i);
            stacks.put(names[i], item);
        }
    }

    public static Block getBlock(String name) {
        return blocks.get(name);
    }

    public static Item getItem(String name) {
        return items.get(name);
    }

    public static Block blockId(String name) {
        return blocks.get(name);
    }

    public static Item itemId(String name) {
        return items.get(name);
    }

    public static ItemStack stack(String name, int n) {
        ItemStack item = stacks.get(name);
        if (item == null) {
            return null;
        }
        ItemStack ret = item.func_77946_l();
        ret.field_77994_a = n;
        return ret;
    }

    public static ItemStack stack(String name, int n, int m) {
        ItemStack item = stacks.get(name);
        if (item == null) {
            return null;
        }
        ItemStack ret = item.func_77946_l();
        ret.field_77994_a = n;
        ret.func_77964_b(m);
        return ret;
    }
}

