/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.lib.DefaultBlock;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.TileBlockRegistry;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileBlock
extends DefaultBlock
implements ITileEntityProvider {
    public static final Orientation[] Orientations = new Orientation[4];
    protected static int tmpType;
    protected AxisAlignedBB boundingBox;
    public int machineId;
    public boolean registered;
    public final Orientation orient;
    private boolean redstone;
    private boolean opaque;
    private EnumBlockRenderType renderType;
    private boolean drop;
    private BlockRenderLayer blockLayer = BlockRenderLayer.SOLID;

    public static TileBlock create(String id, Material m, SoundType sound, Class<? extends ItemBlock> item, int type) {
        tmpType = (type & 0xF) % Orientations.length;
        TileBlock block = new TileBlock(id, m, sound, item, type);
        tmpType = 0;
        return block;
    }

    protected TileBlock(String id, Material m, SoundType sound, Class<? extends ItemBlock> item, int type) {
        super(id, m, item);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149672_a(sound);
        this.orient = Orientations[tmpType];
        this.redstone = (type & 0x10) != 0;
        this.opaque = (type & 0x20) == 0;
        this.drop = (type & 0x40) == 0;
        this.field_149787_q = (type & 0x80) == 0;
        this.renderType = EnumBlockRenderType.MODEL;
        this.boundingBox = field_185505_j;
        if (this.orient != null) {
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)this.orient.values.get(0)));
        }
    }

    public IBlockState func_176203_a(int meta) {
        if (this.orient != null && this.orient.inRange(meta)) {
            return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)Integer.valueOf(meta));
        }
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return this.orient != null ? (Integer)state.func_177229_b((IProperty)this.orient) : 0;
    }

    protected void addProperties(ArrayList<IProperty> main) {
        if (tmpType > 0) {
            main.add(Orientations[tmpType]);
        }
    }

    protected BlockStateContainer func_180661_e() {
        ArrayList<IProperty> main = new ArrayList<IProperty>();
        this.addProperties(main);
        return new BlockStateContainer((Block)this, main.toArray(new IProperty[main.size()]));
    }

    public TileEntity func_149915_a(World world, int id) {
        TileBlockRegistry.TileBlockEntry entry = TileBlockRegistry.getBlockEntry(this);
        if (entry != null && entry.tileEntity != null) {
            try {
                return entry.tileEntity.newInstance();
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing s, float X, float Y, float Z) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            return ((ModTileEntity)te).onActivated(player, hand, item, s, X, Y, Z);
        }
        return false;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            ((ModTileEntity)te).onClicked(player);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block b) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            ((ModTileEntity)te).onNeighborBlockChange(b);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            ((ModTileEntity)te).breakBlock();
        }
        super.func_180663_b(world, pos, state);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos npos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            ((ModTileEntity)te).onNeighborTileChange(npos);
        }
    }

    public boolean func_149744_f(IBlockState state) {
        return this.redstone;
    }

    public boolean func_149721_r(IBlockState state) {
        return this.boundingBox == field_185505_j;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.boundingBox == field_185505_j;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (this.boundingBox == field_185505_j) {
            return true;
        }
        switch (side) {
            case DOWN: {
                return this.boundingBox.field_72338_b == TileBlock.field_185505_j.field_72338_b;
            }
            case UP: {
                return this.boundingBox.field_72337_e == TileBlock.field_185505_j.field_72337_e;
            }
            case NORTH: {
                return this.boundingBox.field_72339_c == TileBlock.field_185505_j.field_72339_c;
            }
            case SOUTH: {
                return this.boundingBox.field_72334_f == TileBlock.field_185505_j.field_72334_f;
            }
            case WEST: {
                return this.boundingBox.field_72340_a == TileBlock.field_185505_j.field_72340_a;
            }
            case EAST: {
                return this.boundingBox.field_72336_d == TileBlock.field_185505_j.field_72336_d;
            }
        }
        return true;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing s, float X, float Y, float Z, int m, EntityLivingBase placer) {
        int h;
        if (this.orient == null) {
            return this.func_176203_a(m);
        }
        if (placer.func_70093_af()) {
            if (this.orient.type == 0 && (s == EnumFacing.DOWN || s == EnumFacing.UP)) {
                return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)Integer.valueOf(Z + X > 1.0f ? (Z > X ? 5 : 7) : (Z < X ? 4 : 6)));
            }
            if (this.orient.type >= 2 && s == EnumFacing.DOWN) {
                return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)Integer.valueOf(Z + X > 1.0f ? (Z > X ? 1 : 3) : (Z < X ? 0 : 2)));
            }
            if (this.orient.type >= 2 && s == EnumFacing.UP) {
                return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)Integer.valueOf(Z + X > 1.0f ? (Z > X ? 9 : 11) : (Z < X ? 8 : 10)));
            }
            return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)Integer.valueOf((s.func_176745_a() ^ 1) + 2));
        }
        int n = placer.field_70125_A > 40.0f ? 1 : (h = placer.field_70125_A < -35.0f ? -1 : 0);
        if (this.orient.type == 1 && h != 0) {
            return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)Integer.valueOf(h < 0 ? 2 : 3));
        }
        int d = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (d > 0) {
            d = (d + 1) % 3 + 1;
        }
        if (this.orient.type < 2 || h == 0) {
            return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)Integer.valueOf(4 + d));
        }
        if (h < 0) {
            return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)Integer.valueOf(d));
        }
        return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)Integer.valueOf(8 + d));
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing s) {
        if (!this.redstone) {
            return 0;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            return ((ModTileEntity)te).redstoneLevel(s.func_176745_a() ^ 1, false);
        }
        return 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing s) {
        if (!this.redstone) {
            return 0;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            return ((ModTileEntity)te).redstoneLevel(s.func_176745_a() ^ 1, true);
        }
        return 0;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack item) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            ((ModTileEntity)te).onPlaced(entity, item);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            ((ModTileEntity)te).onEntityCollided(entity);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return this.opaque;
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public void setRenderType(EnumBlockRenderType t) {
        this.renderType = t;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return this.renderType;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        if (this.drop) {
            super.func_180657_a(world, player, pos, state, te, stack);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!this.drop) {
            super.func_180657_a(world, player, pos, state, null, player.func_184614_ca());
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (this.drop) {
            return super.getDrops(world, pos, state, fortune);
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            return ((ModTileEntity)te).dropItem(state, fortune);
        }
        return super.getDrops(world, pos, state, fortune);
    }

    public void setBlockLayer(BlockRenderLayer layer) {
        this.blockLayer = layer;
    }

    public BlockRenderLayer func_180664_k() {
        return this.blockLayer;
    }

    public TileBlock setBlockBounds(AxisAlignedBB box) {
        this.boundingBox = box;
        return this;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.boundingBox;
    }

    static {
        for (byte i = 0; i < Orientations.length - 1; i = (byte)(i + 1)) {
            TileBlock.Orientations[i + 1] = new Orientation(i);
        }
    }

    public static class Orientation
    implements IProperty<Integer> {
        public static final String[] namesAll = new String[]{"bn", "bs", "bw", "be", "n", "s", "w", "e", "tn", "ts", "tw", "te"};
        public static final String[] namesHor = new String[]{"--", "--", "--", "--", "n", "s", "w", "e", "--", "--", "--", "--"};
        public static final String[] namesVert = new String[]{"--", "--", "b", "t", "n", "s", "w", "e", "--", "--", "--", "--"};
        public final byte type;
        public final ArrayList<Integer> values;

        private Orientation(byte type) {
            int i;
            this.type = type;
            int j = type == 0 || type == 1 ? 8 : 12;
            this.values = new ArrayList(j - i);
            for (i = type == 0 ? 4 : (type == 1 ? 2 : 0); i < j; ++i) {
                this.values.add(i);
            }
        }

        public String func_177701_a() {
            return "orient";
        }

        public Collection<Integer> func_177700_c() {
            return this.values;
        }

        public Class<Integer> func_177699_b() {
            return Integer.class;
        }

        public String getName(Integer v) {
            return this.type == 0 ? namesHor[v] : (this.type == 1 ? namesVert[v] : namesAll[v]);
        }

        public boolean inRange(Integer i) {
            return this.type == 0 ? i >= 4 && i < 8 : (this.type == 1 ? i >= 2 && i < 8 : i >= 0 && i < 8);
        }

        public Optional<Integer> func_185929_b(String value) {
            String[] array = this.type == 0 ? namesHor : (this.type == 1 ? namesVert : namesAll);
            for (int i = 0; i < array.length; ++i) {
                if (!array[i].equals(value)) continue;
                return Optional.of((Object)i);
            }
            return Optional.absent();
        }
    }
}

