/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.templates;

import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.TileContainer;
import cd4017be.lib.TooltipInfo;
import cd4017be.lib.templates.AutomatedTile;
import cd4017be.lib.templates.SlotHolo;
import cd4017be.lib.templates.TankContainer;
import cd4017be.lib.util.Utils;
import cd4017be.lib.util.Vec3;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public abstract class GuiMachine
extends GuiContainer {
    protected final AutomatedTile tile;
    protected int mouseX;
    protected int mouseY;
    protected int selTank = -1;
    protected int tabsY = 7;
    protected int EtabX = 0;
    protected int FtabX = 0;
    protected int ItabX = 0;
    protected int tabsX = 0;
    private Slot lastClickSlot;

    public GuiMachine(Container container) {
        super(container);
        this.tile = this.field_147002_h instanceof TileContainer && ((TileContainer)this.field_147002_h).tileEntity instanceof AutomatedTile ? (AutomatedTile)((TileContainer)this.field_147002_h).tileEntity : null;
    }

    public void func_73863_a(int mx, int my, float par3) {
        this.mouseX = mx;
        this.mouseY = my;
        super.func_73863_a(mx, my, par3);
    }

    public int GuiLeft() {
        return this.field_147003_i;
    }

    public int GuiTop() {
        return this.field_147009_r;
    }

    public void drawStringCentered(String s, int x, int y, int c) {
        this.field_146289_q.func_78276_b(s, x - this.field_146289_q.func_78256_a(s) / 2, y, c);
    }

    public void drawLocString(int x, int y, int h, int c, String s, Object ... args) {
        String[] text;
        for (String l : text = TooltipInfo.format("gui.cd4017be." + s, args).split("\n")) {
            this.field_146289_q.func_78276_b(l, x, y, c);
            y += h;
        }
    }

    protected void func_146979_b(int mx, int my) {
        if (this.selTank >= 0) {
            this.drawTankInfo(this.selTank, mx - this.field_147003_i, my - this.field_147009_r);
        }
        this.selTank = -1;
        if (this.tile != null && this.func_146978_c(this.tabsX, this.tabsY, 0 - this.tabsX, 81, mx, my)) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179097_i();
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            int s = (my - this.field_147009_r - this.tabsY - 9) / 9;
            if (s < 0 || (mx -= this.field_147003_i) >= 0) {
                return;
            }
            this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("lib", "textures/icons.png"));
            int dir = 0;
            if (this.FtabX <= mx) {
                int id = mx - this.FtabX - 9;
                if (id >= 0) {
                    dir = s < 6 ? (int)this.tile.tanks.getConfig(s, id) : (s != 6 ? 4 : (this.tile.tanks.isLocked(id /= 9) ? 5 : 6));
                    for (TileContainer.TankSlot slot : ((TileContainer)this.field_147002_h).tankSlots) {
                        if (slot.tankNumber != id) continue;
                        this.func_73729_b(slot.xDisplayPosition + (slot.bigSize ? 9 : 0), slot.yDisplayPosition + (s < 6 ? 44 : 36), 144 + dir * 16, 16, 16, s < 6 ? 8 : 16);
                    }
                }
            } else if (s < 6 && this.ItabX <= mx) {
                int id = mx - this.ItabX - 9;
                if (id >= 0) {
                    dir = this.tile.inventory.getConfig(this.tile.netData.longs[this.tile.inventory.netIdxLong], s, id /= 9);
                    int i0 = this.tile.inventory.componets[id].s;
                    int i1 = this.tile.inventory.componets[id].e;
                    for (Slot slot : this.field_147002_h.field_75151_b) {
                        if (slot.field_75224_c != this.tile || slot.getSlotIndex() < i0 || slot.getSlotIndex() >= i1) continue;
                        this.func_73729_b(slot.field_75223_e, slot.field_75221_f, 144 + dir * 16, 0, 16, 16);
                    }
                }
            } else if (s < 6 && this.EtabX + 9 <= mx) {
                dir = (byte)(~this.tile.energy.con >> s & 1);
            }
            if (s < 6) {
                this.drawSideCube(-64, this.tabsY + 63, s, (byte)dir);
            }
        }
    }

    protected void drawSideCube(int x, int y, int s, byte dir) {
        Vec3 a;
        GlStateManager.func_179126_j();
        this.func_73733_a(x, y, x + 64, y + 64, -16777216, -16777216);
        this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(x + 32), (float)(y + 32), (float)(this.field_73735_i + 32.0f));
        GL11.glScalef((float)16.0f, (float)-16.0f, (float)16.0f);
        EntityPlayer player = ((TileContainer)this.field_147002_h).player;
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(player.field_70177_z + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.5f);
        this.field_146297_k.func_175602_ab().func_175016_a(this.tile.func_145831_w().func_180495_p(this.tile.func_174877_v()), 1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("lib", "textures/icons.png"));
        Vec3 p = Vec3.Def(0.5, 0.5, 0.5);
        switch (s) {
            case 0: {
                a = Vec3.Def(0.0, -1.0, 0.0);
                break;
            }
            case 1: {
                a = Vec3.Def(0.0, 1.0, 0.0);
                break;
            }
            case 2: {
                a = Vec3.Def(0.0, 0.0, -1.0);
                break;
            }
            case 3: {
                a = Vec3.Def(0.0, 0.0, 1.0);
                break;
            }
            case 4: {
                a = Vec3.Def(-1.0, 0.0, 0.0);
                break;
            }
            default: {
                a = Vec3.Def(1.0, 0.0, 0.0);
            }
        }
        Vec3d look = player.func_70040_Z();
        Vec3 b = Vec3.Def(look.field_72450_a, look.field_72448_b, look.field_72449_c).mult(a).norm();
        p = p.add(a.scale(0.5)).add(b.scale(-0.5));
        a = a.scale(1.5);
        float tx = (float)(144 + 16 * dir) / 256.0f;
        float dtx = 0.0625f;
        float ty = 0.09375f;
        float dty = 0.03125f;
        VertexBuffer t = Tessellator.func_178181_a().func_178180_c();
        t.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        t.func_181662_b(p.x + b.x, p.y + b.y, p.z + b.z).func_187315_a((double)tx, 0.125).func_181675_d();
        t.func_181662_b(p.x + a.x + b.x, p.y + a.y + b.y, p.z + a.z + b.z).func_187315_a((double)(tx + 0.0625f), 0.125).func_181675_d();
        t.func_181662_b(p.x + a.x, p.y + a.y, p.z + a.z).func_187315_a((double)(tx + 0.0625f), 0.09375).func_181675_d();
        t.func_181662_b(p.x, p.y, p.z).func_187315_a((double)tx, 0.09375).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GL11.glPopMatrix();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.tile == null) {
            return;
        }
        this.tabsX = 0;
        if (this.tile.tanks != null && this.tile.tanks.tanks.length > 0) {
            this.FtabX = this.tabsX -= 9 + this.tile.tanks.tanks.length * 9;
        }
        if (this.tile.inventory != null && this.tile.inventory.componets.length > 0) {
            this.ItabX = this.tabsX -= 9 + this.tile.inventory.componets.length * 9;
        }
        if (this.tile.energy != null) {
            this.EtabX = this.tabsX -= 18;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (this.field_147002_h instanceof TileContainer) {
            for (TileContainer.TankSlot slot : ((TileContainer)this.field_147002_h).tankSlots) {
                this.drawLiquidTank(slot.inventory, slot.tankNumber, slot.xDisplayPosition, slot.yDisplayPosition, slot.bigSize);
            }
        }
        if (this.FtabX < 0) {
            this.drawLiquidConfig(this.tile, this.FtabX, this.tabsY);
        }
        if (this.ItabX < 0) {
            this.drawItemConfig(this.tile, this.ItabX, this.tabsY);
        }
        if (this.EtabX < 0) {
            this.drawEnergyConfig(this.tile, this.EtabX, this.tabsY);
        }
    }

    protected void func_73864_a(int x, int y, int b) throws IOException {
        if (this.FtabX < 0) {
            this.clickLiquidConfig(this.tile, x - this.field_147003_i - this.FtabX, y - this.field_147009_r - this.tabsY);
        }
        if (this.ItabX < 0) {
            this.clickItemConfig(this.tile, x - this.field_147003_i - this.ItabX, y - this.field_147009_r - this.tabsY);
        }
        if (this.EtabX < 0) {
            this.clickEnergyConfig(this.tile, x - this.field_147003_i - this.EtabX, y - this.field_147009_r - this.tabsY);
        }
        super.func_73864_a(x, y, b);
    }

    public void drawLiquidTank(TankContainer tanks, int id, int x, int y, boolean s) {
        ResourceLocation res;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("lib", "textures/icons.png"));
        this.func_73729_b((x += this.field_147003_i) - 1, (y += this.field_147009_r) - 1, s ? 74 : 56, 0, s ? 36 : 18, 52);
        this.func_73729_b(x - 1, y + 51, s ? 74 : 56, 52 + 2 * (id & 3), s ? 36 : 18, 2);
        TextureAtlasSprite tex = null;
        if (tanks.getFluid(id) != null && (res = tanks.getFluid(id).getFluid().getStill()) != null) {
            tex = Minecraft.func_71410_x().func_147117_R().func_110572_b(res.toString());
        }
        if (tex != null) {
            this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            float n = 50.0f - (float)tanks.getAmount(id) / (float)tanks.tanks[id].cap * 50.0f;
            float u = tex.func_94209_e();
            float v = tex.func_94206_g();
            float u1 = tex.func_94212_f();
            float v1 = tex.func_94210_h();
            VertexBuffer r = Tessellator.func_178181_a().func_178180_c();
            r.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            r.func_181662_b((double)x, (double)(y + 50), (double)this.field_73735_i).func_187315_a((double)u, (double)v1).func_181675_d();
            r.func_181662_b((double)(x + (s ? 34 : 16)), (double)(y + 50), (double)this.field_73735_i).func_187315_a((double)u1, (double)v1).func_181675_d();
            r.func_181662_b((double)(x + (s ? 34 : 16)), (double)((float)y + n), (double)this.field_73735_i).func_187315_a((double)u1, (double)v).func_181675_d();
            r.func_181662_b((double)x, (double)((float)y + n), (double)this.field_73735_i).func_187315_a((double)u, (double)v).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
        this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("lib", "textures/icons.png"));
        this.func_73729_b(x + (s ? 17 : -1), y - 1, 110, 0, 18, 52);
        if (this.func_146978_c(x - this.field_147003_i, y - this.field_147009_r, s ? 34 : 16, 50, this.mouseX, this.mouseY)) {
            this.selTank = id;
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
    }

    public void drawInfo(int x, int y, int w, int h, String ... text) {
        if (this.func_146978_c(x, y, w, h, this.mouseX, this.mouseY)) {
            if (text.length == 2 && text[0].equals("\\i")) {
                String s = TooltipInfo.getLocFormat("gui.cd4017be." + text[1]);
                if (s == null) {
                    return;
                }
                text = s.split("\n");
            }
            this.drawHoveringText(Arrays.asList(text), this.mouseX - this.field_147003_i, this.mouseY - this.field_147009_r, this.field_146289_q);
        }
    }

    public void drawFormatInfo(int x, int y, int w, int h, String key, Object ... args) {
        if (this.func_146978_c(x, y, w, h, this.mouseX, this.mouseY)) {
            this.drawHoveringText(Arrays.asList(TooltipInfo.format("gui.cd4017be." + key, args).split("\n")), this.mouseX - this.field_147003_i, this.mouseY - this.field_147009_r, this.field_146289_q);
        }
    }

    public void drawTankInfo(int id, int x, int y) {
        TankContainer tank = ((AutomatedTile)((TileContainer)this.field_147002_h).tileEntity).tanks;
        ArrayList<String> info = new ArrayList<String>();
        if (tank.getFluid(id) != null) {
            info.add(tank.getFluid(id).getLocalizedName());
        } else {
            info.add("Empty");
        }
        info.add(String.format("%s/%s ", Utils.formatNumber((float)tank.getAmount(id) / 1000.0f, 3), Utils.formatNumber((float)tank.tanks[id].cap / 1000.0f, 3)) + TooltipInfo.getFluidUnit());
        this.drawHoveringText(info, x, y, this.field_146289_q);
    }

    public void drawLiquidConfig(AutomatedTile tile, int x, int y) {
        int s = tile.tanks.tanks.length;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("lib", "textures/icons.png"));
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 0, 0, 9 + s * 9, 81);
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 0, 81, 9, 9);
        for (int j = 0; j < s; ++j) {
            this.func_73729_b(this.field_147003_i + x + 9 + j * 9, this.field_147009_r + y, 18 + tile.tanks.tanks[j].dir * 9, 90, 9, 9);
            for (int i = 0; i < 6; ++i) {
                byte k = (byte)(tile.netData.longs[tile.tanks.netIdxLong] >> 2 * i + 16 * j & 3L);
                this.func_73729_b(this.field_147003_i + x + 9 + j * 9, this.field_147009_r + y + 9 + i * 9, 9 + k * 9, 81, 9, 9);
            }
            if ((tile.netData.longs[tile.tanks.netIdxLong] >> 12 + 16 * j & 1L) == 0L) continue;
            this.func_73729_b(this.field_147003_i + x + 9 + j * 9, this.field_147009_r + y + 63, 9, 81, 9, 9);
        }
    }

    public void drawItemConfig(AutomatedTile tile, int x, int y) {
        int s = tile.inventory.componets.length;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("lib", "textures/icons.png"));
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 0, 0, 9 + s * 9, 63);
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 0, 90, 9, 9);
        for (int j = 0; j < s; ++j) {
            this.func_73729_b(this.field_147003_i + x + 9 + j * 9, this.field_147009_r + y, 18 + tile.inventory.componets[j].d * 9, 90, 9, 9);
            for (int i = 0; i < 6; ++i) {
                byte k = (byte)(tile.netData.longs[tile.inventory.netIdxLong] >> 2 * i + 12 * j & 3L);
                this.func_73729_b(this.field_147003_i + x + 9 + j * 9, this.field_147009_r + y + 9 + i * 9, 9 + k * 9, 81, 9, 9);
            }
        }
    }

    public void drawEnergyConfig(AutomatedTile tile, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("lib", "textures/icons.png"));
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 0, 0, 18, 63);
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 0, 99, 9, 9);
        this.func_73729_b(this.field_147003_i + x + 9, this.field_147009_r + y, 36, 90, 9, 9);
        for (int i = 0; i < 6; ++i) {
            byte k = (byte)(tile.energy.con >> i & 1);
            this.func_73729_b(this.field_147003_i + x + 9, this.field_147009_r + y + 9 + i * 9, 18 - k * 9, 81, 9, 9);
        }
    }

    public void clickLiquidConfig(AutomatedTile tile, int rx, int ry) {
        if (rx < 0 || rx >= 9 + 9 * tile.tanks.tanks.length || ry < 0 || ry >= 81) {
            return;
        }
        int x = rx / 9 - 1;
        int y = ry / 9 - 1;
        if (x >= 0 && y >= 0) {
            int cmd = 1;
            byte d = (byte)(tile.netData.longs[tile.tanks.netIdxLong] >> 2 * y + 16 * x & 3L);
            if (y < 6) {
                d = (byte)(d + 1 & 3);
            } else if (y == 6) {
                d = (byte)(d ^ 1);
            } else if (y == 7) {
                cmd = 2;
            }
            long cfg = tile.netData.longs[tile.tanks.netIdxLong] & (3L << 2 * y + 16 * x ^ 0xFFFFFFFFFFFFFFFFL) | (long)d << 2 * y + 16 * x;
            PacketBuffer dos = tile.getPacketTargetData();
            dos.writeByte(cmd);
            if (cmd == 1) {
                dos.writeLong(cfg);
            } else if (cmd == 2) {
                dos.writeByte(x);
            }
            BlockGuiHandler.sendPacketToServer(dos);
        }
    }

    public void clickItemConfig(AutomatedTile tile, int rx, int ry) {
        if (rx < 0 || rx >= 9 + 9 * tile.inventory.componets.length || ry < 0 || ry >= 63) {
            return;
        }
        int x = rx / 9 - 1;
        int y = ry / 9 - 1;
        if (x >= 0 && y >= 0) {
            byte d = (byte)(tile.netData.longs[tile.inventory.netIdxLong] >> 2 * y + 12 * x & 3L);
            d = (byte)(d + 1 & 3);
            long cfg = tile.netData.longs[tile.inventory.netIdxLong] & (3L << 2 * y + 12 * x ^ 0xFFFFFFFFFFFFFFFFL) | (long)d << 2 * y + 12 * x;
            PacketBuffer dos = tile.getPacketTargetData();
            dos.writeByte(0);
            dos.writeLong(cfg);
            BlockGuiHandler.sendPacketToServer(dos);
        }
    }

    public void clickEnergyConfig(AutomatedTile tile, int rx, int ry) {
        if (rx < 0 || rx >= 18 || ry < 0 || ry >= 63) {
            return;
        }
        int x = rx / 9 - 1;
        int y = ry / 9 - 1;
        if (x >= 0 && y >= 0) {
            tile.energy.con = (byte)(tile.energy.con ^ 1 << y);
            PacketBuffer dos = tile.getPacketTargetData();
            dos.writeByte(3);
            dos.writeByte((int)tile.energy.con);
            BlockGuiHandler.sendPacketToServer(dos);
        }
    }

    protected Slot func_146975_c(int x, int y) {
        for (int k = 0; k < this.field_147002_h.field_75151_b.size(); ++k) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(k);
            if (!this.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, x, y)) continue;
            return slot;
        }
        return null;
    }

    protected void func_146273_a(int x, int y, int b, long t) {
        Slot slot = this.func_146975_c(x, y);
        ItemStack itemstack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (slot instanceof SlotHolo && slot != this.lastClickSlot) {
            if (itemstack == null || slot.func_75211_c() == null || itemstack.func_77969_a(slot.func_75211_c())) {
                this.func_184098_a(slot, slot.field_75222_d, b, ClickType.PICKUP);
            }
        } else {
            super.func_146273_a(x, y, b, t);
        }
        this.lastClickSlot = slot;
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.lastClickSlot = null;
    }

    public class TextField {
        public final int maxL;
        public String text;
        public int cur;

        public TextField(String text, int max) {
            this.maxL = max;
            this.text = text;
            this.cur = text.length();
        }

        public void draw(int x, int y, int ct, int cc) {
            GuiMachine.this.func_73728_b(x - 1 + GuiMachine.this.field_146289_q.func_78256_a(this.text.substring(0, this.cur)), y, y + 7, cc);
            GuiMachine.this.field_146289_q.func_78276_b(this.text, x, y, ct);
        }

        public byte keyTyped(char c, int k) {
            block15: {
                try {
                    if (k == 203 && this.cur > 0) {
                        --this.cur;
                    } else if (k == 205 && this.cur < this.text.length()) {
                        ++this.cur;
                    } else if (k == 211 && this.cur < this.text.length()) {
                        this.text = this.text.substring(0, this.cur).concat(this.text.substring(this.cur + 1));
                    } else if (k == 14 && this.cur > 0) {
                        --this.cur;
                        this.text = this.text.substring(0, this.cur).concat(this.text.substring(this.cur + 1));
                    } else {
                        if (k == 28) {
                            return 1;
                        }
                        if (k == 200) {
                            return 0;
                        }
                        if (k == 208) {
                            return 2;
                        }
                        if (ChatAllowedCharacters.func_71566_a((char)c) && this.cur < this.maxL) {
                            this.text = this.text.substring(0, this.cur).concat("" + c).concat(this.text.substring(this.cur, Math.min(this.text.length(), this.maxL - 1)));
                            ++this.cur;
                        }
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    if (this.cur < 0) {
                        this.cur = 0;
                    }
                    if (this.cur <= this.text.length()) break block15;
                    this.cur = this.text.length();
                }
            }
            return -1;
        }
    }
}

