/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.templates;

import cd4017be.api.automation.IItemPipeCon;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.templates.IAutomatedInv;
import cd4017be.lib.templates.IPipe;
import cd4017be.lib.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class Inventory
implements ISidedInventory {
    public int netIdxLong = 0;
    private ModTileEntity tile;
    public ItemStack[] items;
    public final Component[] componets;
    public String invName;

    public Inventory(ModTileEntity tile, int l, Component ... cmp) {
        this.tile = tile;
        this.componets = cmp == null ? new Component[]{} : cmp;
        this.items = new ItemStack[l];
    }

    public Inventory setInvName(String name) {
        this.invName = name;
        return this;
    }

    public Inventory setNetLong(int idx) {
        this.netIdxLong = idx;
        return this;
    }

    public void update() {
        if (this.tile.netData.longs[this.netIdxLong] == 0L) {
            return;
        }
        for (int i = 0; i < this.componets.length; ++i) {
            if (this.componets[i].d == 0) continue;
            for (int s = 0; s < 6; ++s) {
                TileEntity te;
                byte m = this.getConfig(this.tile.netData.longs[this.netIdxLong], s, i);
                if (m < 2 || this.componets[i].d > 0 ^ m == 3 && !(this.tile instanceof IItemPipeCon) || (te = Utils.getTileOnSide(this.tile, (byte)s)) == null || !(te instanceof IInventory)) continue;
                IInventory inv = (IInventory)te;
                if (this.componets[i].d > 0 ^ m == 3 && !(te instanceof IPipe)) continue;
                if (m == 3) {
                    Utils.transfer((IInventory)this, s, this.componets[i].slots(), inv, s ^ 1, Utils.accessibleSlots(inv, s ^ 1), new Utils.ItemType());
                    continue;
                }
                Utils.transfer(inv, s ^ 1, Utils.accessibleSlots(inv, s ^ 1), (IInventory)this, s, this.componets[i].slots(), new Utils.ItemType());
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbt, String name) {
        NBTTagList list = new NBTTagList();
        for (int s = 0; s < this.items.length; ++s) {
            if (this.items[s] == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)s);
            this.items[s].func_77955_b(item);
            list.func_74742_a((NBTBase)item);
        }
        nbt.func_74782_a(name, (NBTBase)list);
    }

    public void readFromNBT(NBTTagCompound nbt, String name) {
        NBTTagList list = nbt.func_150295_c(name, 10);
        for (int id = 0; id < list.func_74745_c(); ++id) {
            NBTTagCompound item = list.func_150305_b(id);
            byte s = item.func_74771_c("Slot");
            if (s < 0 || s >= this.items.length) continue;
            this.items[s] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
    }

    public static int[] getSlots(IInventory inv, int s) {
        if (inv instanceof ISidedInventory) {
            return ((ISidedInventory)inv).func_180463_a(EnumFacing.field_82609_l[s]);
        }
        int[] array = new int[inv.func_70302_i_()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = i;
        }
        return array;
    }

    public static int[] findItemStack(IInventory inv, int[] slots, int s, ItemStack type, int n, boolean check) {
        boolean sided = check && inv instanceof ISidedInventory;
        int[] array = new int[slots.length];
        int i = 0;
        for (int slot : slots) {
            ItemStack stack = inv.func_70301_a(slot);
            if (stack == null || type != null && !Utils.itemsEqual(stack, type) || sided && !((ISidedInventory)inv).func_180461_b(slot, stack, EnumFacing.field_82609_l[s])) continue;
            array[i++] = slot;
            if (type == null) {
                type = stack;
            }
            if ((n -= stack.field_77994_a) <= 0) break;
        }
        slots = new int[i];
        System.arraycopy(array, 0, slots, 0, i);
        return slots;
    }

    public static int[] findPlaceFor(IInventory inv, int s, ItemStack item, int n, boolean check) {
        ItemStack stack;
        if (item == null) {
            return new int[0];
        }
        item = item.func_77946_l();
        boolean sided = check && inv instanceof ISidedInventory;
        int[] slots = Inventory.getSlots(inv, s);
        int[] array = new int[slots.length];
        boolean hasnull = false;
        int i = 0;
        for (int slot : slots) {
            stack = inv.func_70301_a(slot);
            if (stack != null && Utils.itemsEqual(stack, item) && (!sided || ((ISidedInventory)inv).func_180462_a(slot, item, EnumFacing.field_82609_l[s]))) {
                int m = Math.min(inv.func_70297_j_(), stack.func_77976_d()) - stack.field_77994_a;
                if (m <= 0) continue;
                array[i++] = slot;
                if ((n -= m) > 0) continue;
                break;
            }
            if (stack != null) continue;
            hasnull = true;
        }
        if (hasnull && n > 0) {
            for (int slot : slots) {
                stack = inv.func_70301_a(slot);
                if (stack != null || sided && !((ISidedInventory)inv).func_180462_a(slot, item, EnumFacing.field_82609_l[s])) continue;
                array[i++] = slot;
                if ((n -= inv.func_70297_j_()) <= 0) break;
            }
        }
        slots = new int[i];
        System.arraycopy(array, 0, slots, 0, i);
        return slots;
    }

    public static void transferItems(IInventory srcI, int[] srcS, int n, IInventory dstI, int[] dstS) {
        int i = 0;
        for (int slot : dstS) {
            int m;
            ItemStack stack = dstI.func_70301_a(slot);
            int n2 = m = stack == null ? dstI.func_70297_j_() : Math.min(dstI.func_70297_j_(), stack.func_77976_d()) - stack.field_77994_a;
            while (m > 0 && n > 0) {
                ItemStack item = srcI.func_70298_a(srcS[i], Math.min(m, n));
                if (item == null) {
                    if (++i < srcS.length) continue;
                    n = 0;
                    continue;
                }
                if (stack == null) {
                    stack = item;
                    m = Math.min(m, stack.func_77976_d());
                } else {
                    stack.field_77994_a += item.field_77994_a;
                }
                m -= item.field_77994_a;
                n -= item.field_77994_a;
            }
            dstI.func_70299_a(slot, stack);
            if (n <= 0) break;
        }
        srcI.func_70296_d();
        dstI.func_70296_d();
    }

    public byte getConfig(long cfg, int s, int id) {
        return (byte)(cfg >> 2 * s + 12 * id & 3L);
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.items[i];
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        ItemStack old = this.items[i];
        this.items[i] = itemstack;
        this.slotChange(old, this.items[i], i);
    }

    public int func_70297_j_() {
        return 64;
    }

    private void slotChange(ItemStack oldItem, ItemStack newItem, int slot) {
        if (this.tile instanceof IAutomatedInv) {
            ((IAutomatedInv)((Object)this.tile)).slotChange(oldItem, newItem, slot);
        }
        for (Component cmp : this.componets) {
            if (slot < cmp.s || slot >= cmp.e) continue;
            cmp.invChange = true;
            return;
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] array = new int[this.items.length];
        int n = 0;
        for (int i = 0; i < this.componets.length; ++i) {
            byte m = this.getConfig(this.tile.netData.longs[this.netIdxLong], side.func_176745_a(), i);
            if (m == 0) continue;
            int j = this.componets[i].s;
            while (j < this.componets[i].e) {
                array[n++] = j++;
            }
        }
        int[] slots = new int[n];
        System.arraycopy(array, 0, slots, 0, n);
        return slots;
    }

    public boolean func_180462_a(int i, ItemStack itemstack, EnumFacing s) {
        for (int j = 0; j < this.componets.length; ++j) {
            if (i < this.componets[j].s || i >= this.componets[j].e) continue;
            byte m = this.getConfig(this.tile.netData.longs[this.netIdxLong], s.func_176745_a(), j);
            return m == 1 || m == 2 && (!(this.tile instanceof IAutomatedInv) || ((IAutomatedInv)((Object)this.tile)).canInsert(itemstack, j, i));
        }
        return false;
    }

    public boolean func_180461_b(int i, ItemStack itemstack, EnumFacing s) {
        for (int j = 0; j < this.componets.length; ++j) {
            if (i < this.componets[j].s || i >= this.componets[j].e) continue;
            byte m = this.getConfig(this.tile.netData.longs[this.netIdxLong], s.func_176745_a(), j);
            return m == 1 || m == 3 && (!(this.tile instanceof IAutomatedInv) || ((IAutomatedInv)((Object)this.tile)).canExtract(itemstack, j, i));
        }
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        for (int j = 0; j < this.componets.length; ++j) {
            if (i < this.componets[j].s || i >= this.componets[j].e) continue;
            return this.tile instanceof IAutomatedInv ? ((IAutomatedInv)((Object)this.tile)).isValid(itemstack, j, i) : true;
        }
        return false;
    }

    public ItemStack func_70298_a(int i, int n) {
        ItemStack ret;
        if (this.items[i] == null) {
            return null;
        }
        ItemStack old = this.items[i].func_77946_l();
        if (n < this.items[i].field_77994_a) {
            ret = this.items[i].func_77979_a(n);
        } else {
            ret = this.items[i];
            this.items[i] = null;
        }
        this.slotChange(old, this.items[i], i);
        return ret;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack item = this.items[i];
        this.items[i] = null;
        return item;
    }

    public String func_70005_c_() {
        return this.invName;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public void func_70296_d() {
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = null;
        }
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public static class Component {
        public final int s;
        public final int e;
        public final byte d;
        public boolean invChange = true;

        public Component(int s, int e, int d) {
            this.s = s;
            this.e = e;
            this.d = (byte)d;
        }

        public int[] slots() {
            int[] slots = new int[this.e - this.s];
            for (int i = 0; i < slots.length; ++i) {
                slots[i] = this.s + i;
            }
            return slots;
        }
    }
}

