/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.templates;

import cd4017be.lib.templates.IComponent;
import cd4017be.lib.util.Obj2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.util.math.BlockPos;

public abstract class SharedNetwork<C extends IComponent<C, N>, N extends SharedNetwork<C, N>> {
    protected C core;
    public final HashMap<Long, C> components;
    protected boolean update = false;
    private static final int spreader = 549568949;

    public SharedNetwork(C core) {
        this.components = new HashMap();
        this.components.put(core.getUID(), core);
        this.core = core;
        this.core.setNetwork((SharedNetwork)this);
    }

    protected SharedNetwork(HashMap<Long, C> comps) {
        this.components = comps;
    }

    public abstract N onSplit(HashMap<Long, C> var1);

    public void onMerged(N network) {
        for (IComponent c : ((SharedNetwork)network).components.values()) {
            c.setNetwork(this);
        }
        this.components.putAll(((SharedNetwork)network).components);
    }

    public void add(C comp) {
        SharedNetwork network = comp.getNetwork();
        if (network == this) {
            return;
        }
        if (this.components.size() >= network.components.size()) {
            this.onMerged(network);
        } else {
            network.onMerged((SharedNetwork)this);
            for (IComponent c : this.components.values()) {
                c.setNetwork(network);
            }
            network.components.putAll(this.components);
        }
    }

    public void remove(C comp) {
        this.components.remove(comp.getUID());
        if (this.core == comp) {
            this.core = null;
        }
        this.update = true;
    }

    public void onDisconnect(C comp, byte side, long neighbor) {
        IComponent obj = (IComponent)this.components.get(neighbor);
        if (obj != null && obj.canConnect(side)) {
            this.update = true;
        }
    }

    public void updateTick(C comp) {
        if (this.core == null) {
            this.core = comp;
        } else if (comp != this.core) {
            return;
        }
        this.updatePhysics();
        if (this.update) {
            this.reassembleNetwork();
            this.update = false;
        }
    }

    protected void updatePhysics() {
    }

    private void reassembleNetwork() {
        ArrayList<Object> queue = new ArrayList<Object>();
        while (this.components.size() > 1) {
            HashMap<Long, IComponent> comps = new HashMap<Long, IComponent>();
            queue.clear();
            queue.add(this.core);
            while (!queue.isEmpty()) {
                IComponent obj = (IComponent)queue.remove(queue.size() - 1);
                comps.put(obj.getUID(), obj);
                for (Obj2<Long, Byte> e : obj.getConnections()) {
                    IComponent obj1 = (IComponent)this.components.get(e.objA);
                    if (obj1 == null || comps.containsKey(e.objA) || !obj1.canConnect((Byte)e.objB)) continue;
                    queue.add(obj1);
                }
            }
            if (comps.size() == this.components.size()) {
                return;
            }
            N network = this.onSplit(comps);
            for (Map.Entry e : comps.entrySet()) {
                ((IComponent)e.getValue()).setNetwork(network);
                this.components.remove(e.getKey());
            }
            Iterator i$ = this.components.values().iterator();
            if (!i$.hasNext()) continue;
            IComponent c = (IComponent)((Object)i$.next());
            this.core = c;
        }
    }

    public static long ExtPosUID(BlockPos pos, int dimId) {
        return pos.func_177986_g() ^ (long)(dimId *= 549568949) << 32;
    }

    public static long SidedPosUID(long base, int side) {
        return base ^ (long)(side * 549568949);
    }
}

