/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictStack {
    public String id;
    public int stacksize;

    public OreDictStack(String id, int n) {
        this.id = id;
        this.stacksize = n;
    }

    public OreDictStack(int id, int n) {
        this.id = OreDictionary.getOreName((int)id);
        this.stacksize = n;
    }

    public static OreDictStack deserialize(String s) {
        int p = s.indexOf(42);
        short n = 1;
        if (p > 0) {
            try {
                n = Short.parseShort(s.substring(0, p));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            s = s.substring(p + 1);
            if (n <= 0) {
                n = 1;
            }
        }
        if (s.isEmpty()) {
            return null;
        }
        return new OreDictStack(s, (int)n);
    }

    public static OreDictStack[] get(ItemStack item) {
        if (item == null || item.func_77973_b() == null) {
            return null;
        }
        int[] i = OreDictionary.getOreIDs((ItemStack)item);
        OreDictStack[] stacks = new OreDictStack[i.length];
        for (int j = 0; j < i.length; ++j) {
            stacks[j] = new OreDictStack(i[j], item.field_77994_a);
        }
        return stacks;
    }

    public boolean isEqual(ItemStack item) {
        if (item == null || item.func_77973_b() == null) {
            return false;
        }
        int ore = OreDictionary.getOreID((String)this.id);
        for (int id : OreDictionary.getOreIDs((ItemStack)item)) {
            if (id != ore) continue;
            return true;
        }
        return false;
    }

    public ItemStack[] getItems() {
        List list = OreDictionary.getOres((String)this.id);
        ItemStack[] items = new ItemStack[list.size()];
        int n = 0;
        for (ItemStack item : list) {
            items[n] = item.func_77946_l();
            items[n++].field_77994_a = this.stacksize;
        }
        return items;
    }

    public OreDictStack copy() {
        return new OreDictStack(this.id, this.stacksize);
    }
}

