/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import cd4017be.lib.ModTileEntity;
import cd4017be.lib.util.Obj2;
import java.text.DecimalFormatSymbols;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.oredict.OreDictionary;

public class Utils {
    public static EnumFacing[][] AXIS_Rad = new EnumFacing[][]{{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH}, {EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.WEST, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.UP}};
    private static final String[] DecScale = new String[]{"a", "f", "p", "n", "u", "m", "", "k", "M", "G", "T", "P", "E"};
    private static final int ofsDecScale = 6;

    public static boolean itemsEqual(ItemStack item0, ItemStack item1) {
        return item0 == null && item1 == null || item0 != null && item1 != null && item0.func_77969_a(item1) && ItemStack.func_77970_a((ItemStack)item0, (ItemStack)item1);
    }

    public static boolean oresEqual(ItemStack item0, ItemStack item1) {
        if (Utils.itemsEqual(item0, item1)) {
            return true;
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)item0);
        for (int id1 : OreDictionary.getOreIDs((ItemStack)item1)) {
            for (int id0 : ids) {
                if (id0 != id1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean fluidsEqual(FluidStack fluid0, FluidStack fluid1, boolean am) {
        if (fluid0 == null && fluid1 == null) {
            return true;
        }
        if (fluid0 != null && fluid1 != null) {
            return am ? fluid0.isFluidStackIdentical(fluid1) : fluid0.isFluidEqual(fluid1);
        }
        return false;
    }

    public static int[] accessibleSlots(IInventory inv, int side) {
        if (inv instanceof ISidedInventory) {
            return ((ISidedInventory)inv).func_180463_a(EnumFacing.field_82609_l[side]);
        }
        int[] s = new int[inv.func_70302_i_()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = i;
        }
        return s;
    }

    public static ItemStack[] fill(IInventory inv, int side, int[] s, ItemStack ... items) {
        int m;
        ISidedInventory si = inv instanceof ISidedInventory ? (ISidedInventory)inv : null;
        boolean action = false;
        int pn = -1;
        for (int i = 0; i < s.length; ++i) {
            ItemStack stack = inv.func_70301_a(s[i]);
            if (stack == null) {
                if (pn >= 0) continue;
                pn = i;
                continue;
            }
            if (si != null && !si.func_180462_a(s[i], stack, EnumFacing.field_82609_l[side])) continue;
            stack = stack.func_77946_l();
            boolean f = false;
            m = Math.min(stack.func_77976_d(), inv.func_70297_j_());
            for (int j = 0; j < items.length && stack.field_77994_a < m; ++j) {
                if (items[j] == null || !Utils.itemsEqual(items[j], stack)) continue;
                if (items[j].field_77994_a <= m - stack.field_77994_a) {
                    stack.field_77994_a += items[j].field_77994_a;
                    items[j] = null;
                } else {
                    items[j].field_77994_a -= m - stack.field_77994_a;
                    stack.field_77994_a = m;
                }
                f = true;
            }
            if (!f) continue;
            inv.func_70299_a(s[i], stack);
            action = true;
        }
        ItemStack[] array = new ItemStack[items.length];
        int n = 0;
        if (pn < 0) {
            pn = s.length;
        }
        for (int i = 0; i < items.length; ++i) {
            int n2 = m = items[i] == null ? 0 : Math.min(items[i].func_77976_d(), inv.func_70297_j_());
            while (items[i] != null && pn < s.length) {
                if (inv.func_70301_a(s[pn]) == null && (si == null || si.func_180462_a(s[pn], items[i], EnumFacing.field_82609_l[side]))) {
                    if (items[i].field_77994_a <= m) {
                        inv.func_70299_a(s[pn], items[i]);
                        items[i] = null;
                    } else {
                        inv.func_70299_a(s[pn], items[i].func_77979_a(m));
                    }
                    action = true;
                }
                ++pn;
            }
            if (items[i] == null) continue;
            array[n++] = items[i];
        }
        items = new ItemStack[n];
        if (action) {
            inv.func_70296_d();
        }
        System.arraycopy(array, 0, items, 0, n);
        return items;
    }

    public static ItemStack fillStack(IInventory inv, int side, int[] s, ItemStack item) {
        ISidedInventory si = inv instanceof ISidedInventory ? (ISidedInventory)inv : null;
        int m = Math.min(item.func_77976_d(), inv.func_70297_j_());
        boolean action = false;
        int pn = -1;
        for (int i = 0; i < s.length && item != null; ++i) {
            ItemStack stack = inv.func_70301_a(s[i]);
            if (stack == null) {
                if (pn >= 0) continue;
                pn = i;
                continue;
            }
            if (stack.field_77994_a >= m || !stack.func_77969_a(item) || si != null && !si.func_180462_a(s[i], item, EnumFacing.field_82609_l[side])) continue;
            if (item.field_77994_a <= m - stack.field_77994_a) {
                stack.field_77994_a += item.field_77994_a;
                item = null;
            } else {
                item.field_77994_a -= m - stack.field_77994_a;
                stack.field_77994_a = m;
            }
            inv.func_70299_a(s[i], stack);
            action = true;
        }
        if (pn < 0) {
            pn = s.length;
        }
        while (item != null && pn < s.length) {
            if (inv.func_70301_a(s[pn]) == null && (si == null || si.func_180462_a(s[pn], item, EnumFacing.field_82609_l[side]))) {
                if (item.field_77994_a <= m) {
                    inv.func_70299_a(s[pn], item);
                    item = null;
                } else {
                    inv.func_70299_a(s[pn], item.func_77979_a(m));
                }
                action = true;
            }
            ++pn;
        }
        if (action) {
            inv.func_70296_d();
        }
        return item;
    }

    public static Obj2<int[], ItemStack[]> getFilledSlots(IInventory inv, int[] slots, int side, boolean fill) {
        ISidedInventory invS = inv instanceof ISidedInventory ? (ISidedInventory)inv : null;
        int[] outS = new int[slots.length];
        ItemStack[] outI = new ItemStack[slots.length];
        int n = 0;
        for (int s : slots) {
            ItemStack item = inv.func_70301_a(s);
            if (item == null || fill && item.field_77994_a >= item.func_77976_d() || invS != null && !(fill ? invS.func_180461_b(s, item, EnumFacing.field_82609_l[side]) : invS.func_180462_a(s, item, EnumFacing.field_82609_l[side]))) continue;
            outS[n] = s;
            outI[n++] = item;
        }
        if (n == 0) {
            return null;
        }
        Obj2<int[], ItemStack[]> ret = new Obj2<int[], ItemStack[]>(new int[n], new ItemStack[n]);
        System.arraycopy(outS, 0, ret.objA, 0, n);
        System.arraycopy(outI, 0, ret.objB, 0, n);
        return ret;
    }

    public static int getEmptySlot(IInventory inv, int[] slots, int side, ItemStack type) {
        ISidedInventory invS = inv instanceof ISidedInventory ? (ISidedInventory)inv : null;
        for (int s : slots) {
            ItemStack item = inv.func_70301_a(s);
            if (item != null || invS != null && !invS.func_180462_a(s, item, EnumFacing.field_82609_l[side])) continue;
            return s;
        }
        return -1;
    }

    public static void transfer(IInventory src, int sideS, int[] sS, IInventory dst, int sideD, int[] sD, ItemType type) {
        ISidedInventory srcS = src instanceof ISidedInventory ? (ISidedInventory)src : null;
        ISidedInventory dstS = dst instanceof ISidedInventory ? (ISidedInventory)dst : null;
        for (int i : sS) {
            ItemStack curItem = src.func_70301_a(i);
            if (curItem == null || !type.matches(curItem) || srcS != null && !srcS.func_180461_b(i, curItem, EnumFacing.field_82609_l[sideS])) continue;
            int m = Math.min(curItem.func_77976_d(), dst.func_70297_j_());
            int p = -1;
            boolean done = false;
            for (int j : sD) {
                ItemStack stack = dst.func_70301_a(j);
                if (stack == null && p == -1 && (dstS == null || dstS.func_180462_a(j, curItem, EnumFacing.field_82609_l[sideD]))) {
                    p = j;
                    continue;
                }
                if (!Utils.itemsEqual(curItem, stack) || stack.field_77994_a >= m) continue;
                done = true;
                int n = m - stack.field_77994_a;
                ItemStack item = src.func_70298_a(i, n);
                stack = dst.func_70301_a(j);
                if (item == null) break;
                item.field_77994_a = item.field_77994_a + (stack == null ? 0 : stack.field_77994_a);
                dst.func_70299_a(j, item);
                curItem = src.func_70301_a(i);
                if (curItem == null) break;
            }
            if (p >= 0) {
                dst.func_70299_a(p, src.func_70298_a(i, m));
                done = true;
            }
            if (!done) continue;
            src.func_70296_d();
            dst.func_70296_d();
            return;
        }
    }

    public static ItemStack drainStack(IInventory inv, int side, int[] s, ItemType type, int am) {
        ISidedInventory si = inv instanceof ISidedInventory ? (ISidedInventory)inv : null;
        int max = 0;
        int pos = -1;
        for (int i = 0; i < s.length; ++i) {
            ItemStack stack = inv.func_70301_a(s[i]);
            if (stack == null || !type.matches(stack) || si != null && (!si.func_180461_b(s[i], stack, EnumFacing.field_82609_l[side]) || stack.field_77994_a <= max)) continue;
            pos = s[i];
            max = stack.field_77994_a;
        }
        if (pos >= 0) {
            ItemStack stack = inv.func_70298_a(pos, am);
            inv.func_70296_d();
            return stack;
        }
        return null;
    }

    public static ItemStack[] drain(IInventory inv, int side, int[] s, ItemType type, int am) {
        ISidedInventory si = inv instanceof ISidedInventory ? (ISidedInventory)inv : null;
        ItemStack[] array = new ItemStack[s.length];
        int n = 0;
        for (int i : s) {
            ItemStack stack = inv.func_70301_a(i);
            if (!type.matches(stack) || si != null && !si.func_180461_b(i, stack, EnumFacing.field_82609_l[side])) continue;
            ItemStack item = inv.func_70298_a(i, am);
            am -= item.field_77994_a;
            for (int j = 0; j < array.length; ++j) {
                if (array[j] == null) {
                    array[j] = item;
                    if (j <= n) break;
                    n = j;
                    break;
                }
                if (!Utils.itemsEqual(array[j], item)) continue;
                array[j].field_77994_a += item.field_77994_a;
                break;
            }
            if (am <= 0) break;
        }
        ItemStack[] items = new ItemStack[n];
        System.arraycopy(array, 0, items, 0, n);
        return items;
    }

    public static TileEntity getTileOnSide(ModTileEntity tileEntity, byte s) {
        if (tileEntity == null) {
            return null;
        }
        int x = tileEntity.func_174877_v().func_177958_n();
        int y = tileEntity.func_174877_v().func_177956_o();
        int z = tileEntity.func_174877_v().func_177952_p();
        if (s == 0) {
            --y;
        } else if (s == 1) {
            ++y;
        } else if (s == 2) {
            --z;
        } else if (s == 3) {
            ++z;
        } else if (s == 4) {
            --x;
        } else if (s == 5) {
            ++x;
        }
        return tileEntity.getLoadedTile(new BlockPos(x, y, z));
    }

    public static String formatNumber(double x, int w, int c) {
        String ds;
        double s = Math.signum(x);
        if (x == 0.0 || Double.isNaN(x) || Double.isInfinite(x)) {
            return "" + x;
        }
        int o = (int)Math.floor(Math.log10(x * s)) + 18;
        int p = (o + c) / 3;
        int n = w - o + p * 3 - 1;
        if (p < 0) {
            return "0";
        }
        if (p > DecScale.length) {
            return "" + (s == -1.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
        }
        String tex = String.format("%." + n + "f", x *= Math.pow(0.001, p - 6)) + DecScale[p];
        if (tex.contains(ds = "" + DecimalFormatSymbols.getInstance().getDecimalSeparator())) {
            while (tex.endsWith("0")) {
                tex = tex.substring(0, tex.length() - 1);
            }
            if (tex.endsWith(ds)) {
                tex = tex.substring(0, tex.length() - 1);
            }
        }
        return tex;
    }

    public static String formatNumber(double x, int w) {
        String ds;
        String tex = String.format("%." + w + "f", x);
        if (tex.contains(ds = "" + DecimalFormatSymbols.getInstance().getDecimalSeparator())) {
            while (tex.endsWith("0")) {
                tex = tex.substring(0, tex.length() - 1);
            }
            if (tex.endsWith(ds)) {
                tex = tex.substring(0, tex.length() - 1);
            }
        }
        return tex;
    }

    public static FluidStack getFluid(World world, BlockPos pos, boolean sourceOnly) {
        boolean source;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150350_a) {
            return null;
        }
        if (block instanceof IFluidBlock) {
            FluidStack fluid = ((IFluidBlock)block).drain(world, pos, false);
            if (!sourceOnly && fluid == null) {
                return new FluidStack(((IFluidBlock)block).getFluid(), 0);
            }
            return fluid;
        }
        boolean bl = source = state == block.func_176223_P();
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            return source || !sourceOnly ? new FluidStack(FluidRegistry.WATER, source ? 1000 : 0) : null;
        }
        if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            return source || !sourceOnly ? new FluidStack(FluidRegistry.LAVA, source ? 1000 : 0) : null;
        }
        return null;
    }

    public static FluidStack getFluid(ItemStack item) {
        if (item == null) {
            return null;
        }
        FluidStack fluid = item.func_77973_b() instanceof IFluidContainerItem ? ((IFluidContainerItem)item.func_77973_b()).getFluid(item) : FluidContainerRegistry.getFluidForFilledItem((ItemStack)item);
        if (fluid != null) {
            fluid.amount *= item.field_77994_a;
        }
        return fluid;
    }

    public static Obj2<ItemStack, FluidStack> drainFluid(ItemStack item, int am) {
        if (item == null || item.field_77994_a == 0) {
            return new Obj2<ItemStack, FluidStack>();
        }
        Obj2<ItemStack, Object> ret = new Obj2<ItemStack, Object>(item.func_77946_l(), null);
        int n = item.field_77994_a;
        if ((am /= n) <= 0) {
            return ret;
        }
        if (item.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem cont = (IFluidContainerItem)item.func_77973_b();
            ret.objB = cont.drain((ItemStack)ret.objA, am, true);
            if (ret.objB != null) {
                ((FluidStack)ret.objB).amount *= n;
            }
            if (((ItemStack)ret.objA).field_77994_a <= 0) {
                ret.objA = null;
            }
        } else {
            ret.objB = FluidContainerRegistry.getFluidForFilledItem((ItemStack)item);
            if (ret.objB != null && ((FluidStack)ret.objB).amount <= am) {
                ret.objA = FluidContainerRegistry.drainFluidContainer((ItemStack)item);
                if (ret.objA != null) {
                    ((ItemStack)ret.objA).field_77994_a *= n;
                }
                ((FluidStack)ret.objB).amount *= n;
            } else {
                ret.objB = null;
            }
        }
        return ret;
    }

    public static Obj2<ItemStack, Integer> fillFluid(ItemStack item, FluidStack fluid) {
        if (item == null || item.field_77994_a == 0) {
            return new Obj2<Object, Integer>(null, 0);
        }
        Obj2<ItemStack, Integer> ret = new Obj2<ItemStack, Integer>(item.func_77946_l(), 0);
        int n = item.field_77994_a;
        if (fluid == null || fluid.amount < n) {
            return ret;
        }
        FluidStack stack = fluid.copy();
        stack.amount /= n;
        if (item.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem cont = (IFluidContainerItem)item.func_77973_b();
            ret.objB = cont.fill((ItemStack)ret.objA, stack, true) * n;
            if (((ItemStack)ret.objA).field_77994_a <= 0) {
                ret.objA = null;
            }
        } else if (FluidContainerRegistry.isEmptyContainer((ItemStack)item)) {
            ret.objB = FluidContainerRegistry.getContainerCapacity((FluidStack)stack, (ItemStack)item);
            if ((Integer)ret.objB != 0 && (Integer)ret.objB <= stack.amount) {
                ret.objA = FluidContainerRegistry.fillFluidContainer((FluidStack)stack, (ItemStack)item);
                if (ret.objA != null) {
                    ((ItemStack)ret.objA).field_77994_a *= n;
                }
                Obj2<ItemStack, Integer> obj2 = ret;
                obj2.objB = (Integer)obj2.objB * n;
            } else {
                ret.objB = 0;
            }
        }
        return ret;
    }

    public static int findStack(ItemStack item, IInventory inv, int[] s, int start) {
        if (item == null) {
            return -1;
        }
        for (int i = start; i < s.length; ++i) {
            if (!Utils.itemsEqual(item, inv.func_70301_a(s[i]))) continue;
            return i;
        }
        return -1;
    }

    public static int mod(int a, int b) {
        return a < 0 ? b - (-a - 1) % b - 1 : a % b;
    }

    public static int div(int a, int b) {
        return a < 0 ? -1 - (-a - 1) / b : a / b;
    }

    public static byte getLookDir(Entity entity) {
        if (entity.field_70125_A < -45.0f) {
            return 0;
        }
        if (entity.field_70125_A > 45.0f) {
            return 1;
        }
        int d = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (d == 0) {
            return 2;
        }
        if (d == 1) {
            return 5;
        }
        if (d == 2) {
            return 3;
        }
        return 4;
    }

    public static class ItemType {
        public final ItemStack[] types;
        public final boolean meta;
        public final boolean nbt;
        public final int[] ores;

        public ItemType() {
            this.types = null;
            this.ores = null;
            this.meta = false;
            this.nbt = false;
        }

        public ItemType(ItemStack ... types) {
            this.types = types;
            this.ores = null;
            this.meta = true;
            this.nbt = true;
        }

        public ItemType(boolean meta, boolean nbt, boolean ore, ItemStack ... types) {
            this.types = types;
            this.meta = meta;
            this.nbt = nbt;
            if (ore) {
                HashSet<Integer> list = new HashSet<Integer>();
                for (int i = 0; i < types.length; ++i) {
                    for (int j : OreDictionary.getOreIDs((ItemStack)types[i])) {
                        list.add(j);
                    }
                }
                this.ores = new int[list.size()];
                int n = 0;
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    int i = (Integer)i$.next();
                    this.ores[n++] = i;
                }
            } else {
                this.ores = null;
            }
        }

        public boolean matches(ItemStack item) {
            if (item == null) {
                return false;
            }
            if (this.types == null) {
                return true;
            }
            for (ItemStack type : this.types) {
                if (type == null || item.func_77973_b() != type.func_77973_b() || this.meta && item.func_77952_i() != type.func_77952_i() || this.nbt && !ItemStack.func_77970_a((ItemStack)item, (ItemStack)type)) continue;
                return true;
            }
            if (this.ores == null) {
                return false;
            }
            for (int o : OreDictionary.getOreIDs((ItemStack)item)) {
                for (int i : this.ores) {
                    if (i != o) continue;
                    return true;
                }
            }
            return false;
        }

        public int getMatch(ItemStack item) {
            if (item == null) {
                return -1;
            }
            if (this.types == null) {
                return -1;
            }
            for (int i = 0; i < this.types.length; ++i) {
                ItemStack type = this.types[i];
                if (type == null || item.func_77973_b() != type.func_77973_b() || this.meta && item.func_77952_i() != type.func_77952_i() || this.nbt && !ItemStack.func_77970_a((ItemStack)item, (ItemStack)type)) continue;
                return i;
            }
            if (this.ores == null) {
                return -1;
            }
            for (int o : OreDictionary.getOreIDs((ItemStack)item)) {
                for (int i = 0; i < this.ores.length; ++i) {
                    if (this.ores[i] != o) continue;
                    return i;
                }
            }
            return -1;
        }
    }
}

