/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.modules;

import c4.corpsecomplex.common.Module;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ExperienceModule
extends Module {
    private static boolean keepXP;
    private static double xpLoss;
    private static double xpRecover;
    private static boolean cfgEnabled;

    @SubscribeEvent
    public void onPlayerXPDrop(LivingExperienceDropEvent e) {
        if (!(e.getEntityLiving() instanceof EntityPlayer) || e.getEntityLiving().func_130014_f_().field_72995_K) {
            return;
        }
        ExperienceModule.setExperiencesValues(e);
    }

    @SubscribeEvent
    public void onPlayerRespawnBegin(PlayerEvent.Clone e) {
        if (!e.isWasDeath() || e.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        ExperienceModule.restoreXP(e.getEntityPlayer(), e.getOriginal());
    }

    public ExperienceModule() {
        super("Experience", "Customize experience loss on death");
    }

    @Override
    public void loadModuleConfig() {
        this.setCategoryComment();
        cfgEnabled = this.getBool("Enable Experience Module", false, "Set to true to enable experience module", false);
        keepXP = this.getBool("Keep All XP", false, "Set to true to keep all XP on death", false);
        xpLoss = this.getDouble("Lost XP Percent", 1.0, 0.0f, 1.0f, "Percent of experience lost on death", false);
        xpRecover = this.getDouble("Recoverable XP Percent", 0.2f, 0.0f, 1.0f, "Percent of lost experience that can be recovered", false);
    }

    @Override
    public void initPropOrder() {
        this.propOrder = new ArrayList<String>(Collections.singletonList("Enable Experience Module"));
    }

    @Override
    public void setEnabled() {
        this.enabled = cfgEnabled && !Loader.isModLoaded((String)"tombstone");
    }

    private static void restoreXP(EntityPlayer player, EntityPlayer oldPlayer) {
        player.func_71023_q(oldPlayer.field_71067_cb);
    }

    private static void setExperiencesValues(LivingExperienceDropEvent e) {
        if (keepXP) {
            e.setCanceled(true);
        } else {
            EntityPlayer player = (EntityPlayer)e.getEntityLiving();
            int dropXP = (int)Math.round((double)player.field_71067_cb * xpLoss * xpRecover);
            int keptXP = (int)Math.round((double)player.field_71067_cb * (1.0 - xpLoss));
            e.setDroppedExperience(dropXP);
            player.field_71068_ca = 0;
            player.field_71106_cc = 0.0f;
            player.field_71067_cb = 0;
            ExperienceModule.addExperience(player, keptXP);
        }
    }

    private static void addExperience(EntityPlayer player, int amount) {
        int i = Integer.MAX_VALUE - player.field_71067_cb;
        if (amount > i) {
            amount = i;
        }
        player.field_71106_cc += (float)amount / (float)player.func_71050_bK();
        player.field_71067_cb += amount;
        while (player.field_71106_cc >= 1.0f) {
            player.field_71106_cc = (player.field_71106_cc - 1.0f) * (float)player.func_71050_bK();
            ++player.field_71068_ca;
            if (player.field_71068_ca < 0) {
                player.field_71068_ca = 0;
                player.field_71106_cc = 0.0f;
                player.field_71067_cb = 0;
            }
            player.field_71106_cc /= (float)player.func_71050_bK();
        }
    }
}

