/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.modules;

import c4.corpsecomplex.common.Module;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HungerModule
extends Module {
    private static boolean keepFood;
    private static int minFood;
    private static int maxFood;
    private static boolean cfgEnabled;
    private static boolean keepSaturation;

    @SubscribeEvent
    public void onPlayerRespawnBegin(PlayerEvent.Clone e) {
        if (!e.isWasDeath() || e.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        HungerModule.restoreHunger(e.getEntityPlayer(), e.getOriginal());
    }

    public HungerModule() {
        super("Hunger", "Customize hunger and saturation values on respawn");
    }

    @Override
    public void loadModuleConfig() {
        this.setCategoryComment();
        cfgEnabled = this.getBool("Enable Hunger Module", false, "Set to true to enable hunger module", false);
        keepFood = this.getBool("Keep Food Level", false, "Set to true to retain food level on death", false);
        minFood = this.getInt("Minimum Food Level", 6, 0, 20, "Lowest amount of food level you can respawn with", false);
        maxFood = this.getInt("Maximum Food Level", 20, minFood, 20, "Highest amount of food level you can respawn with", false);
        keepSaturation = this.getBool("Keep Saturation", false, "Set to true to retain saturation on death", false);
    }

    @Override
    public void initPropOrder() {
        this.propOrder = new ArrayList<String>(Arrays.asList("Enable Hunger Module", "Keep Food Level", "Maximum Food Level", "Minimum Food Level"));
    }

    @Override
    public void setEnabled() {
        this.enabled = cfgEnabled;
    }

    private static void restoreHunger(EntityPlayer player, EntityPlayer oldPlayer) {
        int oldFood = oldPlayer.func_71024_bL().func_75116_a();
        if (keepFood) {
            player.func_71024_bL().func_75114_a(Math.max(minFood, Math.min(maxFood, oldFood)));
        } else {
            player.func_71024_bL().func_75114_a(Math.max(minFood, Math.min(maxFood, 20)));
        }
        if (keepSaturation) {
            player.func_71024_bL().func_75119_b(oldPlayer.func_71024_bL().func_75115_e());
        }
    }
}

