/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.modules.compatibility.baubles;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import c4.corpsecomplex.CorpseComplex;
import c4.corpsecomplex.common.modules.compatibility.baubles.BaublesModule;
import c4.corpsecomplex.common.modules.inventory.capability.IDeathInventory;
import c4.corpsecomplex.common.modules.inventory.helpers.DeathStackHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BaublesHandler
extends DeathStackHandler {
    private static final String MOD_ID = "baubles";
    private IBaublesItemHandler playerBaubles;

    public BaublesHandler(EntityPlayer player) {
        super(player, MOD_ID);
        this.playerBaubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        this.setSize(this.playerBaubles.getSlots());
    }

    @Override
    public boolean checkToStore(int slot) {
        return BaublesModule.keepBaubles;
    }

    @Override
    public ItemStack getStackInSlot(int index) {
        return this.playerBaubles.getStackInSlot(index);
    }

    @Override
    public void retrieveInventory(IDeathInventory oldDeathInventory) {
        NBTTagCompound nbt = oldDeathInventory.getStorage(MOD_ID);
        if (nbt == null) {
            return;
        }
        this.storage.deserializeNBT(nbt);
        for (int slot = 0; slot < this.storage.getSlots(); ++slot) {
            ItemStack stack = this.storage.getStackInSlot(slot);
            if (CorpseComplex.isStackEmpty(stack)) continue;
            this.playerBaubles.setStackInSlot(slot, stack);
        }
    }
}

