/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.modules.compatibility.rpginventory;

import c4.corpsecomplex.CorpseComplex;
import c4.corpsecomplex.common.modules.compatibility.rpginventory.RPGModule;
import c4.corpsecomplex.common.modules.inventory.capability.IDeathInventory;
import c4.corpsecomplex.common.modules.inventory.helpers.DeathStackHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import subaraki.rpginventory.capability.playerinventory.RpgInventoryCapability;
import subaraki.rpginventory.capability.playerinventory.RpgPlayerInventory;
import subaraki.rpginventory.capability.playerinventory.RpgStackHandler;

public class RPGHandler
extends DeathStackHandler {
    private static final String MOD_ID = "rpginventory";
    private RpgStackHandler rpgItems;

    public RPGHandler(EntityPlayer player) {
        super(player, MOD_ID);
        RpgPlayerInventory inventory = (RpgPlayerInventory)player.getCapability(RpgInventoryCapability.CAPABILITY, null);
        this.rpgItems = inventory.getTheRpgInventory();
        this.setSize(this.rpgItems.getSlots());
    }

    @Override
    public boolean checkToStore(int slot) {
        return RPGModule.keepRPG;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return this.rpgItems.getStackInSlot(slot);
    }

    @Override
    public void retrieveInventory(IDeathInventory oldDeathInventory) {
        NBTTagCompound nbt = oldDeathInventory.getStorage(MOD_ID);
        if (nbt == null) {
            return;
        }
        this.storage.deserializeNBT(nbt);
        for (int slot = 0; slot < this.storage.getSlots(); ++slot) {
            ItemStack stack = this.storage.getStackInSlot(slot);
            if (CorpseComplex.isStackEmpty(stack)) continue;
            this.rpgItems.setStackInSlot(slot, stack);
        }
    }
}

