/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.modules.compatibility.toughasnails;

import c4.corpsecomplex.common.Module;
import c4.corpsecomplex.network.NetworkHandler;
import c4.corpsecomplex.network.TANMessage;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import toughasnails.api.temperature.Temperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.thirst.ThirstHelper;

public class TANModule
extends Module {
    private static final String MOD_ID = "ToughAsNails";
    private static boolean keepThirst;
    private static boolean keepHydration;
    private static boolean keepTemperature;
    private static int minThirst;
    private static int maxThirst;
    private static boolean cfgEnabled;

    @SubscribeEvent
    @Optional.Method(modid="ToughAsNails")
    public void onPlayerRespawnBegin(PlayerEvent.Clone e) {
        if (!e.isWasDeath() || e.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = e.getEntityPlayer();
        EntityPlayer oldPlayer = e.getOriginal();
        TANModule.restoreStats(player, oldPlayer);
    }

    @SubscribeEvent
    @Optional.Method(modid="ToughAsNails")
    public void onPlayerRespawnFinish(PlayerEvent.PlayerRespawnEvent e) {
        TANModule.updateClientTAN(e.player);
    }

    @SubscribeEvent
    @Optional.Method(modid="ToughAsNails")
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent e) {
        TANModule.updateClientTAN(e.player);
    }

    @SubscribeEvent
    @Optional.Method(modid="ToughAsNails")
    public void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent e) {
        TANModule.updateClientTAN(e.player);
    }

    public TANModule() {
        super("Tough as Nails", "Customize keeping Tough as Nails attributes on respawn");
    }

    @Override
    public void loadModuleConfig() {
        this.setCategoryComment();
        cfgEnabled = this.getBool("Enable TAN Module", false, "Set to true to enable Tough as Nails module", false);
        keepThirst = this.getBool("Keep Thirst Level", false, "Set to true to retain thirst level on respawn", false);
        keepHydration = this.getBool("Keep Hydration Level", false, "Set to true to retain hydration level on respawn", false);
        keepTemperature = this.getBool("Keep Temperature Level", false, "Set to true to retain temperature level on respawn", false);
        minThirst = this.getInt("Minimum Thirst Level", 6, 0, 20, "Lowest amount of thirst you can respawn with", false);
        maxThirst = this.getInt("Maximum Thirst Level", 20, minThirst, 20, "Maximum amount of thirst you can respawn with", false);
    }

    @Override
    public void initPropOrder() {
        this.propOrder = new ArrayList<String>(Collections.singletonList("Enable TAN Module"));
    }

    @Override
    public void setEnabled() {
        this.enabled = cfgEnabled;
    }

    @Optional.Method(modid="ToughAsNails")
    private static void restoreStats(EntityPlayer player, EntityPlayer oldPlayer) {
        int thirst = ThirstHelper.getThirstData((EntityPlayer)oldPlayer).getThirst();
        int temp = TemperatureHelper.getTemperatureData((EntityPlayer)oldPlayer).getTemperature().getRawValue();
        float hydration = ThirstHelper.getThirstData((EntityPlayer)oldPlayer).getHydration();
        if (keepThirst) {
            TANModule.restoreThirst(player, thirst);
        } else {
            TANModule.restoreThirst(player, 20);
        }
        if (keepHydration) {
            TANModule.restoreHydration(player, hydration);
        }
        if (keepTemperature) {
            TANModule.restoreTemperature(player, temp);
        }
    }

    @Optional.Method(modid="ToughAsNails")
    private static void updateClientTAN(EntityPlayer player) {
        int thirst = ThirstHelper.getThirstData((EntityPlayer)player).getThirst();
        int temp = TemperatureHelper.getTemperatureData((EntityPlayer)player).getTemperature().getRawValue();
        NetworkHandler.INSTANCE.sendTo((IMessage)new TANMessage(thirst, temp), (EntityPlayerMP)player);
    }

    @Optional.Method(modid="ToughAsNails")
    private static void restoreThirst(EntityPlayer player, int thirst) {
        ThirstHelper.getThirstData((EntityPlayer)player).setThirst(Math.max(minThirst, Math.min(maxThirst, thirst)));
    }

    @Optional.Method(modid="ToughAsNails")
    private static void restoreHydration(EntityPlayer player, float hydration) {
        ThirstHelper.getThirstData((EntityPlayer)player).setHydration(hydration);
    }

    @Optional.Method(modid="ToughAsNails")
    private static void restoreTemperature(EntityPlayer player, int temp) {
        TemperatureHelper.getTemperatureData((EntityPlayer)player).setTemperature(new Temperature(temp));
    }
}

