/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.modules.compatibility.wearablebackpacks;

import c4.corpsecomplex.CorpseComplex;
import c4.corpsecomplex.common.modules.compatibility.wearablebackpacks.WBModule;
import c4.corpsecomplex.common.modules.inventory.InventoryModule;
import c4.corpsecomplex.common.modules.inventory.capability.IDeathInventory;
import c4.corpsecomplex.common.modules.inventory.enchantment.EnchantmentModule;
import c4.corpsecomplex.common.modules.inventory.helpers.DeathInventoryHandler;
import c4.corpsecomplex.common.modules.inventory.helpers.DeathStackHelper;
import java.util.Random;
import net.mcft.copy.backpacks.api.BackpackHelper;
import net.mcft.copy.backpacks.api.IBackpack;
import net.mcft.copy.backpacks.misc.BackpackCapability;
import net.mcft.copy.backpacks.misc.util.NbtUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class WBHandler
extends DeathInventoryHandler {
    private static final String MOD_ID = "wearablebackpacks";
    private IBackpack playerBackpack;

    public WBHandler(EntityPlayer player) {
        super(player, MOD_ID);
        this.playerBackpack = (IBackpack)player.getCapability(BackpackCapability.CAPABILITY, null);
    }

    @Override
    public boolean checkToStore(int slot) {
        return WBModule.keepBackpack;
    }

    @Override
    public void storeInventory() {
        int level;
        boolean store;
        if (this.playerBackpack == null) {
            return;
        }
        ItemStack stack = BackpackHelper.equipAsChestArmor ? this.player.func_184582_a(EntityEquipmentSlot.CHEST) : this.playerBackpack.getStack();
        if (CorpseComplex.isStackEmpty(stack)) {
            return;
        }
        Random generator = new Random();
        boolean essential = DeathStackHelper.isEssential(stack);
        boolean cursed = !essential && DeathStackHelper.isCursed(stack);
        boolean bl = store = this.checkToStore(0) && !cursed || essential;
        if (!store && EnchantmentModule.registerEnchant && (level = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentModule.soulbound, (ItemStack)stack)) != 0) {
            store = essential = DeathStackHelper.handleSoulbound(stack, level);
            boolean bl2 = cursed = !essential && cursed;
        }
        if (cursed && InventoryModule.destroyCursed) {
            BackpackHelper.setEquippedBackpack((EntityLivingBase)this.player, null, null);
            return;
        }
        if ((InventoryModule.dropLoss > 0.0 || InventoryModule.keptLoss > 0.0) && (!BackpackHelper.equipAsChestArmor || store)) {
            DeathStackHelper.loseDurability(this.player, stack, store);
        }
        if (CorpseComplex.isStackEmpty(stack)) {
            return;
        }
        if (store) {
            if (!essential && generator.nextDouble() < InventoryModule.randomDrop) {
                if (generator.nextDouble() < InventoryModule.randomDestroy) {
                    BackpackHelper.setEquippedBackpack((EntityLivingBase)this.player, null, null);
                    return;
                }
                return;
            }
            NBTTagCompound storage = (NBTTagCompound)BackpackCapability.CAPABILITY.writeNBT((Object)this.playerBackpack, null);
            if (storage != null && BackpackHelper.equipAsChestArmor) {
                NBTTagCompound compound = NbtUtils.writeItem((ItemStack)stack);
                storage.func_74782_a("stack", (NBTBase)compound);
            }
            this.deathInventory.addStorage(this.modid, storage);
            BackpackHelper.setEquippedBackpack((EntityLivingBase)this.player, null, null);
        }
    }

    @Override
    public void retrieveInventory(IDeathInventory oldDeathInventory) {
        NBTTagCompound storage = oldDeathInventory.getStorage(MOD_ID);
        if (storage == null || this.playerBackpack == null) {
            return;
        }
        BackpackCapability.CAPABILITY.readNBT((Object)this.playerBackpack, null, (NBTBase)storage);
    }
}

