/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.modules.effects;

import c4.corpsecomplex.common.Module;
import c4.corpsecomplex.common.Submodule;
import c4.corpsecomplex.common.modules.effects.MoriPotion;
import com.pam.harvestcraft.blocks.blocks.BlockPamCake;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class MoriModule
extends Submodule {
    public static boolean registerPotion;
    public static MoriPotion moriPotion;
    static double modHealth;
    static double modArmor;
    static double modToughness;
    static double modMove;
    static double modDamage;
    static double modSpeed;
    static boolean doRecover;
    static int duration;
    private static boolean noFood;
    private static boolean noXP;
    private static String[] curativeItems;
    private static ArrayList<ItemStack> cureList;
    private static boolean cfgEnabled;

    @SubscribeEvent
    public void onPlayerRespawnFinish(PlayerEvent.PlayerRespawnEvent e) {
        if (e.player.field_70170_p.field_72995_K) {
            return;
        }
        PotionEffect moriEffect = new PotionEffect((Potion)moriPotion, duration * 20, 0, false, true);
        moriEffect.setCurativeItems(cureList);
        e.player.func_70690_d(moriEffect);
    }

    @SubscribeEvent
    public void onPlayerXPPickUp(PlayerPickupXpEvent e) {
        if (!noXP) {
            return;
        }
        if (e.getEntityPlayer().func_70644_a((Potion)moriPotion)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEatingFood(PlayerInteractEvent.RightClickItem e) {
        if (!noFood) {
            return;
        }
        if (e.getEntityPlayer().func_70644_a((Potion)moriPotion) && e.getItemStack().func_77975_n() == EnumAction.EAT) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEatingCake(PlayerInteractEvent.RightClickBlock e) {
        if (!noFood || !e.getEntityPlayer().func_70644_a((Potion)moriPotion)) {
            return;
        }
        if (e.getWorld().func_180495_p(e.getPos()).func_177230_c() == Blocks.field_150414_aQ) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    @Optional.Method(modid="harvestcraft")
    public void onEatingPamCake(PlayerInteractEvent.RightClickBlock e) {
        if (!noFood || !e.getEntityPlayer().func_70644_a((Potion)moriPotion)) {
            return;
        }
        if (e.getWorld().func_180495_p(e.getPos()).func_177230_c() instanceof BlockPamCake) {
            e.setCanceled(true);
        }
    }

    public MoriModule(Module parentModule) {
        super(parentModule, "Custom Respawn Effect");
        this.configCategory.setComment("Customize your own respawn effect for modifying player attributes");
    }

    @Override
    public void loadModuleConfig() {
        this.setCategoryComment();
        cfgEnabled = this.getBool("Enable Custom Respawn Effect", false, "Set to true to enable custom effect applied on respawn", true);
        modHealth = this.getDouble("Maximum Health Modifier", 0.0, -1024.0f, 1024.0f, "Set maximum health modifier", false);
        modMove = this.getDouble("Movement Speed Percent Modifier", 0.0, -1.0f, 1.0f, "Set movement speed percent modifier", false);
        modDamage = this.getDouble("Attack Damage Modifier", 0.0, -2048.0f, 2048.0f, "Set attack damage modifier", false);
        modSpeed = this.getDouble("Attack Speed Percent Modifier", 0.0, -1.0f, 1.0f, "Set attack speed percent modifier", false);
        doRecover = this.getBool("Gradual Recovery", false, "Set to true to enable gradual recovery (modifiers will diminish gradually as the effect goes on)", false);
        duration = this.getInt("Duration", 0, 0, 1600, "Set duration (seconds) for the effect", false);
        noFood = this.getBool("Cannot Eat Food", false, "Set to true to disable eating food while effect is active", false);
        noXP = this.getBool("Cannot Gain XP", false, "Set to true to disable gaining experience while effect is active", false);
        curativeItems = this.getStringList("Curative Items", new String[]{"minecraft:milk_bucket"}, "List of items that can cure the effect", false);
        moriPotion.setModifiers();
        MoriModule.initCureList();
    }

    private static void initCureList() {
        cureList = new ArrayList();
        for (String s : curativeItems) {
            Item item = Item.func_111206_d((String)s);
            if (item == null) continue;
            cureList.add(new ItemStack(item));
        }
    }

    @Override
    public void setEnabled() {
        registerPotion = cfgEnabled && this.parentModule.enabled;
        this.enabled = registerPotion;
    }

    @Override
    public void initPropOrder() {
        this.propOrder = new ArrayList<String>(Arrays.asList("Enable Custom Respawn Effect", "Duration", "Curative Items", "Gradual Recovery", "Maximum Health Modifier", "Armor Modifier", "Armor Toughness Modifier", "Attack Damage Modifier", "Attack Speed Percent Modifier", "Movement Speed Percent Modifier"));
    }

    @Override
    public boolean hasEvents() {
        return true;
    }

    static {
        moriPotion = new MoriPotion();
    }
}

