/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.modules.inventory;

import c4.corpsecomplex.CorpseComplex;
import c4.corpsecomplex.common.Module;
import c4.corpsecomplex.common.Submodule;
import c4.corpsecomplex.common.modules.compatibility.advinv.AdvHandler;
import c4.corpsecomplex.common.modules.compatibility.advinv.AdvModule;
import c4.corpsecomplex.common.modules.compatibility.baubles.BaublesHandler;
import c4.corpsecomplex.common.modules.compatibility.baubles.BaublesModule;
import c4.corpsecomplex.common.modules.compatibility.cosmeticarmorreworked.CosmeticHandler;
import c4.corpsecomplex.common.modules.compatibility.cosmeticarmorreworked.CosmeticModule;
import c4.corpsecomplex.common.modules.compatibility.powerinventory.OPHandler;
import c4.corpsecomplex.common.modules.compatibility.powerinventory.OPModule;
import c4.corpsecomplex.common.modules.compatibility.rpginventory.RPGHandler;
import c4.corpsecomplex.common.modules.compatibility.rpginventory.RPGModule;
import c4.corpsecomplex.common.modules.compatibility.thut_wearables.ThutHandler;
import c4.corpsecomplex.common.modules.compatibility.thut_wearables.ThutModule;
import c4.corpsecomplex.common.modules.compatibility.wearablebackpacks.WBHandler;
import c4.corpsecomplex.common.modules.compatibility.wearablebackpacks.WBModule;
import c4.corpsecomplex.common.modules.inventory.InventoryHandler;
import c4.corpsecomplex.common.modules.inventory.capability.DeathInventory;
import c4.corpsecomplex.common.modules.inventory.capability.IDeathInventory;
import c4.corpsecomplex.common.modules.inventory.enchantment.EnchantmentModule;
import c4.corpsecomplex.common.modules.inventory.helpers.DeathInventoryHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;

public class InventoryModule
extends Module {
    public static ArrayList<Class<? extends DeathInventoryHandler>> handlerClasses;
    public static boolean destroyCursed;
    public static double randomDrop;
    public static String[] essentialItems;
    public static String[] cursedItems;
    public static double randomDestroy;
    public static double dropLoss;
    public static double keptLoss;
    public static double dropDrain;
    public static double keptDrain;
    static boolean keepArmor;
    static boolean keepHotbar;
    static boolean keepMainhand;
    static boolean keepOffhand;
    static boolean keepMainInventory;
    private static boolean cfgEnabled;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void storeDeathInventory(LivingDeathEvent e) {
        if (!(e.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)e.getEntityLiving();
        if (!player.field_70170_p.func_82736_K().func_82766_b("keepInventory") && !player.field_70170_p.field_72995_K) {
            this.storeInventories(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDrop(PlayerDropsEvent e) {
        EntityPlayer player = e.getEntityPlayer();
        if (!player.field_70170_p.func_82736_K().func_82766_b("keepInventory") && !player.field_70170_p.field_72995_K) {
            this.retrieveInventories(player);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawnBegin(PlayerEvent.Clone e) {
        if (!e.isWasDeath() || e.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = e.getEntityPlayer();
        EntityPlayer oldPlayer = e.getOriginal();
        if (!player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            this.retrieveInventories(player, oldPlayer);
        }
    }

    public InventoryModule() {
        super("Inventory", "Customize how your inventory is handled on death and respawn");
        this.submoduleClasses = new ArrayList();
        handlerClasses = new ArrayList();
        this.addSubmodule(EnchantmentModule.class);
        this.addSubmodule("wearablebackpacks", WBModule.class, WBHandler.class);
        this.addSubmodule("thut_wearables", ThutModule.class, ThutHandler.class);
        this.addSubmodule("rpginventory", RPGModule.class, RPGHandler.class);
        this.addSubmodule("powerinventory", OPModule.class, OPHandler.class);
        this.addSubmodule("Baubles", BaublesModule.class, BaublesHandler.class);
        this.addSubmodule("cosmeticarmorreworked", CosmeticModule.class, CosmeticHandler.class);
        this.addSubmodule("advInv", AdvModule.class, AdvHandler.class);
        handlerClasses.add(InventoryHandler.class);
    }

    @Override
    public void loadModuleConfig() {
        this.setCategoryComment();
        cfgEnabled = this.getBool("Enable Inventory Module", false, "Set to true to enable inventory module", false);
        keepArmor = this.getBool("Keep Armor", false, "Set to true to keep equipped armor on death", false);
        keepHotbar = this.getBool("Keep Hotbar", false, "Set to true to keep hotbar items on death", false);
        keepMainhand = this.getBool("Keep Mainhand", false, "Set to true to keep mainhand item on death", false);
        keepOffhand = this.getBool("Keep Offhand", false, "Set to true to keep offhand item on death", false);
        keepMainInventory = this.getBool("Keep Main Inventory", false, "Set to true to keep main inventory (non-equipped non-hotbar) items on death", false);
        destroyCursed = this.getBool("Destroy Cursed Items", false, "Set to true to destroy cursed items instead of dropping them", false);
        randomDrop = this.getDouble("Random Drop Chance", 0.0, 0.0f, 1.0f, "Percent chance that items that are kept will still drop", false);
        randomDestroy = this.getDouble("Random Destroy Chance", 0.0, 0.0f, 1.0f, "Percent chance that dropped items will be destroyed", false);
        essentialItems = this.getStringList("Essential Items", new String[0], "List of items that are always kept", false);
        cursedItems = this.getStringList("Cursed Items", new String[0], "List of items that are always dropped", false);
        dropLoss = this.getDouble("Durability Loss on Drops", 0.0, 0.0f, 1.0f, "Percent of durability lost on death for drops", false);
        keptLoss = this.getDouble("Durability Loss on Kept Items", 0.0, 0.0f, 1.0f, "Percent of durability lost on death for kept items", false);
        dropDrain = this.getDouble("Energy Drain on Drops", 0.0, 0.0f, 1.0f, "Percent of energy drained on death for drops", false);
        keptDrain = this.getDouble("Energy Drain on Kept Items", 0.0, 0.0f, 1.0f, "Percent of energy drained on death for kept items", false);
    }

    @Override
    public void initPropOrder() {
        this.propOrder = new ArrayList<String>(Arrays.asList("Enable Inventory Module", "Keep Armor", "Keep Hotbar", "Keep Mainhand", "Keep Offhand", "Keep Main Inventory", "Durability Loss on Drops", "Durability Loss on Kept Items", "Energy Drain on Drops", "Energy Drain on Kept Items", "Random Drop Chance", "Random Destroy Chance", "Essential Items", "Cursed Items", "Destroy Cursed Items"));
    }

    @Override
    public void setEnabled() {
        this.enabled = cfgEnabled;
    }

    private void storeInventories(EntityPlayer player) {
        handlerClasses.forEach((Consumer<Class<? extends DeathInventoryHandler>>)((Consumer<Class>)handler -> {
            try {
                ((DeathInventoryHandler)handler.getDeclaredConstructor(EntityPlayer.class).newInstance(player)).storeInventory();
            }
            catch (Exception e1) {
                CorpseComplex.logger.log(Level.ERROR, "Failed to initialize handler " + handler, (Throwable)e1);
            }
        }));
    }

    private void retrieveInventories(EntityPlayer player) {
        this.retrieveInventories(player, player);
    }

    private void retrieveInventories(EntityPlayer player, EntityPlayer oldPlayer) {
        IDeathInventory oldDeathInventory = (IDeathInventory)oldPlayer.getCapability(DeathInventory.Provider.DEATH_INV_CAP, null);
        handlerClasses.forEach((Consumer<Class<? extends DeathInventoryHandler>>)((Consumer<Class>)handler -> {
            try {
                ((DeathInventoryHandler)handler.getDeclaredConstructor(EntityPlayer.class).newInstance(player)).retrieveInventory(oldDeathInventory);
            }
            catch (Exception e1) {
                CorpseComplex.logger.log(Level.ERROR, "Failed to initialize handler " + handler, (Throwable)e1);
            }
        }));
    }

    private void addSubmodule(String modid, Class<? extends Submodule> submodule, Class<? extends DeathInventoryHandler> handler) {
        if (Loader.isModLoaded((String)modid) && !this.submoduleClasses.contains(submodule)) {
            this.submoduleClasses.add(submodule);
            if (!handlerClasses.contains(handler)) {
                handlerClasses.add(handler);
            }
        }
    }
}

