/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.modules.inventory.helpers;

import c4.corpsecomplex.CorpseComplex;
import c4.corpsecomplex.common.modules.inventory.InventoryModule;
import c4.corpsecomplex.common.modules.inventory.enchantment.EnchantmentModule;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public final class DeathStackHelper {
    private static Random generator = new Random();

    private DeathStackHelper() {
    }

    public static ItemStack stackToStore(EntityPlayer player, ItemStack stack, boolean cfgStore) {
        int level;
        boolean store;
        boolean essential = DeathStackHelper.isEssential(stack);
        boolean cursed = !essential && DeathStackHelper.isCursed(stack);
        boolean bl = store = cfgStore && !cursed || essential;
        if (!store && EnchantmentModule.registerEnchant && (level = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentModule.soulbound, (ItemStack)stack)) != 0) {
            store = essential = DeathStackHelper.handleSoulbound(stack, level);
            boolean bl2 = cursed = !essential && cursed;
        }
        if (cursed && InventoryModule.destroyCursed) {
            DeathStackHelper.destroyStack(stack);
            return stack;
        }
        if (InventoryModule.dropLoss > 0.0 || InventoryModule.keptLoss > 0.0) {
            DeathStackHelper.loseDurability(player, stack, store);
        }
        if (InventoryModule.dropDrain > 0.0 || InventoryModule.keptDrain > 0.0) {
            DeathStackHelper.loseEnergy(stack, store);
        }
        if (CorpseComplex.isStackEmpty(stack)) {
            return null;
        }
        if (store) {
            if (!essential && InventoryModule.randomDrop > 0.0) {
                int keepAmount = stack.field_77994_a;
                return stack.func_77979_a(keepAmount -= DeathStackHelper.randomlyDrop(stack));
            }
            ItemStack stack1 = stack.func_77946_l();
            stack.field_77994_a = 0;
            return stack1;
        }
        return null;
    }

    public static void destroyStack(ItemStack stack) {
        stack.field_77994_a = 0;
    }

    public static int randomlyDrop(ItemStack stack) {
        int dropAmount = 0;
        for (int i = 0; i < stack.field_77994_a; ++i) {
            if (!(generator.nextDouble() < InventoryModule.randomDrop)) continue;
            ++dropAmount;
        }
        return dropAmount;
    }

    public static void randomlyDestroy(ItemStack stack) {
        int destroyAmount = 0;
        for (int i = 0; i < stack.field_77994_a; ++i) {
            if (!(generator.nextDouble() < InventoryModule.randomDestroy)) continue;
            ++destroyAmount;
        }
        stack.field_77994_a -= destroyAmount;
    }

    public static void loseDurability(EntityPlayer player, ItemStack stack, boolean store) {
        if (!stack.func_77984_f()) {
            return;
        }
        if (store) {
            stack.func_77972_a((int)Math.round((double)stack.func_77958_k() * InventoryModule.keptLoss), (EntityLivingBase)player);
        } else {
            stack.func_77972_a((int)Math.round((double)stack.func_77958_k() * InventoryModule.dropLoss), (EntityLivingBase)player);
        }
    }

    public static void loseEnergy(ItemStack stack, boolean store) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energy == null) {
            return;
        }
        for (int energyToLose = store ? (int)Math.round((double)energy.getMaxEnergyStored() * InventoryModule.keptDrain) : (int)Math.round((double)energy.getMaxEnergyStored() * InventoryModule.dropDrain); energyToLose > 0 && energy.getEnergyStored() > 0; energyToLose -= energy.extractEnergy(energyToLose, false)) {
        }
    }

    public static boolean isEssential(ItemStack stack) {
        for (String s : InventoryModule.essentialItems) {
            ResourceLocation name = stack.func_77973_b().getRegistryName();
            if (name == null || !s.equals(name.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isCursed(ItemStack stack) {
        for (String s : InventoryModule.cursedItems) {
            ResourceLocation name = stack.func_77973_b().getRegistryName();
            if (name == null || !s.equals(name.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean handleSoulbound(ItemStack stack, int level) {
        double savePercent = EnchantmentModule.baseSave + EnchantmentModule.extraPerLevel * (double)(level - 1);
        boolean activated = false;
        if (generator.nextDouble() < savePercent) {
            activated = true;
        }
        if (EnchantmentModule.levelDrop != 0.0 && activated) {
            if (generator.nextDouble() < EnchantmentModule.levelDrop) {
                level = Math.max(0, level - 1);
            }
            Map enchMap = EnchantmentHelper.func_82781_a((ItemStack)stack);
            enchMap.remove((Object)EnchantmentModule.soulbound);
            if (level > 0) {
                enchMap.put(EnchantmentModule.soulbound, level);
            }
            EnchantmentHelper.func_82782_a((Map)enchMap, (ItemStack)stack);
        }
        return activated;
    }
}

