/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.modules.compatibility.thebetweenlands;

import c4.corpsecomplex.common.modules.compatibility.thebetweenlands.BetweenlandsModule;
import c4.corpsecomplex.common.modules.inventory.InventoryModule;
import c4.corpsecomplex.common.modules.inventory.capability.IDeathInventory;
import c4.corpsecomplex.common.modules.inventory.enchantment.EnchantmentModule;
import c4.corpsecomplex.common.modules.inventory.helpers.DeathInventoryHandler;
import c4.corpsecomplex.common.modules.inventory.helpers.DeathStackHelper;
import java.util.EnumMap;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.registries.CapabilityRegistry;

public class BetweenlandsHandler
extends DeathInventoryHandler {
    private static final String MOD_ID = "thebetweenlands";
    private IEquipmentCapability betweenlandsEquipment;

    public BetweenlandsHandler(EntityPlayer player) {
        super(player, MOD_ID);
        this.betweenlandsEquipment = (IEquipmentCapability)player.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
    }

    @Override
    public boolean checkToStore(int slot) {
        return BetweenlandsModule.keepBetweenlands;
    }

    @Override
    public void storeInventory() {
        EnumMap<EnumEquipmentInventory, IInventory> inventories = new EnumMap<EnumEquipmentInventory, IInventory>(EnumEquipmentInventory.class);
        if (this.betweenlandsEquipment == null) {
            return;
        }
        EnumEquipmentInventory.VALUES.forEach(value -> inventories.put((EnumEquipmentInventory)value, this.betweenlandsEquipment.getInventory(value)));
        Random generator = new Random();
        NBTTagCompound compound = new NBTTagCompound();
        inventories.forEach((equipment, inventory) -> {
            String name = equipment.toString();
            NonNullList storedStacks = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                int level;
                boolean store;
                ItemStack stack = inventory.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                boolean essential = DeathStackHelper.isEssential(stack);
                boolean cursed = !essential && DeathStackHelper.isCursed(stack);
                boolean bl = store = this.checkToStore(0) && !cursed || essential;
                if (!store && EnchantmentModule.registerEnchant && (level = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentModule.soulbound, (ItemStack)stack)) != 0) {
                    store = essential = DeathStackHelper.handleSoulbound(stack, level);
                    boolean bl2 = cursed = !essential && cursed;
                }
                if (cursed && InventoryModule.destroyCursed) {
                    inventory.func_70299_a(i, ItemStack.field_190927_a);
                    continue;
                }
                if (InventoryModule.dropLoss > 0.0 || InventoryModule.keptLoss > 0.0) {
                    DeathStackHelper.loseDurability(this.player, stack, store);
                }
                if (stack.func_190926_b()) {
                    return;
                }
                if (!store) continue;
                if (!essential && generator.nextDouble() < InventoryModule.randomDrop) {
                    if (!(generator.nextDouble() < InventoryModule.randomDestroy)) continue;
                    inventory.func_70299_a(i, ItemStack.field_190927_a);
                    continue;
                }
                storedStacks.set(i, (Object)stack.func_77946_l());
                inventory.func_70299_a(i, ItemStack.field_190927_a);
            }
            NBTTagCompound tag = new NBTTagCompound();
            ItemStackHelper.func_191282_a((NBTTagCompound)tag, (NonNullList)storedStacks);
            compound.func_74782_a(name, (NBTBase)tag);
        });
        this.deathInventory.addStorage(MOD_ID, compound);
    }

    @Override
    public void retrieveInventory(IDeathInventory oldDeathInventory) {
        NBTTagCompound storage = oldDeathInventory.getStorage(MOD_ID);
        if (storage != null && this.betweenlandsEquipment != null) {
            EnumEquipmentInventory.VALUES.forEach(value -> {
                NBTTagCompound tag = storage.func_74775_l(value.toString());
                if (!tag.func_82582_d()) {
                    IInventory inventory = this.betweenlandsEquipment.getInventory(value);
                    NonNullList stored = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
                    ItemStackHelper.func_191283_b((NBTTagCompound)tag, (NonNullList)stored);
                    for (int i = 0; i < stored.size(); ++i) {
                        ItemStack stack = (ItemStack)stored.get(i);
                        if (stack.func_190926_b()) continue;
                        inventory.func_70299_a(i, stack);
                    }
                }
            });
        }
    }
}

