/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage;

import codechicken.lib.asm.ObfMapping;
import codechicken.lib.fingerprint.FingerprintViolatedCrashCallable;
import com.google.common.collect.ImmutableList;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.CertificateHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.logging.log4j.Level;

public class FingerprintChecker {
    private static final Map<String, String> modCertMap = new HashMap<String, String>();
    private static final List<String> invalidMods = new ArrayList<String>();

    public static void runFingerprintChecks() {
        try {
            ModContainer activeContainer = Loader.instance().activeModContainer();
            if (!ObfMapping.obfuscated) {
                FMLLog.log((String)(activeContainer.getModId() + " Fingerprint Verification"), (Level)Level.INFO, (String)"Development environment detected, Suppressing Invalid fingerprints..", (Object[])new Object[0]);
            }
            block2: for (Map.Entry modEntry : Loader.instance().getIndexedModList().entrySet()) {
                for (Map.Entry<String, String> certEntry : modCertMap.entrySet()) {
                    if (!((String)modEntry.getKey()).equals(certEntry.getKey())) continue;
                    Object modInstance = ((ModContainer)modEntry.getValue()).getMod();
                    if (modInstance == null) {
                        FMLLog.log((String)(activeContainer.getModId() + " Fingerprint Verification"), (Level)Level.FATAL, (String)"Unable to do Fingerprint Verification for mod %s! ModContainer returned a null mod instance!", (Object[])new Object[]{modEntry.getKey()});
                        continue block2;
                    }
                    if (modInstance.getClass().getName().contains("net.minecraftforge.")) {
                        FMLLog.log((String)(activeContainer.getModId() + " Fingerprint Verification"), (Level)Level.FATAL, (String)"Unable to do Fingerprint Verification for mod %s! ModContainer returned is a suspected FML class! [%s]", (Object[])new Object[]{modEntry.getKey(), modInstance.getClass().getName()});
                    }
                    Certificate[] certificates = modInstance.getClass().getProtectionDomain().getCodeSource().getCertificates();
                    ImmutableList.Builder certBuilder = ImmutableList.builder();
                    if (certificates != null) {
                        for (Certificate cert : certificates) {
                            certBuilder.add((Object)CertificateHelper.getFingerprint((Certificate)cert));
                        }
                    }
                    ImmutableList certList = certBuilder.build();
                    String expectedFingerprint = certEntry.getValue();
                    if (expectedFingerprint == null || expectedFingerprint.isEmpty()) continue block2;
                    if (!certList.contains((Object)expectedFingerprint)) {
                        Level level = ObfMapping.obfuscated ? Level.FATAL : Level.DEBUG;
                        FMLLog.log((String)(activeContainer.getModId() + " Fingerprint Verification"), (Level)level, (String)"The fingerprint for mod %s is invalid! Expected: %s", (Object[])new Object[]{modEntry.getKey(), expectedFingerprint});
                        invalidMods.add((String)modEntry.getKey());
                        continue block2;
                    }
                    FMLLog.log((String)(activeContainer.getModId() + " Fingerprint Verification"), (Level)Level.DEBUG, (String)"Valid fingerprint found for mod %s.", (Object[])new Object[]{modEntry.getKey()});
                    continue block2;
                }
            }
            FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)new FingerprintViolatedCrashCallable(activeContainer.getModId(), invalidMods));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        modCertMap.put("codechickenlib", "f1850c39b2516232a2108a7bd84d1cb5df93b261");
        modCertMap.put("chickenchunks", "f1850c39b2516232a2108a7bd84d1cb5df93b261");
        modCertMap.put("enderstorage", "f1850c39b2516232a2108a7bd84d1cb5df93b261");
        modCertMap.put("translocatr", "f1850c39b2516232a2108a7bd84d1cb5df93b261");
        modCertMap.put("nei", "f1850c39b2516232a2108a7bd84d1cb5df93b261");
        modCertMap.put("forgemultipartcbe", "f1850c39b2516232a2108a7bd84d1cb5df93b261");
        modCertMap.put("wrcbe", "f1850c39b2516232a2108a7bd84d1cb5df93b261");
    }
}

