/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.api;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.util.Copyable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;

public final class Frequency
implements Copyable<Frequency> {
    public int left;
    public int middle;
    public int right;
    public String owner;

    public Frequency() {
        this(0, 0, 0, null);
    }

    public Frequency(int left, int middle, int right, String owner) {
        this.left = left;
        this.middle = middle;
        this.right = right;
        this.owner = owner;
    }

    public Frequency(int left, int middle, int right) {
        this(left, middle, right, null);
    }

    public Frequency(EnumColour left, EnumColour middle, EnumColour right, String owner) {
        this(left.ordinal(), middle.ordinal(), right.ordinal(), owner);
    }

    public Frequency(EnumColour left, EnumColour middle, EnumColour right) {
        this(left, middle, right, null);
    }

    public static Frequency fromString(String left, String middle, String right, String owner) {
        EnumColour c1 = EnumColour.fromName((String)left);
        EnumColour c2 = EnumColour.fromName((String)middle);
        EnumColour c3 = EnumColour.fromName((String)right);
        if (c1 == null) {
            throw new RuntimeException(left + " is an invalid colour!");
        }
        if (c2 == null) {
            throw new RuntimeException(middle + " is an invalid colour!");
        }
        if (c3 == null) {
            throw new RuntimeException(right + " is an invalid colour!");
        }
        return new Frequency(c1, c2, c3, owner);
    }

    public static Frequency fromString(String left, String middle, String right) {
        return Frequency.fromString(left, middle, right, null);
    }

    public Frequency setLeft(int left) {
        this.left = left;
        return this;
    }

    public Frequency setMiddle(int middle) {
        this.middle = middle;
        return this;
    }

    public Frequency setRight(int right) {
        this.right = right;
        return this;
    }

    public Frequency setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public static Frequency fromArray(int[] colours) {
        Frequency frequency = new Frequency();
        frequency.setLeft(colours[0]);
        frequency.setMiddle(colours[1]);
        frequency.setRight(colours[2]);
        return frequency;
    }

    public Frequency setFrequency(int left, int middle, int right) {
        this.setLeft(left);
        this.setMiddle(middle);
        this.setRight(right);
        return this;
    }

    public Frequency setFrequency(Frequency frequency) {
        this.setLeft(frequency.left);
        this.setMiddle(frequency.middle);
        this.setRight(frequency.right);
        this.setOwner(frequency.owner);
        return this;
    }

    public String getLeft() {
        return EnumColour.values()[this.left].getMinecraftName();
    }

    public String getMiddle() {
        return EnumColour.values()[this.middle].getMinecraftName();
    }

    public String getRight() {
        return EnumColour.values()[this.right].getMinecraftName();
    }

    public EnumColour getLeftRaw() {
        return EnumColour.values()[this.left];
    }

    public EnumColour getMiddleRaw() {
        return EnumColour.values()[this.middle];
    }

    public EnumColour getRightRaw() {
        return EnumColour.values()[this.right];
    }

    public String getLocalizedLeft() {
        return I18n.func_74838_a((String)this.getLeftRaw().getUnlocalizedName());
    }

    public String getLocalizedMiddle() {
        return I18n.func_74838_a((String)this.getMiddleRaw().getUnlocalizedName());
    }

    public String getLocalizedRight() {
        return I18n.func_74838_a((String)this.getRightRaw().getUnlocalizedName());
    }

    public String[] getColours() {
        return new String[]{this.getLeft(), this.getMiddle(), this.getRight()};
    }

    public int[] toArray() {
        return new int[]{this.left, this.middle, this.right};
    }

    public Frequency readNBT(NBTTagCompound tagCompound) {
        this.left = tagCompound.func_74762_e("left");
        this.middle = tagCompound.func_74762_e("middle");
        this.right = tagCompound.func_74762_e("right");
        if (tagCompound.func_74764_b("owner")) {
            this.owner = tagCompound.func_74779_i("owner");
        }
        return this;
    }

    public Frequency writeNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("left", this.left);
        tagCompound.func_74768_a("middle", this.middle);
        tagCompound.func_74768_a("right", this.right);
        if (this.owner != null) {
            tagCompound.func_74778_a("owner", this.owner);
        }
        return this;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.writeNBT(tagCompound);
        return tagCompound;
    }

    public static Frequency fromNBT(NBTTagCompound tagCompound) {
        NBTTagCompound frequencyTag = tagCompound;
        if (tagCompound.func_74764_b("Frequency")) {
            frequencyTag = tagCompound.func_74775_l("Frequency");
        }
        return new Frequency().readNBT(frequencyTag);
    }

    public static Frequency fromItemStack(ItemStack stack) {
        Frequency frequency = new Frequency();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Frequency")) {
            NBTTagCompound tagCompound = stack.func_77978_p().func_74775_l("Frequency");
            frequency.setFrequency(Frequency.fromNBT(tagCompound));
        }
        return frequency;
    }

    public static ItemStack toItemStack(ItemStack stack, Frequency frequency) {
        return frequency.toItemStack(stack);
    }

    public ItemStack toItemStack(ItemStack stack) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        if (stack.func_77942_o()) {
            tagCompound = stack.func_77978_p();
        }
        NBTTagCompound frequencyTag = new NBTTagCompound();
        this.writeNBT(frequencyTag);
        tagCompound.func_74782_a("Frequency", (NBTBase)frequencyTag);
        stack.func_77982_d(tagCompound);
        return stack;
    }

    public String toModelLoc() {
        return "left=" + this.getLeft() + ",middle=" + this.getMiddle() + ",right=" + this.getRight() + ",owned=" + this.hasOwner();
    }

    public String toString() {
        String owner = "";
        if (this.hasOwner()) {
            owner = ",owner=" + this.owner;
        }
        return "left=" + this.getLeft() + ",middle=" + this.getMiddle() + ",right=" + this.getRight() + owner;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Frequency copy() {
        return new Frequency(this.left, this.middle, this.right, this.owner);
    }
}

