/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage;

import codechicken.core.CommonUtils;
import codechicken.core.config.ConfigFile;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.common.BlockEnderStorage;
import codechicken.enderstorage.common.EnderStorageRecipe;
import codechicken.enderstorage.internal.EnderStorageProxy;
import codechicken.enderstorage.storage.EnderItemStoragePlugin;
import codechicken.enderstorage.storage.EnderLiquidStoragePlugin;
import codechicken.enderstorage.storage.item.ItemEnderPouch;
import codechicken.enderstorage.storage.liquid.TankSynchroniser;
import codechicken.packager.Packager;
import codechicken.packager.SrcPackager;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import java.io.File;
import net.minecraftforge.common.MinecraftForge;

@Packager(getBaseDirectories={"EnderStorage"})
@Mod(name="EnderStorage", version="1.4.2.5", useMetadata=false, modid="EnderStorage", acceptedMinecraftVersions="[1.5.2]")
@NetworkMod(clientSideRequired=true, serverSideRequired=true)
@SrcPackager
public class EnderStorage {
    @SidedProxy(clientSide="codechicken.enderstorage.internal.EnderStorageClientProxy", serverSide="codechicken.enderstorage.internal.EnderStorageProxy")
    public static EnderStorageProxy proxy;
    public static ConfigFile config;
    public static BlockEnderStorage blockEnderChest;
    public static ItemEnderPouch itemEnderPouch;
    private static int personalItemID;
    public static boolean disableVanillaEnderChest;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        config = new ConfigFile(new File(CommonUtils.getMinecraftDir() + "/config", "EnderStorage.cfg")).setComment("EnderStorage Configuration File:Deleting any element will restore it to it's default value:Block ID's will be automatically generated the first time it's run");
        MinecraftForge.EVENT_BUS.register((Object)new EnderStorageRecipe());
        MinecraftForge.EVENT_BUS.register((Object)new EnderStorageManager.EnderStorageSaveHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TankSynchroniser());
        proxy.preInit();
    }

    @Mod.Init
    public void initialize(FMLInitializationEvent event) {
        personalItemID = config.getTag("personalItemID").setComment("The ID of the item used to set the chest to personal. Diamond by default").getIntValue(wk.o.cp);
        disableVanillaEnderChest = config.getTag("disable-vanilla").setComment("Set to true to make the vanilla enderchest unplaceable.").getBooleanValue(true);
        EnderStorageManager.loadConfig(config);
        EnderStorageManager.registerPlugin(new EnderItemStoragePlugin());
        EnderStorageManager.registerPlugin(new EnderLiquidStoragePlugin());
        proxy.load();
    }

    public static wm getPersonalItem() {
        if (personalItemID < 0 || personalItemID >= wk.f.length || wk.f[personalItemID] == null) {
            System.err.println("EnderStorage: Invalid personal itemID, resetting");
            personalItemID = wk.o.cp;
            config.getTag("personalItemID").setIntValue(personalItemID);
        }
        return new wm(personalItemID, 1, 0);
    }
}

