/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage;

import codechicken.core.CommonUtils;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.common.BlockEnderStorage;
import codechicken.enderstorage.internal.EnderStorageProxy;
import codechicken.enderstorage.storage.EnderItemStoragePlugin;
import codechicken.enderstorage.storage.EnderLiquidStoragePlugin;
import codechicken.enderstorage.storage.item.CommandEnderStorage;
import codechicken.enderstorage.storage.item.ItemEnderPouch;
import codechicken.lib.config.ConfigFile;
import codechicken.lib.config.ConfigTag;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import java.io.File;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@Mod(modid="EnderStorage", dependencies="required-after:CodeChickenCore@[1.0.2,)", acceptedMinecraftVersions="[1.7.2]")
public class EnderStorage {
    @SidedProxy(clientSide="codechicken.enderstorage.internal.EnderStorageClientProxy", serverSide="codechicken.enderstorage.internal.EnderStorageProxy")
    public static EnderStorageProxy proxy;
    public static ConfigFile config;
    public static BlockEnderStorage blockEnderChest;
    public static ItemEnderPouch itemEnderPouch;
    public static Item personalItem;
    public static boolean disableVanillaEnderChest;
    public static boolean removeVanillaRecipe;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new ConfigFile(new File(CommonUtils.getMinecraftDir() + "/config", "EnderStorage.cfg")).setComment("EnderStorage Configuration File\nDeleting any element will restore it to it's default value\nBlock ID's will be automatically generated the first time it's run");
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.loadPersonalItem();
        disableVanillaEnderChest = config.getTag("disable-vanilla").setComment("Set to true to make the vanilla enderchest unplaceable.").getBooleanValue(true);
        removeVanillaRecipe = config.getTag("disable-vanilla_recipe").setComment("Set to true to make the vanilla enderchest uncraftable.").getBooleanValue(false);
        EnderStorageManager.loadConfig(config);
        EnderStorageManager.registerPlugin(new EnderItemStoragePlugin());
        EnderStorageManager.registerPlugin(new EnderLiquidStoragePlugin());
        proxy.init();
    }

    private void loadPersonalItem() {
        ConfigTag tag = config.getTag("personalItemID").setComment("The name of the item used to set the chest to personal. Diamond by default");
        String name = tag.getValue("diamond");
        personalItem = (Item)Item.field_150901_e.func_82594_a(name);
        if (personalItem == null) {
            personalItem = Items.field_151045_i;
            tag.setValue("diamond");
        }
    }

    @Mod.EventHandler
    public void registerCommands(FMLServerStartingEvent event) {
        CommandHandler commandManager = (CommandHandler)event.getServer().func_71187_D();
        commandManager.func_71560_a((ICommand)new CommandEnderStorage());
    }

    public static ItemStack getPersonalItem() {
        return new ItemStack(personalItem, 1, 0);
    }
}

