/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.block;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.handler.ConfigurationHandler;
import codechicken.enderstorage.init.EnderStorageRecipe;
import codechicken.enderstorage.reference.VariantReference;
import codechicken.enderstorage.repack.covers1624.lib.api.block.property.PropertyString;
import codechicken.enderstorage.tile.TileEnderChest;
import codechicken.enderstorage.tile.TileEnderTank;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.raytracer.ExtendedMOP;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEnderStorage
extends Block
implements ITileEntityProvider {
    private RayTracer rayTracer = new RayTracer();
    public static final PropertyString VARIANTS = new PropertyString("type", VariantReference.enderBlockNamesList);

    public BlockEnderStorage() {
        super(Material.field_151576_e);
        this.func_149711_c(20.0f);
        this.func_149752_b(100.0f);
        this.func_149647_a(CreativeTabs.field_78029_e);
        this.func_149663_c("enderStorage");
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        switch (meta) {
            case 0: {
                return new TileEnderChest();
            }
            case 1: {
                return new TileEnderTank();
            }
        }
        return null;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileFrequencyOwner tile = (TileFrequencyOwner)world.func_175625_s(pos);
        if (tile != null) {
            ret.add(this.createItem(state.func_177230_c().func_176201_c(state), tile.frequency));
            if (ConfigurationHandler.anarchyMode && tile.frequency.hasOwner()) {
                ret.add(ConfigurationHandler.personalItem.func_77946_l());
            }
        }
        return ret;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult rayTraceResult, World world, BlockPos pos, EntityPlayer player) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.func_175625_s(pos);
        return this.createItem(this.func_176201_c(state), tile.frequency);
    }

    private ItemStack createItem(int meta, Frequency freq) {
        ItemStack stack = new ItemStack((Block)this, 1, meta);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (ConfigurationHandler.anarchyMode) {
            freq.setOwner(null);
        }
        NBTTagCompound frequencyTag = new NBTTagCompound();
        freq.writeNBT(frequencyTag);
        stack.func_77978_p().func_74782_a("Frequency", (NBTBase)frequencyTag);
        return stack;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack item;
        int dye;
        if (world.field_72995_K) {
            return true;
        }
        TileFrequencyOwner tile = (TileFrequencyOwner)world.func_175625_s(pos);
        RayTraceResult hit = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (BlockPos)pos);
        ExtendedMOP subHitResult = this.rayTracer.rayTraceCuboids(new Vector3(RayTracer.getStartVec((EntityPlayer)player)), new Vector3(RayTracer.getEndVec((EntityPlayer)player)), tile.getIndexedCuboids(), new BlockCoord(pos));
        if (subHitResult != null) {
            hit = subHitResult;
        }
        if (hit.subHit == 4) {
            ItemStack item2 = player.field_71071_by.func_70448_g();
            if (player.func_70093_af() && tile.frequency.hasOwner()) {
                if (!player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_70441_a(ConfigurationHandler.personalItem.func_77946_l())) {
                    return false;
                }
                tile.frequency.setOwner(null);
                return true;
            }
            if (item2 != null && BlockEnderStorage.areStacksSameTypeCrafting(item2, ConfigurationHandler.personalItem) && !tile.frequency.hasOwner()) {
                tile.frequency.setOwner(player.getDisplayNameString());
                if (!player.field_71075_bZ.field_75098_d) {
                    --item2.field_77994_a;
                }
                return true;
            }
        } else if (hit.subHit >= 1 && hit.subHit <= 3 && (dye = EnderStorageRecipe.getDyeType(item = player.field_71071_by.func_70448_g())) != -1) {
            int[] colours = tile.frequency.toArray();
            if (colours[hit.subHit - 1] == (~dye & 0xF)) {
                return false;
            }
            colours[hit.subHit - 1] = ~dye & 0xF;
            tile.setFreq(Frequency.fromArray(colours));
            if (!player.field_71075_bZ.field_75098_d) {
                --item.field_77994_a;
            }
            return true;
        }
        return tile.activate(player, hit.subHit);
    }

    public static boolean areStacksSameTypeCrafting(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b() && (stack1.func_77952_i() == stack2.func_77952_i() || stack1.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE || stack1.func_77973_b().func_77645_m());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        ((TileFrequencyOwner)world.func_175625_s(pos)).onPlaced(placer);
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.func_175625_s(pos);
        if (tile == null) {
            return null;
        }
        List cuboids = tile.getIndexedCuboids();
        cuboids.add(tile.getBlockBounds());
        RayTraceResult hit = null;
        if (hit == null) {
            return super.func_180636_a(state, world, pos, start, end);
        }
        return hit;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
        TileFrequencyOwner tile = (TileFrequencyOwner)worldIn.func_175625_s(pos);
        if (tile != null) {
            BlockEnderStorage.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)tile.getBlockBounds().aabb());
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileFrequencyOwner tile = (TileFrequencyOwner)source.func_175625_s(pos);
        if (tile != null) {
            return tile.getBlockBounds().aabb();
        }
        return super.func_185496_a(state, source, pos);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> list) {
        list.add(new ItemStack((Block)this, 1, 0));
        list.add(new ItemStack((Block)this, 1, 1));
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFrequencyOwner) {
            return ((TileFrequencyOwner)tile).getLightValue();
        }
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANTS});
    }

    public int func_176201_c(IBlockState state) {
        return VariantReference.enderBlockNamesList.indexOf(String.valueOf(state.func_177229_b((IProperty)VARIANTS)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANTS, (Comparable)((Object)VariantReference.enderBlockNamesList.get(meta)));
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.func_175625_s(pos);
        return tile.redstoneInteraction();
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.func_175625_s(pos);
        return tile.comparatorInput();
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.func_175625_s(pos);
        return tile.rotate();
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        super.func_189539_a(state, worldIn, pos, eventID, eventParam);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(eventID, eventParam);
    }
}

