/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.client;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.client.EnderPouchModelLoader;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.storage.EnderItemStorage;
import codechicken.enderstorage.util.LogHelper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class BakedEnderPouchOverrideHandler
extends ItemOverrideList {
    public static final BakedEnderPouchOverrideHandler INSTANCE = new BakedEnderPouchOverrideHandler();

    public BakedEnderPouchOverrideHandler() {
        super((List)ImmutableList.of());
    }

    public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
        Frequency frequency = Frequency.fromItemStack(stack);
        EnderItemStorage storage = (EnderItemStorage)EnderStorageManager.instance(true).getStorage(frequency, "item");
        String key = frequency.toModelLoc() + ",open=" + (storage.openCount() > 0);
        IBakedModel pouchModel = EnderPouchModelLoader.getModel(key);
        if (pouchModel == null) {
            LogHelper.warn("Unable to get pouch model for key [%s]!", key);
            return originalModel;
        }
        return pouchModel;
    }
}

